/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.patch;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;

public class ApplyMojo
extends AbstractMojo {
    public static final List PATCH_FAILURE_WATCH_PHRASES;
    public static final List DEFAULT_IGNORED_PATCHES;
    public static final List DEFAULT_IGNORED_PATCH_PATTERNS;
    private boolean useDefaultIgnores;
    protected List patches;
    private boolean skipApplication;
    private boolean optimizations;
    private File patchTrackingFile;
    private File targetDirectory;
    private boolean failFast;
    private boolean naturalOrderProcessing;
    private List ignoredPatches;
    private boolean strictPatching;
    private int strip;
    private boolean ignoreWhitespace;
    private boolean reverse;
    private boolean backups;
    private List failurePhrases = PATCH_FAILURE_WATCH_PHRASES;
    private File originalFile;
    private File destFile;
    private File patchFile;
    private File patchDirectory;
    private boolean removeEmptyFiles;

    public void execute() throws MojoExecutionException, MojoFailureException {
        boolean patchFileEnabled;
        boolean patchDirEnabled = this.patches != null && !this.patches.isEmpty() || this.naturalOrderProcessing;
        boolean bl = patchFileEnabled = this.patchFile != null;
        if (!patchFileEnabled && !patchDirEnabled) {
            this.getLog().info((CharSequence)"Patching is disabled for this project.");
            return;
        }
        if (this.skipApplication) {
            this.getLog().info((CharSequence)"Skipping patch file application (per configuration).");
            return;
        }
        this.patchTrackingFile.getParentFile().mkdirs();
        Map patchesToApply = null;
        try {
            if (patchFileEnabled) {
                patchesToApply = Collections.singletonMap(this.patchFile.getName(), this.createPatchCommand(this.patchFile));
            } else {
                if (!this.patchDirectory.isDirectory()) {
                    throw new FileNotFoundException("The base directory for patch files does not exist: " + this.patchDirectory);
                }
                List foundPatchFiles = FileUtils.getFileNames((File)this.patchDirectory, (String)"*", null, (boolean)false);
                patchesToApply = this.findPatchesToApply(foundPatchFiles, this.patchDirectory);
                this.checkStrictPatchCompliance(foundPatchFiles);
            }
            String output = this.applyPatches(patchesToApply);
            this.checkForWatchPhrases(output);
            this.writeTrackingFile(patchesToApply);
        }
        catch (IOException ioe) {
            throw new MojoExecutionException("Unable to obtain list of patch files", (Exception)ioe);
        }
    }

    private Map findPatchesToApply(List foundPatchFiles, File patchSourceDir) throws MojoFailureException {
        LinkedHashMap<String, Commandline> patchesApplied = new LinkedHashMap<String, Commandline>();
        if (this.naturalOrderProcessing) {
            this.patches = new ArrayList(foundPatchFiles);
            Collections.sort(this.patches);
        }
        String alreadyAppliedPatches = "";
        try {
            if (this.optimizations && this.patchTrackingFile.exists()) {
                alreadyAppliedPatches = FileUtils.fileRead((File)this.patchTrackingFile);
            }
        }
        catch (IOException ioe) {
            throw new MojoFailureException("unable to read patch tracking file: " + ioe.getMessage());
        }
        Iterator it = this.patches.iterator();
        while (it.hasNext()) {
            String patch = (String)it.next();
            if (alreadyAppliedPatches.indexOf(patch) != -1) continue;
            File patchFile = new File(patchSourceDir, patch);
            this.getLog().debug((CharSequence)("Looking for patch: " + patch + " in: " + patchFile));
            if (!patchFile.exists()) {
                if (this.strictPatching) {
                    throw new MojoFailureException((Object)this, "Patch operation cannot proceed.", "Cannot find specified patch: '" + patch + "' in patch-source directory: '" + patchSourceDir + "'.\n\nEither fix this error, " + "or relax strictPatching.");
                }
                this.getLog().info((CharSequence)("Skipping patch: " + patch + " listed in the parameter \"patches\"; " + "it is missing."));
                continue;
            }
            foundPatchFiles.remove(patch);
            patchesApplied.put(patch, this.createPatchCommand(patchFile));
        }
        return patchesApplied;
    }

    private void checkStrictPatchCompliance(List foundPatchFiles) throws MojoExecutionException {
        if (this.strictPatching) {
            ArrayList ignored = new ArrayList();
            if (this.ignoredPatches != null) {
                ignored.addAll(this.ignoredPatches);
            }
            if (this.useDefaultIgnores) {
                ignored.addAll(DEFAULT_IGNORED_PATCHES);
            }
            ArrayList limbo = new ArrayList(foundPatchFiles);
            Iterator it = ignored.iterator();
            while (it.hasNext()) {
                String ignoredFile = (String)it.next();
                limbo.remove(ignoredFile);
            }
            if (!limbo.isEmpty()) {
                StringBuffer extraFileBuffer = new StringBuffer();
                extraFileBuffer.append("Found " + limbo.size() + " unlisted patch files:");
                Iterator it2 = foundPatchFiles.iterator();
                while (it2.hasNext()) {
                    String patch = (String)it2.next();
                    extraFileBuffer.append("\n  '").append(patch).append('\'');
                }
                extraFileBuffer.append("\n\nEither remove these files, add them to the patches configuration list, or relax strictPatching.");
                throw new MojoExecutionException(extraFileBuffer.toString());
            }
        }
    }

    private String applyPatches(Map patchesApplied) throws MojoExecutionException {
        final StringWriter outputWriter = new StringWriter();
        StreamConsumer consumer = new StreamConsumer(){

            public void consumeLine(String line) {
                if (ApplyMojo.this.getLog().isDebugEnabled()) {
                    ApplyMojo.this.getLog().debug((CharSequence)line);
                }
                outputWriter.write(line + "\n");
            }
        };
        ArrayList<String> failedPatches = new ArrayList<String>();
        Iterator it = patchesApplied.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            String patchName = (String)entry.getKey();
            Commandline cli = (Commandline)entry.getValue();
            try {
                this.getLog().info((CharSequence)("Applying patch: " + patchName));
                int result = this.executeCommandLine(cli, consumer, consumer);
                if (result == 0) continue;
                if (this.failFast) {
                    throw new MojoExecutionException("Patch command failed with exit code " + result + " for " + patchName + ". Please see console and debug output for more information.");
                }
                failedPatches.add(patchName);
            }
            catch (CommandLineException e) {
                throw new MojoExecutionException("Failed to apply patch: " + patchName + ". See debug output for more information.", (Exception)((Object)e));
            }
        }
        if (!failedPatches.isEmpty()) {
            this.getLog().error((CharSequence)"Failed applying one or more patches:");
            it = failedPatches.iterator();
            while (it.hasNext()) {
                this.getLog().error((CharSequence)("* " + it.next()));
            }
            throw new MojoExecutionException("Patch command failed for one or more patches. Please see console and debug output for more information.");
        }
        return outputWriter.toString();
    }

    private int executeCommandLine(Commandline cli, StreamConsumer out, StreamConsumer err) throws CommandLineException {
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("Executing: " + cli));
        }
        int result = CommandLineUtils.executeCommandLine((Commandline)cli, (StreamConsumer)out, (StreamConsumer)err);
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("Exit code: " + result));
        }
        return result;
    }

    private void writeTrackingFile(Map patchesApplied) throws MojoExecutionException {
        FileWriter writer = null;
        try {
            boolean appending = this.patchTrackingFile.exists();
            writer = new FileWriter(this.patchTrackingFile, appending);
            Iterator it = patchesApplied.keySet().iterator();
            while (it.hasNext()) {
                if (appending) {
                    writer.write(System.getProperty("line.separator"));
                }
                String patch = (String)it.next();
                writer.write(patch);
                if (!it.hasNext()) continue;
                writer.write(System.getProperty("line.separator"));
            }
            writer.flush();
        }
        catch (IOException e) {
            try {
                throw new MojoExecutionException("Failed to write patch-tracking file: " + this.patchTrackingFile, (Exception)e);
            }
            catch (Throwable throwable) {
                IOUtil.close(writer);
                throw throwable;
            }
        }
        IOUtil.close((Writer)writer);
    }

    private void checkForWatchPhrases(String output) throws MojoExecutionException {
        Iterator it = this.failurePhrases.iterator();
        while (it.hasNext()) {
            String phrase = (String)it.next();
            if (output.indexOf(phrase) <= -1) continue;
            throw new MojoExecutionException("Failed to apply patches (detected watch-phrase: '" + phrase + "' in output). " + "If this is in error, configure the patchFailureWatchPhrases parameter.");
        }
    }

    private Commandline createPatchCommand(File patchFile) {
        Commandline cli = new Commandline();
        cli.setExecutable("patch");
        cli.setWorkingDirectory(this.targetDirectory.getAbsolutePath());
        cli.createArg().setValue("-p" + this.strip);
        if (this.ignoreWhitespace) {
            cli.createArg().setValue("-l");
        }
        if (this.reverse) {
            cli.createArg().setValue("-R");
        }
        if (this.backups) {
            cli.createArg().setValue("-b");
        }
        if (this.removeEmptyFiles) {
            cli.createArg().setValue("-E");
        }
        cli.createArg().setValue("-i");
        cli.createArg().setFile(patchFile);
        if (this.destFile != null) {
            cli.createArg().setValue("-o");
            cli.createArg().setFile(this.destFile);
        }
        if (this.originalFile != null) {
            cli.createArg().setFile(this.originalFile);
        }
        return cli;
    }

    static {
        ArrayList<String> watches = new ArrayList<String>();
        watches.add("fail");
        watches.add("skip");
        watches.add("reject");
        PATCH_FAILURE_WATCH_PHRASES = watches;
        ArrayList<String> ignored = new ArrayList<String>();
        ignored.add(".svn");
        ignored.add("CVS");
        DEFAULT_IGNORED_PATCHES = ignored;
        ArrayList<String> ignoredPatterns = new ArrayList<String>();
        ignoredPatterns.add(".svn/**");
        ignoredPatterns.add("CVS/**");
        DEFAULT_IGNORED_PATCH_PATTERNS = ignoredPatterns;
    }
}

