/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.help;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.shared.artifact.ArtifactCoordinate;
import org.apache.maven.shared.artifact.DefaultArtifactCoordinate;
import org.apache.maven.shared.artifact.resolve.ArtifactResolver;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.WriterFactory;

public abstract class AbstractHelpMojo
extends AbstractMojo {
    protected static final int LINE_LENGTH = 79;
    protected static final String LS = System.getProperty("line.separator");
    @Component
    protected ProjectBuilder projectBuilder;
    @Component
    protected ArtifactResolver artifactResolver;
    @Parameter(defaultValue="${project.remoteArtifactRepositories}", required=true, readonly=true)
    protected List<ArtifactRepository> remoteRepositories;
    @Parameter(defaultValue="${localRepository}", required=true, readonly=true)
    protected ArtifactRepository localRepository;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    protected MavenSession session;
    @Parameter(property="output")
    protected File output;

    protected static void writeFile(File output, StringBuilder content) throws IOException {
        AbstractHelpMojo.writeFile(output, content.toString());
    }

    protected static void writeFile(File output, String content) throws IOException {
        if (output == null) {
            return;
        }
        Writer out = null;
        try {
            output.getParentFile().mkdirs();
            out = WriterFactory.newPlatformWriter((File)output);
            out.write(content);
            out.close();
            out = null;
        }
        catch (Throwable throwable) {
            IOUtil.close(out);
            throw throwable;
        }
        IOUtil.close((Writer)out);
    }

    protected ArtifactCoordinate getArtifactCoordinate(String artifactString, String type) throws MojoExecutionException {
        String version;
        String artifactId;
        String groupId;
        if (StringUtils.isEmpty((String)artifactString)) {
            throw new IllegalArgumentException("artifact parameter could not be empty");
        }
        String[] artifactParts = artifactString.split(":");
        switch (artifactParts.length) {
            case 2: {
                groupId = artifactParts[0];
                artifactId = artifactParts[1];
                version = "LATEST";
                break;
            }
            case 3: {
                groupId = artifactParts[0];
                artifactId = artifactParts[1];
                version = artifactParts[2];
                break;
            }
            default: {
                throw new MojoExecutionException("The artifact parameter '" + artifactString + "' should be conform to: 'groupId:artifactId[:version]'.");
            }
        }
        return this.getArtifactCoordinate(groupId, artifactId, version, type);
    }

    protected ArtifactCoordinate getArtifactCoordinate(String groupId, String artifactId, String version, String type) {
        DefaultArtifactCoordinate coordinate = new DefaultArtifactCoordinate();
        coordinate.setGroupId(groupId);
        coordinate.setArtifactId(artifactId);
        coordinate.setVersion(version);
        coordinate.setExtension(type);
        return coordinate;
    }

    protected MavenProject getMavenProject(String artifactString) throws MojoExecutionException {
        ArtifactCoordinate coordinate = this.getArtifactCoordinate(artifactString, "pom");
        try {
            DefaultProjectBuildingRequest pbr = new DefaultProjectBuildingRequest(this.session.getProjectBuildingRequest());
            pbr.setRemoteRepositories(this.remoteRepositories);
            pbr.setProject(null);
            pbr.setValidationLevel(0);
            pbr.setResolveDependencies(true);
            Artifact artifact = this.artifactResolver.resolveArtifact((ProjectBuildingRequest)pbr, coordinate).getArtifact();
            return this.projectBuilder.build(artifact.getFile(), (ProjectBuildingRequest)pbr).getProject();
        }
        catch (Exception e) {
            throw new MojoExecutionException("Unable to get the POM for the artifact '" + artifactString + "'. Verify the artifact parameter.", e);
        }
    }
}

