package org.apache.maven.plugin.changes;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

/**
 * Display help information on maven-changes-plugin.<br/> Call <pre>  mvn changes:help -Ddetail=true -Dgoal=&lt;goal-name&gt;</pre> to display parameter details.
 *
 * @version generated on Sun Dec 06 22:06:23 CET 2009
 * @author org.apache.maven.tools.plugin.generator.PluginHelpGenerator (version 2.5.1)
 * @goal help
 * @requiresProject false
 */
public class HelpMojo
    extends AbstractMojo
{
    /**
     * If <code>true</code>, display all settable properties for each goal.
     * 
     * @parameter expression="${detail}" default-value="false"
     */
    private boolean detail;

    /**
     * The name of the goal for which to show help. If unspecified, all goals will be displayed.
     * 
     * @parameter expression="${goal}"
     */
    private java.lang.String goal;

    /**
     * The maximum length of a display line, should be positive.
     * 
     * @parameter expression="${lineLength}" default-value="80"
     */
    private int lineLength;

    /**
     * The number of spaces per indentation level, should be positive.
     * 
     * @parameter expression="${indentSize}" default-value="2"
     */
    private int indentSize;


    /** {@inheritDoc} */
    public void execute()
        throws MojoExecutionException
    {
        if ( lineLength <= 0 )
        {
            getLog().warn( "The parameter 'lineLength' should be positive, using '80' as default." );
            lineLength = 80;
        }
        if ( indentSize <= 0 )
        {
            getLog().warn( "The parameter 'indentSize' should be positive, using '2' as default." );
            indentSize = 2;
        }

        StringBuffer sb = new StringBuffer();

        append( sb, "org.apache.maven.plugins:maven-changes-plugin:2.3", 0 );
        append( sb, "", 0 );

        append( sb, "Maven Changes Report Plugin", 0 );
        append( sb, "Creates a release history for inclusion into the site and assists in generating an announcement mail.", 1 );
        append( sb, "", 0 );

        if ( goal == null || goal.length() <= 0 )
        {
            append( sb, "This plugin has 7 goals:", 0 );
            append( sb, "", 0 );
        }

        if ( goal == null || goal.length() <= 0 || "announcement-generate".equals( goal ) )
        {
            append( sb, "changes:announcement-generate", 0 );
            append( sb, "Goal which generate the template for an announcement.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "announceParameters", 2 );
                append( sb, "Map of custom parameters for the announcement. This Map will be passed to the template.", 3 );
                append( sb, "", 0 );

                append( sb, "basedir", 2 );
                append( sb, "The current project base directory.", 3 );
                append( sb, "", 0 );

                append( sb, "developmentTeam (Default: ${project.name} team)", 2 );
                append( sb, "Name of the team that develops the artifact. This parameter will be passed to the template.", 3 );
                append( sb, "", 0 );

                append( sb, "finalName (Default: ${project.build.finalName})", 2 );
                append( sb, "The name of the artifact to be used in the announcement.", 3 );
                append( sb, "", 0 );

                append( sb, "generateJiraAnnouncement (Default: false)", 2 );
                append( sb, "Flag to determine if the plugin will generate a JIRA announcement.", 3 );
                append( sb, "", 0 );

                append( sb, "introduction (Default: ${project.description})", 2 );
                append( sb, "Short description or introduction of the released artifact. This parameter will be passed to the template.", 3 );
                append( sb, "", 0 );

                append( sb, "jiraMerge (Default: false)", 2 );
                append( sb, "If releases from JIRA should be merged with the releases from a changes.xml file.", 3 );
                append( sb, "", 0 );

                append( sb, "jiraPassword", 2 );
                append( sb, "Defines the JIRA password for authentication into a private JIRA installation.", 3 );
                append( sb, "", 0 );

                append( sb, "jiraUser", 2 );
                append( sb, "Defines the JIRA username for authentication into a private JIRA installation.", 3 );
                append( sb, "", 0 );

                append( sb, "maxEntries (Default: 25)", 2 );
                append( sb, "The maximum number of issues to fetch from JIRA.\nNote: In versions 2.0-beta-3 and earlier this parameter was called \'nbEntries\'.\n", 3 );
                append( sb, "", 0 );

                append( sb, "outputDirectory", 2 );
                append( sb, "Directory where the template file will be generated.", 3 );
                append( sb, "", 0 );

                append( sb, "resolutionIds (Default: Fixed)", 2 );
                append( sb, "Include issues from JIRA with these resolution ids. Multiple resolution ids can be specified as a comma separated list of ids.\nNote: In versions 2.0-beta-3 and earlier this parameter was called \'resolutionId\'.\n", 3 );
                append( sb, "", 0 );

                append( sb, "runOnlyAtExecutionRoot (Default: false)", 2 );
                append( sb, "This will cause the execution to be run only at the top of a given module tree. That is, run in the project contained in the same folder where the mvn execution was launched.", 3 );
                append( sb, "", 0 );

                append( sb, "statusIds (Default: Closed)", 2 );
                append( sb, "Include issues from JIRA with these status ids. Multiple status ids can be specified as a comma separated list of ids.\nNote: In versions 2.0-beta-3 and earlier this parameter was called \'statusId\'.\n", 3 );
                append( sb, "", 0 );

                append( sb, "template (Default: announcement.vm)", 2 );
                append( sb, "The Velocity template used to format the announcement.", 3 );
                append( sb, "", 0 );

                append( sb, "templateDirectory (Default: org/apache/maven/plugin/announcement)", 2 );
                append( sb, "Directory that contains the template.\nNote: This directory must be a subdirectory of /src/main/resources/ or current project base directory.\n", 3 );
                append( sb, "", 0 );

                append( sb, "templateEncoding (Default: ${project.build.sourceEncoding})", 2 );
                append( sb, "The template encoding.", 3 );
                append( sb, "", 0 );

                append( sb, "url", 2 );
                append( sb, "Distribution URL of the artifact. This parameter will be passed to the template.", 3 );
                append( sb, "", 0 );

                append( sb, "urlDownload", 2 );
                append( sb, "URL where the artifact can be downloaded. If not specified, no URL is used. This parameter will be passed to the template.", 3 );
                append( sb, "", 0 );

                append( sb, "version (Default: ${project.version})", 2 );
                append( sb, "Version of the artifact.", 3 );
                append( sb, "", 0 );

                append( sb, "xmlPath", 2 );
                append( sb, "The path of the changes.xml file.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "announcement-mail".equals( goal ) )
        {
            append( sb, "changes:announcement-mail", 0 );
            append( sb, "Goal which sends an announcement through email.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "basedir", 2 );
                append( sb, "The current project base directory.", 3 );
                append( sb, "", 0 );

                append( sb, "fromDeveloperId", 2 );
                append( sb, "The id of the developer sending the announcement mail. Only used if the mailSender attribute is not set. In this case, this should match the id of one of the developers in the pom. If a matching developer is not found, then the first developer in the pom will be used.", 3 );
                append( sb, "", 0 );

                append( sb, "mailContentType (Default: text/plain)", 2 );
                append( sb, "Mail content type to use.", 3 );
                append( sb, "", 0 );

                append( sb, "mailSender", 2 );
                append( sb, "Defines the sender of the announcement if the list of developer is empty or if the sender is not a member of the development team.", 3 );
                append( sb, "", 0 );

                append( sb, "password", 2 );
                append( sb, "The password used to send the email.", 3 );
                append( sb, "", 0 );

                append( sb, "runOnlyAtExecutionRoot (Default: false)", 2 );
                append( sb, "This will cause the execution to be run only at the top of a given module tree. That is, run in the project contained in the same folder where the mvn execution was launched.", 3 );
                append( sb, "", 0 );

                append( sb, "smtpHost", 2 );
                append( sb, "Smtp Server.", 3 );
                append( sb, "", 0 );

                append( sb, "smtpPort (Default: 25)", 2 );
                append( sb, "Port.", 3 );
                append( sb, "", 0 );

                append( sb, "sslMode (Default: false)", 2 );
                append( sb, "If the email should be sent in SSL mode.", 3 );
                append( sb, "", 0 );

                append( sb, "subject (Default: [ANNOUNCEMENT] - ${project.name} ${project.version} released)", 2 );
                append( sb, "Subject for the email.", 3 );
                append( sb, "", 0 );

                append( sb, "template (Default: announcement.vm)", 2 );
                append( sb, "The Velocity template used to format the announcement.", 3 );
                append( sb, "", 0 );

                append( sb, "templateOutputDirectory", 2 );
                append( sb, "Directory which contains the template for announcement email.", 3 );
                append( sb, "", 0 );

                append( sb, "toAddresses", 2 );
                append( sb, "Recipient email address.", 3 );
                append( sb, "", 0 );

                append( sb, "username", 2 );
                append( sb, "The username used to send the email.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "changes-report".equals( goal ) )
        {
            append( sb, "changes:changes-report", 0 );
            append( sb, "Goal which creates a nicely formatted Changes Report in html format from a changes.xml file.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "addActionDate (Default: false)", 2 );
                append( sb, "A flag whether the report should also include the dates of individual actions. If set to false, only the dates of releases will be written to the report.", 3 );
                append( sb, "", 0 );

                append( sb, "filteringChanges (Default: false)", 2 );
                append( sb, "applying filtering filtering \'a la\' resources plugin", 3 );
                append( sb, "", 0 );

                append( sb, "issueLinkTemplate (Default: %URL%/ViewIssue.jspa?key=%ISSUE%)", 2 );
                append( sb, "Deprecated. As of 2.1 use issueLinkTemplatePerSystem : this one will be with system default", 3 );
                append( sb, "", 0 );
                append( sb, "Template string that is used to discover the URL to use to display an issue report. There are 2 template tokens you can use. %URL%: this is computed by getting the <issueManagement>/<url> value from the POM, and removing the last \'/\' and everything that comes after it. %ISSUE%: this is the issue number.\nNote: In versions of this plugin prior to 2.0-beta-2 this parameter was called link_template.\n", 3 );
                append( sb, "", 0 );

                append( sb, "issueLinkTemplatePerSystem", 2 );
                append( sb, "Template strings per system that is used to discover the URL to use to display an issue report. Each key in this map denotes the (case-sensitive) identifier of the issue tracking system and its value gives the URL template.\nThere are 2 template tokens you can use. %URL%: this is computed by getting the <issueManagement>/<url> value from the POM, and removing the last \'/\' and everything that comes after it. %ISSUE%: this is the issue number.\n\nNote: The deprecated issueLinkTemplate will be used for a system called \'default\'.\n", 3 );
                append( sb, "", 0 );

                append( sb, "outputDirectory (Default: ${project.reporting.outputDirectory})", 2 );
                append( sb, "Report output directory. Note that this parameter is only relevant if the goal is run from the command line or from the default build lifecycle. If the goal is run indirectly as part of a site generation, the output directory configured in the Maven Site Plugin is used instead.", 3 );
                append( sb, "", 0 );

                append( sb, "publishDateFormat (Default: yyyy-MM-dd)", 2 );
                append( sb, "Format to use for publishDate. The value will be available with the following expression ${publishDate}", 3 );
                append( sb, "", 0 );

                append( sb, "publishDateLocale (Default: en)", 2 );
                append( sb, "Locale to use for publishDate when formatting", 3 );
                append( sb, "", 0 );

                append( sb, "xmlPath (Default: src/changes/changes.xml)", 2 );
                append( sb, "The path of the changes.xml file that will be converted into an HTML report.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "changes-validate".equals( goal ) )
        {
            append( sb, "changes:changes-validate", 0 );
            append( sb, "Goal which validate the changes.xml file.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "changesXsdVersion (Default: 1.0.0)", 2 );
                append( sb, "The changes xsd version.", 3 );
                append( sb, "", 0 );

                append( sb, "failOnError (Default: false)", 2 );
                append( sb, "Mojo failure if validation failed. If not and validation failed only a warning will be logged.", 3 );
                append( sb, "", 0 );

                append( sb, "xmlPath (Default: src/changes/changes.xml)", 2 );
                append( sb, "The path of the changes.xml file that will be converted into an HTML report.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "help".equals( goal ) )
        {
            append( sb, "changes:help", 0 );
            append( sb, "Display help information on maven-changes-plugin.\nCall\n\u00a0\u00a0mvn\u00a0changes:help\u00a0-Ddetail=true\u00a0-Dgoal=<goal-name>\nto display parameter details.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "detail (Default: false)", 2 );
                append( sb, "If true, display all settable properties for each goal.", 3 );
                append( sb, "", 0 );

                append( sb, "goal", 2 );
                append( sb, "The name of the goal for which to show help. If unspecified, all goals will be displayed.", 3 );
                append( sb, "", 0 );

                append( sb, "indentSize (Default: 2)", 2 );
                append( sb, "The number of spaces per indentation level, should be positive.", 3 );
                append( sb, "", 0 );

                append( sb, "lineLength (Default: 80)", 2 );
                append( sb, "The maximum length of a display line, should be positive.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "jira-report".equals( goal ) )
        {
            append( sb, "changes:jira-report", 0 );
            append( sb, "Goal which downloads issues from the Issue Tracking System and generates a report.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "columnNames (Default: Key,Summary,Status,Resolution,Assignee)", 2 );
                append( sb, "Sets the column names that you want to show in the report. The columns will appear in the report in the same order as you specify them here. Multiple values can be separated by commas.\nValid columns are: Key, Summary, Status, Resolution, Assignee, Reporter, Type, Priority, Version, Fix Version and Component.\n", 3 );
                append( sb, "", 0 );

                append( sb, "component", 2 );
                append( sb, "Sets the component(s) that you want to limit your report to include. Multiple values can be separated by commas (such as 10011,10012). If this is set to empty - that means all components will be included.", 3 );
                append( sb, "", 0 );

                append( sb, "filter", 2 );
                append( sb, "Defines the filter parameters to restrict which issues are retrieved from JIRA. The filter parameter uses the same format of url parameters that is used in a JIRA search.", 3 );
                append( sb, "", 0 );

                append( sb, "fixVersionIds", 2 );
                append( sb, "Sets the fix version id(s) that you want to limit your report to include. These are JIRA\'s internal version ids, NOT the human readable display ones. Multiple fix versions can be separated by commas. If this is set to empty - that means all fix versions will be included.", 3 );
                append( sb, "", 0 );

                append( sb, "jiraPassword", 2 );
                append( sb, "Defines the JIRA password for authentication into a private JIRA installation.", 3 );
                append( sb, "", 0 );

                append( sb, "jiraUser", 2 );
                append( sb, "Defines the JIRA username for authentication into a private JIRA installation.", 3 );
                append( sb, "", 0 );

                append( sb, "maxEntries (Default: 100)", 2 );
                append( sb, "Maximum number of entries to be fetched from JIRA.", 3 );
                append( sb, "", 0 );

                append( sb, "onlyCurrentVersion (Default: false)", 2 );
                append( sb, "If you only want to show issues for the current version in the report. The current version being used is ${project.version} minus any \'-SNAPSHOT\' suffix.", 3 );
                append( sb, "", 0 );

                append( sb, "outputDirectory (Default: ${project.reporting.outputDirectory})", 2 );
                append( sb, "Report output directory. Note that this parameter is only relevant if the goal is run from the command line or from the default build lifecycle. If the goal is run indirectly as part of a site generation, the output directory configured in the Maven Site Plugin is used instead.", 3 );
                append( sb, "", 0 );

                append( sb, "priorityIds", 2 );
                append( sb, "Sets the priority(s) that you want to limit your report to include. Valid statuses are Blocker, Critical, Major, Minor and Trivial. Multiple values can be separated by commas. If this is set to empty - that means all priorities will be included.", 3 );
                append( sb, "", 0 );

                append( sb, "resolutionIds (Default: Fixed)", 2 );
                append( sb, "Sets the resolution(s) that you want to fetch from JIRA. Valid resolutions are: Unresolved, Fixed, Won\'t Fix, Duplicate, Incomplete and Cannot Reproduce. Multiple values can be separated by commas.\nNote: In versions 2.0-beta-3 and earlier this parameter had no default value.\n", 3 );
                append( sb, "", 0 );

                append( sb, "sortColumnNames (Default: Priority DESC, Created DESC)", 2 );
                append( sb, "Sets the column names that you want to sort the report by. Add DESC following the column name to specify descending sequence. For example Fix Version DESC, Type sorts first by the Fix Version in descending order and then by Type in ascending order. By default sorting is done in ascending order, but is possible to specify ASC for consistency. The previous example would then become Fix Version DESC, Type ASC.\nValid columns are: Key, Summary, Status, Resolution, Assignee, Reporter, Type, Priority, Version, Fix Version, Component, Created and Updated.\n", 3 );
                append( sb, "", 0 );

                append( sb, "statusIds (Default: Closed)", 2 );
                append( sb, "Sets the status(es) that you want to fetch from JIRA. Valid statuses are: Open, In Progress, Reopened, Resolved and Closed. Multiple values can be separated by commas.\nNote: In versions 2.0-beta-3 and earlier this parameter had no default value.\n", 3 );
                append( sb, "", 0 );

                append( sb, "typeIds", 2 );
                append( sb, "Sets the types(s) that you want to limit your report to include. Valid types are: Bug, New Feature, Task, Improvement, Wish, Test and Sub-task. Multiple values can be separated by commas. If this is set to empty - that means all types will be included.", 3 );
                append( sb, "", 0 );

                append( sb, "webPassword", 2 );
                append( sb, "Defines the http password for basic authentication into the JIRA webserver.", 3 );
                append( sb, "", 0 );

                append( sb, "webUser", 2 );
                append( sb, "Defines the http user for basic authentication into the JIRA webserver.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "trac-report".equals( goal ) )
        {
            append( sb, "changes:trac-report", 0 );
            append( sb, "Goal which downloads issues from the Issue Tracking System and generates a report.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "columnNames (Default: id,type,summary,owner,reporter,priority,status,resolution,created,changed)", 2 );
                append( sb, "Sets the column names that you want to show in the report. The columns will appear in the report in the same order as you specify them here. Multiple values can be separated by commas.\nValid columns are: id, type, summary, status, resolution, milestone, owner, priority, reporter, component, created, changed.\n", 3 );
                append( sb, "", 0 );

                append( sb, "outputDirectory (Default: ${project.reporting.outputDirectory})", 2 );
                append( sb, "Report output directory. Note that this parameter is only relevant if the goal is run from the command line or from the default build lifecycle. If the goal is run indirectly as part of a site generation, the output directory configured in the Maven Site Plugin is used instead.", 3 );
                append( sb, "", 0 );

                append( sb, "query (Default: order=id)", 2 );
                append( sb, "Defines the Trac query for searching ticket.", 3 );
                append( sb, "", 0 );

                append( sb, "tracPassword", 2 );
                append( sb, "Defines the Trac password for authentication into a private Trac installation.", 3 );
                append( sb, "", 0 );

                append( sb, "tracUser", 2 );
                append( sb, "Defines the Trac username for authentication into a private Trac installation.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( getLog().isInfoEnabled() )
        {
            getLog().info( sb.toString() );
        }
    }

    /**
     * <p>Repeat a String <code>n</code> times to form a new string.</p>
     *
     * @param str String to repeat
     * @param repeat number of times to repeat str
     * @return String with repeated String
     * @throws NegativeArraySizeException if <code>repeat < 0</code>
     * @throws NullPointerException if str is <code>null</code>
     */
    private static String repeat( String str, int repeat )
    {
        StringBuffer buffer = new StringBuffer( repeat * str.length() );

        for ( int i = 0; i < repeat; i++ )
        {
            buffer.append( str );
        }

        return buffer.toString();
    }

    /** 
     * Append a description to the buffer by respecting the indentSize and lineLength parameters.
     * <b>Note</b>: The last character is always a new line.
     * 
     * @param sb The buffer to append the description, not <code>null</code>.
     * @param description The description, not <code>null</code>.
     * @param indent The base indentation level of each line, must not be negative.
     */
    private void append( StringBuffer sb, String description, int indent )
    {
        for ( Iterator it = toLines( description, indent, indentSize, lineLength ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( '\n' );
        }
    }

    /** 
     * Splits the specified text into lines of convenient display length.
     * 
     * @param text The text to split into lines, must not be <code>null</code>.
     * @param indent The base indentation level of each line, must not be negative.
     * @param indentSize The size of each indentation, must not be negative.
     * @param lineLength The length of the line, must not be negative.
     * @return The sequence of display lines, never <code>null</code>.
     * @throws NegativeArraySizeException if <code>indent < 0</code>
     */
    private static List toLines( String text, int indent, int indentSize, int lineLength )
    {
        List lines = new ArrayList();

        String ind = repeat( "\t", indent );
        String[] plainLines = text.split( "(\r\n)|(\r)|(\n)" );
        for ( int i = 0; i < plainLines.length; i++ )
        {
            toLines( lines, ind + plainLines[i], indentSize, lineLength );
        }

        return lines;
    }

    /** 
     * Adds the specified line to the output sequence, performing line wrapping if necessary.
     * 
     * @param lines The sequence of display lines, must not be <code>null</code>.
     * @param line The line to add, must not be <code>null</code>.
     * @param indentSize The size of each indentation, must not be negative.
     * @param lineLength The length of the line, must not be negative.
     */
    private static void toLines( List lines, String line, int indentSize, int lineLength )
    {
        int lineIndent = getIndentLevel( line );
        StringBuffer buf = new StringBuffer( 256 );
        String[] tokens = line.split( " +" );
        for ( int i = 0; i < tokens.length; i++ )
        {
            String token = tokens[i];
            if ( i > 0 )
            {
                if ( buf.length() + token.length() >= lineLength )
                {
                    lines.add( buf.toString() );
                    buf.setLength( 0 );
                    buf.append( repeat( " ", lineIndent * indentSize ) );
                }
                else
                {
                    buf.append( ' ' );
                }
            }
            for ( int j = 0; j < token.length(); j++ )
            {
                char c = token.charAt( j );
                if ( c == '\t' )
                {
                    buf.append( repeat( " ", indentSize - buf.length() % indentSize ) );
                }
                else if ( c == '\u00A0' )
                {
                    buf.append( ' ' );
                }
                else
                {
                    buf.append( c );
                }
            }
        }
        lines.add( buf.toString() );
    }

    /** 
     * Gets the indentation level of the specified line.
     * 
     * @param line The line whose indentation level should be retrieved, must not be <code>null</code>.
     * @return The indentation level of the line.
     */
    private static int getIndentLevel( String line )
    {
        int level = 0;
        for ( int i = 0; i < line.length() && line.charAt( i ) == '\t'; i++ )
        {
            level++;
        }
        for ( int i = level + 1; i <= level + 4 && i < line.length(); i++ )
        {
            if ( line.charAt( i ) == '\t' )
            {
                level++;
                break;
            }
        }
        return level;
    }
}
