// =================== DO NOT EDIT THIS FILE ====================
// Generated by Modello 2.0.0,
// any modifications will be overwritten.
// ==============================================================

package org.apache.maven.plugins.assembly.model.io.xpp3;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.text.DateFormat;
import org.apache.maven.plugins.assembly.model.Assembly;
import org.apache.maven.plugins.assembly.model.ContainerDescriptorHandlerConfig;
import org.apache.maven.plugins.assembly.model.DependencySet;
import org.apache.maven.plugins.assembly.model.FileItem;
import org.apache.maven.plugins.assembly.model.FileSet;
import org.apache.maven.plugins.assembly.model.ModuleBinaries;
import org.apache.maven.plugins.assembly.model.ModuleSet;
import org.apache.maven.plugins.assembly.model.ModuleSources;
import org.apache.maven.plugins.assembly.model.UnpackOptions;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.xml.pull.EntityReplacementMap;
import org.codehaus.plexus.util.xml.pull.MXParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

/**
 * Class AssemblyXpp3Reader.
 * 
 * @version $Revision$ $Date$
 */
@SuppressWarnings( "all" )
public class AssemblyXpp3Reader
{

      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * If set the parser will be loaded with all single characters
     * from the XHTML specification.
     * The entities used:
     * <ul>
     * <li>http://www.w3.org/TR/xhtml1/DTD/xhtml-lat1.ent</li>
     * <li>http://www.w3.org/TR/xhtml1/DTD/xhtml-special.ent</li>
     * <li>http://www.w3.org/TR/xhtml1/DTD/xhtml-symbol.ent</li>
     * </ul>
     */
    private boolean addDefaultEntities = true;

    /**
     * Field contentTransformer.
     */
    public final ContentTransformer contentTransformer;


      //----------------/
     //- Constructors -/
    //----------------/

    public AssemblyXpp3Reader()
    {
        this( new ContentTransformer()
        {
            public String transform( String source, String fieldName )
            {
                return source;
            }
        } );
    } //-- org.apache.maven.plugins.assembly.model.io.xpp3.AssemblyXpp3Reader()

    public AssemblyXpp3Reader(ContentTransformer contentTransformer)
    {
        this.contentTransformer = contentTransformer;
    } //-- org.apache.maven.plugins.assembly.model.io.xpp3.AssemblyXpp3Reader(ContentTransformer)


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method checkFieldWithDuplicate.
     * 
     * @param parser a parser object.
     * @param parsed a parsed object.
     * @param alias a alias object.
     * @param tagName a tagName object.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return boolean
     */
    private boolean checkFieldWithDuplicate( XmlPullParser parser, String tagName, String alias, java.util.Set parsed )
        throws XmlPullParserException
    {
        if ( !( parser.getName().equals( tagName ) || parser.getName().equals( alias ) ) )
        {
            return false;
        }
        if ( !parsed.add( tagName ) )
        {
            throw new XmlPullParserException( "Duplicated tag: '" + tagName + "'", parser, null );
        }
        return true;
    } //-- boolean checkFieldWithDuplicate( XmlPullParser, String, String, java.util.Set )

    /**
     * Method checkUnknownAttribute.
     * 
     * @param parser a parser object.
     * @param strict a strict object.
     * @param tagName a tagName object.
     * @param attribute a attribute object.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @throws IOException IOException if any.
     */
    private void checkUnknownAttribute( XmlPullParser parser, String attribute, String tagName, boolean strict )
        throws XmlPullParserException, IOException
    {
        // strictXmlAttributes = true for model: if strict == true, not only elements are checked but attributes too
        if ( strict )
        {
            throw new XmlPullParserException( "Unknown attribute '" + attribute + "' for tag '" + tagName + "'", parser, null );
        }
    } //-- void checkUnknownAttribute( XmlPullParser, String, String, boolean )

    /**
     * Method checkUnknownElement.
     * 
     * @param parser a parser object.
     * @param strict a strict object.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @throws IOException IOException if any.
     */
    private void checkUnknownElement( XmlPullParser parser, boolean strict )
        throws XmlPullParserException, IOException
    {
        if ( strict )
        {
            throw new XmlPullParserException( "Unrecognised tag: '" + parser.getName() + "'", parser, null );
        }

        for ( int unrecognizedTagCount = 1; unrecognizedTagCount > 0; )
        {
            int eventType = parser.next();
            if ( eventType == XmlPullParser.START_TAG )
            {
                unrecognizedTagCount++;
            }
            else if ( eventType == XmlPullParser.END_TAG )
            {
                unrecognizedTagCount--;
            }
        }
    } //-- void checkUnknownElement( XmlPullParser, boolean )

    /**
     * Returns the state of the "add default entities" flag.
     * 
     * @return boolean
     */
    public boolean getAddDefaultEntities()
    {
        return addDefaultEntities;
    } //-- boolean getAddDefaultEntities()

    /**
     * Method getBooleanValue.
     * 
     * @param s a s object.
     * @param parser a parser object.
     * @param attribute a attribute object.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return boolean
     */
    private boolean getBooleanValue( String s, String attribute, XmlPullParser parser )
        throws XmlPullParserException
    {
        return getBooleanValue( s, attribute, parser, null );
    } //-- boolean getBooleanValue( String, String, XmlPullParser )

    /**
     * Method getBooleanValue.
     * 
     * @param s a s object.
     * @param defaultValue a defaultValue object.
     * @param parser a parser object.
     * @param attribute a attribute object.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return boolean
     */
    private boolean getBooleanValue( String s, String attribute, XmlPullParser parser, String defaultValue )
        throws XmlPullParserException
    {
        if ( s != null && s.length() != 0 )
        {
            return Boolean.valueOf( s ).booleanValue();
        }
        if ( defaultValue != null )
        {
            return Boolean.valueOf( defaultValue ).booleanValue();
        }
        return false;
    } //-- boolean getBooleanValue( String, String, XmlPullParser, String )

    /**
     * Method getByteValue.
     * 
     * @param s a s object.
     * @param strict a strict object.
     * @param parser a parser object.
     * @param attribute a attribute object.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return byte
     */
    private byte getByteValue( String s, String attribute, XmlPullParser parser, boolean strict )
        throws XmlPullParserException
    {
        if ( s != null )
        {
            try
            {
                return Byte.valueOf( s ).byteValue();
            }
            catch ( NumberFormatException nfe )
            {
                if ( strict )
                {
                    throw new XmlPullParserException( "Unable to parse element '" + attribute + "', must be a byte", parser, nfe );
                }
            }
        }
        return 0;
    } //-- byte getByteValue( String, String, XmlPullParser, boolean )

    /**
     * Method getCharacterValue.
     * 
     * @param s a s object.
     * @param parser a parser object.
     * @param attribute a attribute object.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return char
     */
    private char getCharacterValue( String s, String attribute, XmlPullParser parser )
        throws XmlPullParserException
    {
        if ( s != null )
        {
            return s.charAt( 0 );
        }
        return 0;
    } //-- char getCharacterValue( String, String, XmlPullParser )

    /**
     * Method getDateValue.
     * 
     * @param s a s object.
     * @param parser a parser object.
     * @param attribute a attribute object.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return Date
     */
    private java.util.Date getDateValue( String s, String attribute, XmlPullParser parser )
        throws XmlPullParserException
    {
        return getDateValue( s, attribute, null, parser );
    } //-- java.util.Date getDateValue( String, String, XmlPullParser )

    /**
     * Method getDateValue.
     * 
     * @param s a s object.
     * @param parser a parser object.
     * @param dateFormat a dateFormat object.
     * @param attribute a attribute object.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return Date
     */
    private java.util.Date getDateValue( String s, String attribute, String dateFormat, XmlPullParser parser )
        throws XmlPullParserException
    {
        if ( s != null )
        {
            String effectiveDateFormat = dateFormat;
            if ( dateFormat == null )
            {
                effectiveDateFormat = "yyyy-MM-dd'T'HH:mm:ss.SSS";
            }
            if ( "long".equals( effectiveDateFormat ) )
            {
                try
                {
                    return new java.util.Date( Long.parseLong( s ) );
                }
                catch ( NumberFormatException e )
                {
                    throw new XmlPullParserException( e.getMessage(), parser, e );
                }
            }
            else
            {
                try
                {
                    DateFormat dateParser = new java.text.SimpleDateFormat( effectiveDateFormat, java.util.Locale.US );
                    return dateParser.parse( s );
                }
                catch ( java.text.ParseException e )
                {
                    throw new XmlPullParserException( e.getMessage(), parser, e );
                }
            }
        }
        return null;
    } //-- java.util.Date getDateValue( String, String, String, XmlPullParser )

    /**
     * Method getDoubleValue.
     * 
     * @param s a s object.
     * @param strict a strict object.
     * @param parser a parser object.
     * @param attribute a attribute object.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return double
     */
    private double getDoubleValue( String s, String attribute, XmlPullParser parser, boolean strict )
        throws XmlPullParserException
    {
        if ( s != null )
        {
            try
            {
                return Double.valueOf( s ).doubleValue();
            }
            catch ( NumberFormatException nfe )
            {
                if ( strict )
                {
                    throw new XmlPullParserException( "Unable to parse element '" + attribute + "', must be a floating point number", parser, nfe );
                }
            }
        }
        return 0;
    } //-- double getDoubleValue( String, String, XmlPullParser, boolean )

    /**
     * Method getFloatValue.
     * 
     * @param s a s object.
     * @param strict a strict object.
     * @param parser a parser object.
     * @param attribute a attribute object.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return float
     */
    private float getFloatValue( String s, String attribute, XmlPullParser parser, boolean strict )
        throws XmlPullParserException
    {
        if ( s != null )
        {
            try
            {
                return Float.valueOf( s ).floatValue();
            }
            catch ( NumberFormatException nfe )
            {
                if ( strict )
                {
                    throw new XmlPullParserException( "Unable to parse element '" + attribute + "', must be a floating point number", parser, nfe );
                }
            }
        }
        return 0;
    } //-- float getFloatValue( String, String, XmlPullParser, boolean )

    /**
     * Method getIntegerValue.
     * 
     * @param s a s object.
     * @param strict a strict object.
     * @param parser a parser object.
     * @param attribute a attribute object.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return int
     */
    private int getIntegerValue( String s, String attribute, XmlPullParser parser, boolean strict )
        throws XmlPullParserException
    {
        if ( s != null )
        {
            try
            {
                return Integer.valueOf( s ).intValue();
            }
            catch ( NumberFormatException nfe )
            {
                if ( strict )
                {
                    throw new XmlPullParserException( "Unable to parse element '" + attribute + "', must be an integer", parser, nfe );
                }
            }
        }
        return 0;
    } //-- int getIntegerValue( String, String, XmlPullParser, boolean )

    /**
     * Method getLongValue.
     * 
     * @param s a s object.
     * @param strict a strict object.
     * @param parser a parser object.
     * @param attribute a attribute object.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return long
     */
    private long getLongValue( String s, String attribute, XmlPullParser parser, boolean strict )
        throws XmlPullParserException
    {
        if ( s != null )
        {
            try
            {
                return Long.valueOf( s ).longValue();
            }
            catch ( NumberFormatException nfe )
            {
                if ( strict )
                {
                    throw new XmlPullParserException( "Unable to parse element '" + attribute + "', must be a long integer", parser, nfe );
                }
            }
        }
        return 0;
    } //-- long getLongValue( String, String, XmlPullParser, boolean )

    /**
     * Method getRequiredAttributeValue.
     * 
     * @param s a s object.
     * @param strict a strict object.
     * @param parser a parser object.
     * @param attribute a attribute object.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return String
     */
    private String getRequiredAttributeValue( String s, String attribute, XmlPullParser parser, boolean strict )
        throws XmlPullParserException
    {
        if ( s == null )
        {
            if ( strict )
            {
                throw new XmlPullParserException( "Missing required value for attribute '" + attribute + "'", parser, null );
            }
        }
        return s;
    } //-- String getRequiredAttributeValue( String, String, XmlPullParser, boolean )

    /**
     * Method getShortValue.
     * 
     * @param s a s object.
     * @param strict a strict object.
     * @param parser a parser object.
     * @param attribute a attribute object.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return short
     */
    private short getShortValue( String s, String attribute, XmlPullParser parser, boolean strict )
        throws XmlPullParserException
    {
        if ( s != null )
        {
            try
            {
                return Short.valueOf( s ).shortValue();
            }
            catch ( NumberFormatException nfe )
            {
                if ( strict )
                {
                    throw new XmlPullParserException( "Unable to parse element '" + attribute + "', must be a short integer", parser, nfe );
                }
            }
        }
        return 0;
    } //-- short getShortValue( String, String, XmlPullParser, boolean )

    /**
     * Method getTrimmedValue.
     * 
     * @param s a s object.
     * @return String
     */
    private String getTrimmedValue( String s )
    {
        if ( s != null )
        {
            s = s.trim();
        }
        return s;
    } //-- String getTrimmedValue( String )

    /**
     * Method interpolatedTrimmed.
     * 
     * @param value a value object.
     * @param context a context object.
     * @return String
     */
    private String interpolatedTrimmed( String value, String context )
    {
        return getTrimmedValue( contentTransformer.transform( value, context ) );
    } //-- String interpolatedTrimmed( String, String )

    /**
     * Method nextTag.
     * 
     * @param parser a parser object.
     * @throws IOException IOException if any.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return int
     */
    private int nextTag( XmlPullParser parser )
        throws IOException, XmlPullParserException
    {
        int eventType = parser.next();
        if ( eventType == XmlPullParser.TEXT )
        {
            eventType = parser.next();
        }
        if ( eventType != XmlPullParser.START_TAG && eventType != XmlPullParser.END_TAG )
        {
            throw new XmlPullParserException( "expected START_TAG or END_TAG not " + XmlPullParser.TYPES[eventType], parser, null );
        }
        return eventType;
    } //-- int nextTag( XmlPullParser )

    /**
     * @see ReaderFactory#newXmlReader
     * 
     * @param reader a reader object.
     * @param strict a strict object.
     * @throws IOException IOException if any.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return Assembly
     */
    public Assembly read( Reader reader, boolean strict )
        throws IOException, XmlPullParserException
    {
        XmlPullParser parser = addDefaultEntities ? new MXParser(EntityReplacementMap.defaultEntityReplacementMap) : new MXParser( );

        parser.setInput( reader );


        return read( parser, strict );
    } //-- Assembly read( Reader, boolean )

    /**
     * @see ReaderFactory#newXmlReader
     * 
     * @param reader a reader object.
     * @throws IOException IOException if any.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return Assembly
     */
    public Assembly read( Reader reader )
        throws IOException, XmlPullParserException
    {
        return read( reader, true );
    } //-- Assembly read( Reader )

    /**
     * Method read.
     * 
     * @param in a in object.
     * @param strict a strict object.
     * @throws IOException IOException if any.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return Assembly
     */
    public Assembly read( InputStream in, boolean strict )
        throws IOException, XmlPullParserException
    {
        return read( ReaderFactory.newXmlReader( in ), strict );
    } //-- Assembly read( InputStream, boolean )

    /**
     * Method read.
     * 
     * @param in a in object.
     * @throws IOException IOException if any.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return Assembly
     */
    public Assembly read( InputStream in )
        throws IOException, XmlPullParserException
    {
        return read( ReaderFactory.newXmlReader( in ) );
    } //-- Assembly read( InputStream )

    /**
     * Method parseAssembly.
     * 
     * @param parser a parser object.
     * @param strict a strict object.
     * @throws IOException IOException if any.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return Assembly
     */
    private Assembly parseAssembly( XmlPullParser parser, boolean strict )
        throws IOException, XmlPullParserException
    {
        String tagName = parser.getName();
        Assembly assembly = new Assembly();
        for ( int i = parser.getAttributeCount() - 1; i >= 0; i-- )
        {
            String name = parser.getAttributeName( i );
            String value = parser.getAttributeValue( i );

            if ( name.indexOf( ':' ) >= 0 )
            {
                // just ignore attributes with non-default namespace (for example: xmlns:xsi)
            }
            else if ( "xmlns".equals( name ) )
            {
                // ignore xmlns attribute in root class, which is a reserved attribute name
            }
            else
            {
                checkUnknownAttribute( parser, name, tagName, strict );
            }
        }
        java.util.Set parsed = new java.util.HashSet();
        while ( ( strict ? parser.nextTag() : nextTag( parser ) ) == XmlPullParser.START_TAG )
        {
            if ( checkFieldWithDuplicate( parser, "id", null, parsed ) )
            {
                assembly.setId( interpolatedTrimmed( parser.nextText(), "id" ) );
            }
            else if ( checkFieldWithDuplicate( parser, "formats", null, parsed ) )
            {
                java.util.List<String> formats = new java.util.ArrayList<String>();
                assembly.setFormats( formats );
                while ( parser.nextTag() == XmlPullParser.START_TAG )
                {
                    if ( "format".equals( parser.getName() ) )
                    {
                        formats.add( interpolatedTrimmed( parser.nextText(), "formats" ) );
                    }
                    else
                    {
                        checkUnknownElement( parser, strict );
                    }
                }
            }
            else if ( checkFieldWithDuplicate( parser, "includeBaseDirectory", null, parsed ) )
            {
                assembly.setIncludeBaseDirectory( getBooleanValue( interpolatedTrimmed( parser.nextText(), "includeBaseDirectory" ), "includeBaseDirectory", parser, "true" ) );
            }
            else if ( checkFieldWithDuplicate( parser, "baseDirectory", null, parsed ) )
            {
                assembly.setBaseDirectory( interpolatedTrimmed( parser.nextText(), "baseDirectory" ) );
            }
            else if ( checkFieldWithDuplicate( parser, "includeSiteDirectory", null, parsed ) )
            {
                assembly.setIncludeSiteDirectory( getBooleanValue( interpolatedTrimmed( parser.nextText(), "includeSiteDirectory" ), "includeSiteDirectory", parser, "false" ) );
            }
            else if ( checkFieldWithDuplicate( parser, "containerDescriptorHandlers", null, parsed ) )
            {
                java.util.List<ContainerDescriptorHandlerConfig> containerDescriptorHandlers = new java.util.ArrayList<ContainerDescriptorHandlerConfig>();
                assembly.setContainerDescriptorHandlers( containerDescriptorHandlers );
                while ( parser.nextTag() == XmlPullParser.START_TAG )
                {
                    if ( "containerDescriptorHandler".equals( parser.getName() ) )
                    {
                        containerDescriptorHandlers.add( parseContainerDescriptorHandlerConfig( parser, strict ) );
                    }
                    else
                    {
                        checkUnknownElement( parser, strict );
                    }
                }
            }
            else if ( checkFieldWithDuplicate( parser, "moduleSets", null, parsed ) )
            {
                java.util.List<ModuleSet> moduleSets = new java.util.ArrayList<ModuleSet>();
                assembly.setModuleSets( moduleSets );
                while ( parser.nextTag() == XmlPullParser.START_TAG )
                {
                    if ( "moduleSet".equals( parser.getName() ) )
                    {
                        moduleSets.add( parseModuleSet( parser, strict ) );
                    }
                    else
                    {
                        checkUnknownElement( parser, strict );
                    }
                }
            }
            else if ( checkFieldWithDuplicate( parser, "fileSets", null, parsed ) )
            {
                java.util.List<FileSet> fileSets = new java.util.ArrayList<FileSet>();
                assembly.setFileSets( fileSets );
                while ( parser.nextTag() == XmlPullParser.START_TAG )
                {
                    if ( "fileSet".equals( parser.getName() ) )
                    {
                        fileSets.add( parseFileSet( parser, strict ) );
                    }
                    else
                    {
                        checkUnknownElement( parser, strict );
                    }
                }
            }
            else if ( checkFieldWithDuplicate( parser, "files", null, parsed ) )
            {
                java.util.List<FileItem> files = new java.util.ArrayList<FileItem>();
                assembly.setFiles( files );
                while ( parser.nextTag() == XmlPullParser.START_TAG )
                {
                    if ( "file".equals( parser.getName() ) )
                    {
                        files.add( parseFileItem( parser, strict ) );
                    }
                    else
                    {
                        checkUnknownElement( parser, strict );
                    }
                }
            }
            else if ( checkFieldWithDuplicate( parser, "dependencySets", null, parsed ) )
            {
                java.util.List<DependencySet> dependencySets = new java.util.ArrayList<DependencySet>();
                assembly.setDependencySets( dependencySets );
                while ( parser.nextTag() == XmlPullParser.START_TAG )
                {
                    if ( "dependencySet".equals( parser.getName() ) )
                    {
                        dependencySets.add( parseDependencySet( parser, strict ) );
                    }
                    else
                    {
                        checkUnknownElement( parser, strict );
                    }
                }
            }
            else if ( checkFieldWithDuplicate( parser, "componentDescriptors", null, parsed ) )
            {
                java.util.List<String> componentDescriptors = new java.util.ArrayList<String>();
                assembly.setComponentDescriptors( componentDescriptors );
                while ( parser.nextTag() == XmlPullParser.START_TAG )
                {
                    if ( "componentDescriptor".equals( parser.getName() ) )
                    {
                        componentDescriptors.add( interpolatedTrimmed( parser.nextText(), "componentDescriptors" ) );
                    }
                    else
                    {
                        checkUnknownElement( parser, strict );
                    }
                }
            }
            else
            {
                checkUnknownElement( parser, strict );
            }
        }
        return assembly;
    } //-- Assembly parseAssembly( XmlPullParser, boolean )

    /**
     * Method parseContainerDescriptorHandlerConfig.
     * 
     * @param parser a parser object.
     * @param strict a strict object.
     * @throws IOException IOException if any.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return ContainerDescriptorHandlerConfig
     */
    private ContainerDescriptorHandlerConfig parseContainerDescriptorHandlerConfig( XmlPullParser parser, boolean strict )
        throws IOException, XmlPullParserException
    {
        String tagName = parser.getName();
        ContainerDescriptorHandlerConfig containerDescriptorHandlerConfig = new ContainerDescriptorHandlerConfig();
        for ( int i = parser.getAttributeCount() - 1; i >= 0; i-- )
        {
            String name = parser.getAttributeName( i );
            String value = parser.getAttributeValue( i );

            if ( name.indexOf( ':' ) >= 0 )
            {
                // just ignore attributes with non-default namespace (for example: xmlns:xsi)
            }
            else
            {
                checkUnknownAttribute( parser, name, tagName, strict );
            }
        }
        java.util.Set parsed = new java.util.HashSet();
        while ( ( strict ? parser.nextTag() : nextTag( parser ) ) == XmlPullParser.START_TAG )
        {
            if ( checkFieldWithDuplicate( parser, "handlerName", null, parsed ) )
            {
                containerDescriptorHandlerConfig.setHandlerName( interpolatedTrimmed( parser.nextText(), "handlerName" ) );
            }
            else if ( checkFieldWithDuplicate( parser, "configuration", null, parsed ) )
            {
                containerDescriptorHandlerConfig.setConfiguration( org.codehaus.plexus.util.xml.Xpp3DomBuilder.build( parser, true ) );
            }
            else
            {
                checkUnknownElement( parser, strict );
            }
        }
        return containerDescriptorHandlerConfig;
    } //-- ContainerDescriptorHandlerConfig parseContainerDescriptorHandlerConfig( XmlPullParser, boolean )

    /**
     * Method parseDependencySet.
     * 
     * @param parser a parser object.
     * @param strict a strict object.
     * @throws IOException IOException if any.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return DependencySet
     */
    private DependencySet parseDependencySet( XmlPullParser parser, boolean strict )
        throws IOException, XmlPullParserException
    {
        String tagName = parser.getName();
        DependencySet dependencySet = new DependencySet();
        for ( int i = parser.getAttributeCount() - 1; i >= 0; i-- )
        {
            String name = parser.getAttributeName( i );
            String value = parser.getAttributeValue( i );

            if ( name.indexOf( ':' ) >= 0 )
            {
                // just ignore attributes with non-default namespace (for example: xmlns:xsi)
            }
            else
            {
                checkUnknownAttribute( parser, name, tagName, strict );
            }
        }
        java.util.Set parsed = new java.util.HashSet();
        while ( ( strict ? parser.nextTag() : nextTag( parser ) ) == XmlPullParser.START_TAG )
        {
            if ( checkFieldWithDuplicate( parser, "outputDirectory", null, parsed ) )
            {
                dependencySet.setOutputDirectory( interpolatedTrimmed( parser.nextText(), "outputDirectory" ) );
            }
            else if ( checkFieldWithDuplicate( parser, "includes", null, parsed ) )
            {
                java.util.List<String> includes = new java.util.ArrayList<String>();
                dependencySet.setIncludes( includes );
                while ( parser.nextTag() == XmlPullParser.START_TAG )
                {
                    if ( "include".equals( parser.getName() ) )
                    {
                        includes.add( interpolatedTrimmed( parser.nextText(), "includes" ) );
                    }
                    else
                    {
                        checkUnknownElement( parser, strict );
                    }
                }
            }
            else if ( checkFieldWithDuplicate( parser, "excludes", null, parsed ) )
            {
                java.util.List<String> excludes = new java.util.ArrayList<String>();
                dependencySet.setExcludes( excludes );
                while ( parser.nextTag() == XmlPullParser.START_TAG )
                {
                    if ( "exclude".equals( parser.getName() ) )
                    {
                        excludes.add( interpolatedTrimmed( parser.nextText(), "excludes" ) );
                    }
                    else
                    {
                        checkUnknownElement( parser, strict );
                    }
                }
            }
            else if ( checkFieldWithDuplicate( parser, "fileMode", null, parsed ) )
            {
                dependencySet.setFileMode( interpolatedTrimmed( parser.nextText(), "fileMode" ) );
            }
            else if ( checkFieldWithDuplicate( parser, "directoryMode", null, parsed ) )
            {
                dependencySet.setDirectoryMode( interpolatedTrimmed( parser.nextText(), "directoryMode" ) );
            }
            else if ( checkFieldWithDuplicate( parser, "useStrictFiltering", null, parsed ) )
            {
                dependencySet.setUseStrictFiltering( getBooleanValue( interpolatedTrimmed( parser.nextText(), "useStrictFiltering" ), "useStrictFiltering", parser, "false" ) );
            }
            else if ( checkFieldWithDuplicate( parser, "outputFileNameMapping", null, parsed ) )
            {
                dependencySet.setOutputFileNameMapping( interpolatedTrimmed( parser.nextText(), "outputFileNameMapping" ) );
            }
            else if ( checkFieldWithDuplicate( parser, "unpack", null, parsed ) )
            {
                dependencySet.setUnpack( getBooleanValue( interpolatedTrimmed( parser.nextText(), "unpack" ), "unpack", parser, "false" ) );
            }
            else if ( checkFieldWithDuplicate( parser, "unpackOptions", null, parsed ) )
            {
                dependencySet.setUnpackOptions( parseUnpackOptions( parser, strict ) );
            }
            else if ( checkFieldWithDuplicate( parser, "scope", null, parsed ) )
            {
                dependencySet.setScope( interpolatedTrimmed( parser.nextText(), "scope" ) );
            }
            else if ( checkFieldWithDuplicate( parser, "useProjectArtifact", null, parsed ) )
            {
                dependencySet.setUseProjectArtifact( getBooleanValue( interpolatedTrimmed( parser.nextText(), "useProjectArtifact" ), "useProjectArtifact", parser, "true" ) );
            }
            else if ( checkFieldWithDuplicate( parser, "useProjectAttachments", null, parsed ) )
            {
                dependencySet.setUseProjectAttachments( getBooleanValue( interpolatedTrimmed( parser.nextText(), "useProjectAttachments" ), "useProjectAttachments", parser, "false" ) );
            }
            else if ( checkFieldWithDuplicate( parser, "useTransitiveDependencies", null, parsed ) )
            {
                dependencySet.setUseTransitiveDependencies( getBooleanValue( interpolatedTrimmed( parser.nextText(), "useTransitiveDependencies" ), "useTransitiveDependencies", parser, "true" ) );
            }
            else if ( checkFieldWithDuplicate( parser, "useTransitiveFiltering", null, parsed ) )
            {
                dependencySet.setUseTransitiveFiltering( getBooleanValue( interpolatedTrimmed( parser.nextText(), "useTransitiveFiltering" ), "useTransitiveFiltering", parser, "false" ) );
            }
            else
            {
                checkUnknownElement( parser, strict );
            }
        }
        return dependencySet;
    } //-- DependencySet parseDependencySet( XmlPullParser, boolean )

    /**
     * Method parseFileItem.
     * 
     * @param parser a parser object.
     * @param strict a strict object.
     * @throws IOException IOException if any.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return FileItem
     */
    private FileItem parseFileItem( XmlPullParser parser, boolean strict )
        throws IOException, XmlPullParserException
    {
        String tagName = parser.getName();
        FileItem fileItem = new FileItem();
        for ( int i = parser.getAttributeCount() - 1; i >= 0; i-- )
        {
            String name = parser.getAttributeName( i );
            String value = parser.getAttributeValue( i );

            if ( name.indexOf( ':' ) >= 0 )
            {
                // just ignore attributes with non-default namespace (for example: xmlns:xsi)
            }
            else
            {
                checkUnknownAttribute( parser, name, tagName, strict );
            }
        }
        java.util.Set parsed = new java.util.HashSet();
        while ( ( strict ? parser.nextTag() : nextTag( parser ) ) == XmlPullParser.START_TAG )
        {
            if ( checkFieldWithDuplicate( parser, "source", null, parsed ) )
            {
                fileItem.setSource( interpolatedTrimmed( parser.nextText(), "source" ) );
            }
            else if ( checkFieldWithDuplicate( parser, "sources", null, parsed ) )
            {
                java.util.List<String> sources = new java.util.ArrayList<String>();
                fileItem.setSources( sources );
                while ( parser.nextTag() == XmlPullParser.START_TAG )
                {
                    if ( "source".equals( parser.getName() ) )
                    {
                        sources.add( interpolatedTrimmed( parser.nextText(), "sources" ) );
                    }
                    else
                    {
                        checkUnknownElement( parser, strict );
                    }
                }
            }
            else if ( checkFieldWithDuplicate( parser, "outputDirectory", null, parsed ) )
            {
                fileItem.setOutputDirectory( interpolatedTrimmed( parser.nextText(), "outputDirectory" ) );
            }
            else if ( checkFieldWithDuplicate( parser, "destName", null, parsed ) )
            {
                fileItem.setDestName( interpolatedTrimmed( parser.nextText(), "destName" ) );
            }
            else if ( checkFieldWithDuplicate( parser, "fileMode", null, parsed ) )
            {
                fileItem.setFileMode( interpolatedTrimmed( parser.nextText(), "fileMode" ) );
            }
            else if ( checkFieldWithDuplicate( parser, "lineEnding", null, parsed ) )
            {
                fileItem.setLineEnding( interpolatedTrimmed( parser.nextText(), "lineEnding" ) );
            }
            else if ( checkFieldWithDuplicate( parser, "filtered", null, parsed ) )
            {
                fileItem.setFiltered( getBooleanValue( interpolatedTrimmed( parser.nextText(), "filtered" ), "filtered", parser, "false" ) );
            }
            else
            {
                checkUnknownElement( parser, strict );
            }
        }
        return fileItem;
    } //-- FileItem parseFileItem( XmlPullParser, boolean )

    /**
     * Method parseFileSet.
     * 
     * @param parser a parser object.
     * @param strict a strict object.
     * @throws IOException IOException if any.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return FileSet
     */
    private FileSet parseFileSet( XmlPullParser parser, boolean strict )
        throws IOException, XmlPullParserException
    {
        String tagName = parser.getName();
        FileSet fileSet = new FileSet();
        for ( int i = parser.getAttributeCount() - 1; i >= 0; i-- )
        {
            String name = parser.getAttributeName( i );
            String value = parser.getAttributeValue( i );

            if ( name.indexOf( ':' ) >= 0 )
            {
                // just ignore attributes with non-default namespace (for example: xmlns:xsi)
            }
            else
            {
                checkUnknownAttribute( parser, name, tagName, strict );
            }
        }
        java.util.Set parsed = new java.util.HashSet();
        while ( ( strict ? parser.nextTag() : nextTag( parser ) ) == XmlPullParser.START_TAG )
        {
            if ( checkFieldWithDuplicate( parser, "useDefaultExcludes", null, parsed ) )
            {
                fileSet.setUseDefaultExcludes( getBooleanValue( interpolatedTrimmed( parser.nextText(), "useDefaultExcludes" ), "useDefaultExcludes", parser, "true" ) );
            }
            else if ( checkFieldWithDuplicate( parser, "outputDirectory", null, parsed ) )
            {
                fileSet.setOutputDirectory( interpolatedTrimmed( parser.nextText(), "outputDirectory" ) );
            }
            else if ( checkFieldWithDuplicate( parser, "includes", null, parsed ) )
            {
                java.util.List<String> includes = new java.util.ArrayList<String>();
                fileSet.setIncludes( includes );
                while ( parser.nextTag() == XmlPullParser.START_TAG )
                {
                    if ( "include".equals( parser.getName() ) )
                    {
                        includes.add( interpolatedTrimmed( parser.nextText(), "includes" ) );
                    }
                    else
                    {
                        checkUnknownElement( parser, strict );
                    }
                }
            }
            else if ( checkFieldWithDuplicate( parser, "excludes", null, parsed ) )
            {
                java.util.List<String> excludes = new java.util.ArrayList<String>();
                fileSet.setExcludes( excludes );
                while ( parser.nextTag() == XmlPullParser.START_TAG )
                {
                    if ( "exclude".equals( parser.getName() ) )
                    {
                        excludes.add( interpolatedTrimmed( parser.nextText(), "excludes" ) );
                    }
                    else
                    {
                        checkUnknownElement( parser, strict );
                    }
                }
            }
            else if ( checkFieldWithDuplicate( parser, "fileMode", null, parsed ) )
            {
                fileSet.setFileMode( interpolatedTrimmed( parser.nextText(), "fileMode" ) );
            }
            else if ( checkFieldWithDuplicate( parser, "directoryMode", null, parsed ) )
            {
                fileSet.setDirectoryMode( interpolatedTrimmed( parser.nextText(), "directoryMode" ) );
            }
            else if ( checkFieldWithDuplicate( parser, "directory", null, parsed ) )
            {
                fileSet.setDirectory( interpolatedTrimmed( parser.nextText(), "directory" ) );
            }
            else if ( checkFieldWithDuplicate( parser, "lineEnding", null, parsed ) )
            {
                fileSet.setLineEnding( interpolatedTrimmed( parser.nextText(), "lineEnding" ) );
            }
            else if ( checkFieldWithDuplicate( parser, "filtered", null, parsed ) )
            {
                fileSet.setFiltered( getBooleanValue( interpolatedTrimmed( parser.nextText(), "filtered" ), "filtered", parser, "false" ) );
            }
            else if ( checkFieldWithDuplicate( parser, "nonFilteredFileExtensions", null, parsed ) )
            {
                java.util.List<String> nonFilteredFileExtensions = new java.util.ArrayList<String>();
                fileSet.setNonFilteredFileExtensions( nonFilteredFileExtensions );
                while ( parser.nextTag() == XmlPullParser.START_TAG )
                {
                    if ( "nonFilteredFileExtension".equals( parser.getName() ) )
                    {
                        nonFilteredFileExtensions.add( interpolatedTrimmed( parser.nextText(), "nonFilteredFileExtensions" ) );
                    }
                    else
                    {
                        checkUnknownElement( parser, strict );
                    }
                }
            }
            else
            {
                checkUnknownElement( parser, strict );
            }
        }
        return fileSet;
    } //-- FileSet parseFileSet( XmlPullParser, boolean )

    /**
     * Method parseModuleBinaries.
     * 
     * @param parser a parser object.
     * @param strict a strict object.
     * @throws IOException IOException if any.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return ModuleBinaries
     */
    private ModuleBinaries parseModuleBinaries( XmlPullParser parser, boolean strict )
        throws IOException, XmlPullParserException
    {
        String tagName = parser.getName();
        ModuleBinaries moduleBinaries = new ModuleBinaries();
        for ( int i = parser.getAttributeCount() - 1; i >= 0; i-- )
        {
            String name = parser.getAttributeName( i );
            String value = parser.getAttributeValue( i );

            if ( name.indexOf( ':' ) >= 0 )
            {
                // just ignore attributes with non-default namespace (for example: xmlns:xsi)
            }
            else
            {
                checkUnknownAttribute( parser, name, tagName, strict );
            }
        }
        java.util.Set parsed = new java.util.HashSet();
        while ( ( strict ? parser.nextTag() : nextTag( parser ) ) == XmlPullParser.START_TAG )
        {
            if ( checkFieldWithDuplicate( parser, "outputDirectory", null, parsed ) )
            {
                moduleBinaries.setOutputDirectory( interpolatedTrimmed( parser.nextText(), "outputDirectory" ) );
            }
            else if ( checkFieldWithDuplicate( parser, "includes", null, parsed ) )
            {
                java.util.List<String> includes = new java.util.ArrayList<String>();
                moduleBinaries.setIncludes( includes );
                while ( parser.nextTag() == XmlPullParser.START_TAG )
                {
                    if ( "include".equals( parser.getName() ) )
                    {
                        includes.add( interpolatedTrimmed( parser.nextText(), "includes" ) );
                    }
                    else
                    {
                        checkUnknownElement( parser, strict );
                    }
                }
            }
            else if ( checkFieldWithDuplicate( parser, "excludes", null, parsed ) )
            {
                java.util.List<String> excludes = new java.util.ArrayList<String>();
                moduleBinaries.setExcludes( excludes );
                while ( parser.nextTag() == XmlPullParser.START_TAG )
                {
                    if ( "exclude".equals( parser.getName() ) )
                    {
                        excludes.add( interpolatedTrimmed( parser.nextText(), "excludes" ) );
                    }
                    else
                    {
                        checkUnknownElement( parser, strict );
                    }
                }
            }
            else if ( checkFieldWithDuplicate( parser, "fileMode", null, parsed ) )
            {
                moduleBinaries.setFileMode( interpolatedTrimmed( parser.nextText(), "fileMode" ) );
            }
            else if ( checkFieldWithDuplicate( parser, "directoryMode", null, parsed ) )
            {
                moduleBinaries.setDirectoryMode( interpolatedTrimmed( parser.nextText(), "directoryMode" ) );
            }
            else if ( checkFieldWithDuplicate( parser, "attachmentClassifier", null, parsed ) )
            {
                moduleBinaries.setAttachmentClassifier( interpolatedTrimmed( parser.nextText(), "attachmentClassifier" ) );
            }
            else if ( checkFieldWithDuplicate( parser, "includeDependencies", null, parsed ) )
            {
                moduleBinaries.setIncludeDependencies( getBooleanValue( interpolatedTrimmed( parser.nextText(), "includeDependencies" ), "includeDependencies", parser, "true" ) );
            }
            else if ( checkFieldWithDuplicate( parser, "dependencySets", null, parsed ) )
            {
                java.util.List<DependencySet> dependencySets = new java.util.ArrayList<DependencySet>();
                moduleBinaries.setDependencySets( dependencySets );
                while ( parser.nextTag() == XmlPullParser.START_TAG )
                {
                    if ( "dependencySet".equals( parser.getName() ) )
                    {
                        dependencySets.add( parseDependencySet( parser, strict ) );
                    }
                    else
                    {
                        checkUnknownElement( parser, strict );
                    }
                }
            }
            else if ( checkFieldWithDuplicate( parser, "unpack", null, parsed ) )
            {
                moduleBinaries.setUnpack( getBooleanValue( interpolatedTrimmed( parser.nextText(), "unpack" ), "unpack", parser, "true" ) );
            }
            else if ( checkFieldWithDuplicate( parser, "unpackOptions", null, parsed ) )
            {
                moduleBinaries.setUnpackOptions( parseUnpackOptions( parser, strict ) );
            }
            else if ( checkFieldWithDuplicate( parser, "outputFileNameMapping", null, parsed ) )
            {
                moduleBinaries.setOutputFileNameMapping( interpolatedTrimmed( parser.nextText(), "outputFileNameMapping" ) );
            }
            else
            {
                checkUnknownElement( parser, strict );
            }
        }
        return moduleBinaries;
    } //-- ModuleBinaries parseModuleBinaries( XmlPullParser, boolean )

    /**
     * Method parseModuleSet.
     * 
     * @param parser a parser object.
     * @param strict a strict object.
     * @throws IOException IOException if any.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return ModuleSet
     */
    private ModuleSet parseModuleSet( XmlPullParser parser, boolean strict )
        throws IOException, XmlPullParserException
    {
        String tagName = parser.getName();
        ModuleSet moduleSet = new ModuleSet();
        for ( int i = parser.getAttributeCount() - 1; i >= 0; i-- )
        {
            String name = parser.getAttributeName( i );
            String value = parser.getAttributeValue( i );

            if ( name.indexOf( ':' ) >= 0 )
            {
                // just ignore attributes with non-default namespace (for example: xmlns:xsi)
            }
            else
            {
                checkUnknownAttribute( parser, name, tagName, strict );
            }
        }
        java.util.Set parsed = new java.util.HashSet();
        while ( ( strict ? parser.nextTag() : nextTag( parser ) ) == XmlPullParser.START_TAG )
        {
            if ( checkFieldWithDuplicate( parser, "useAllReactorProjects", null, parsed ) )
            {
                moduleSet.setUseAllReactorProjects( getBooleanValue( interpolatedTrimmed( parser.nextText(), "useAllReactorProjects" ), "useAllReactorProjects", parser, "false" ) );
            }
            else if ( checkFieldWithDuplicate( parser, "includeSubModules", null, parsed ) )
            {
                moduleSet.setIncludeSubModules( getBooleanValue( interpolatedTrimmed( parser.nextText(), "includeSubModules" ), "includeSubModules", parser, "true" ) );
            }
            else if ( checkFieldWithDuplicate( parser, "includes", null, parsed ) )
            {
                java.util.List<String> includes = new java.util.ArrayList<String>();
                moduleSet.setIncludes( includes );
                while ( parser.nextTag() == XmlPullParser.START_TAG )
                {
                    if ( "include".equals( parser.getName() ) )
                    {
                        includes.add( interpolatedTrimmed( parser.nextText(), "includes" ) );
                    }
                    else
                    {
                        checkUnknownElement( parser, strict );
                    }
                }
            }
            else if ( checkFieldWithDuplicate( parser, "excludes", null, parsed ) )
            {
                java.util.List<String> excludes = new java.util.ArrayList<String>();
                moduleSet.setExcludes( excludes );
                while ( parser.nextTag() == XmlPullParser.START_TAG )
                {
                    if ( "exclude".equals( parser.getName() ) )
                    {
                        excludes.add( interpolatedTrimmed( parser.nextText(), "excludes" ) );
                    }
                    else
                    {
                        checkUnknownElement( parser, strict );
                    }
                }
            }
            else if ( checkFieldWithDuplicate( parser, "sources", null, parsed ) )
            {
                moduleSet.setSources( parseModuleSources( parser, strict ) );
            }
            else if ( checkFieldWithDuplicate( parser, "binaries", null, parsed ) )
            {
                moduleSet.setBinaries( parseModuleBinaries( parser, strict ) );
            }
            else
            {
                checkUnknownElement( parser, strict );
            }
        }
        return moduleSet;
    } //-- ModuleSet parseModuleSet( XmlPullParser, boolean )

    /**
     * Method parseModuleSources.
     * 
     * @param parser a parser object.
     * @param strict a strict object.
     * @throws IOException IOException if any.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return ModuleSources
     */
    private ModuleSources parseModuleSources( XmlPullParser parser, boolean strict )
        throws IOException, XmlPullParserException
    {
        String tagName = parser.getName();
        ModuleSources moduleSources = new ModuleSources();
        for ( int i = parser.getAttributeCount() - 1; i >= 0; i-- )
        {
            String name = parser.getAttributeName( i );
            String value = parser.getAttributeValue( i );

            if ( name.indexOf( ':' ) >= 0 )
            {
                // just ignore attributes with non-default namespace (for example: xmlns:xsi)
            }
            else
            {
                checkUnknownAttribute( parser, name, tagName, strict );
            }
        }
        java.util.Set parsed = new java.util.HashSet();
        while ( ( strict ? parser.nextTag() : nextTag( parser ) ) == XmlPullParser.START_TAG )
        {
            if ( checkFieldWithDuplicate( parser, "useDefaultExcludes", null, parsed ) )
            {
                moduleSources.setUseDefaultExcludes( getBooleanValue( interpolatedTrimmed( parser.nextText(), "useDefaultExcludes" ), "useDefaultExcludes", parser, "true" ) );
            }
            else if ( checkFieldWithDuplicate( parser, "outputDirectory", null, parsed ) )
            {
                moduleSources.setOutputDirectory( interpolatedTrimmed( parser.nextText(), "outputDirectory" ) );
            }
            else if ( checkFieldWithDuplicate( parser, "includes", null, parsed ) )
            {
                java.util.List<String> includes = new java.util.ArrayList<String>();
                moduleSources.setIncludes( includes );
                while ( parser.nextTag() == XmlPullParser.START_TAG )
                {
                    if ( "include".equals( parser.getName() ) )
                    {
                        includes.add( interpolatedTrimmed( parser.nextText(), "includes" ) );
                    }
                    else
                    {
                        checkUnknownElement( parser, strict );
                    }
                }
            }
            else if ( checkFieldWithDuplicate( parser, "excludes", null, parsed ) )
            {
                java.util.List<String> excludes = new java.util.ArrayList<String>();
                moduleSources.setExcludes( excludes );
                while ( parser.nextTag() == XmlPullParser.START_TAG )
                {
                    if ( "exclude".equals( parser.getName() ) )
                    {
                        excludes.add( interpolatedTrimmed( parser.nextText(), "excludes" ) );
                    }
                    else
                    {
                        checkUnknownElement( parser, strict );
                    }
                }
            }
            else if ( checkFieldWithDuplicate( parser, "fileMode", null, parsed ) )
            {
                moduleSources.setFileMode( interpolatedTrimmed( parser.nextText(), "fileMode" ) );
            }
            else if ( checkFieldWithDuplicate( parser, "directoryMode", null, parsed ) )
            {
                moduleSources.setDirectoryMode( interpolatedTrimmed( parser.nextText(), "directoryMode" ) );
            }
            else if ( checkFieldWithDuplicate( parser, "fileSets", null, parsed ) )
            {
                java.util.List<FileSet> fileSets = new java.util.ArrayList<FileSet>();
                moduleSources.setFileSets( fileSets );
                while ( parser.nextTag() == XmlPullParser.START_TAG )
                {
                    if ( "fileSet".equals( parser.getName() ) )
                    {
                        fileSets.add( parseFileSet( parser, strict ) );
                    }
                    else
                    {
                        checkUnknownElement( parser, strict );
                    }
                }
            }
            else if ( checkFieldWithDuplicate( parser, "includeModuleDirectory", null, parsed ) )
            {
                moduleSources.setIncludeModuleDirectory( getBooleanValue( interpolatedTrimmed( parser.nextText(), "includeModuleDirectory" ), "includeModuleDirectory", parser, "true" ) );
            }
            else if ( checkFieldWithDuplicate( parser, "excludeSubModuleDirectories", null, parsed ) )
            {
                moduleSources.setExcludeSubModuleDirectories( getBooleanValue( interpolatedTrimmed( parser.nextText(), "excludeSubModuleDirectories" ), "excludeSubModuleDirectories", parser, "true" ) );
            }
            else if ( checkFieldWithDuplicate( parser, "outputDirectoryMapping", null, parsed ) )
            {
                moduleSources.setOutputDirectoryMapping( interpolatedTrimmed( parser.nextText(), "outputDirectoryMapping" ) );
            }
            else
            {
                checkUnknownElement( parser, strict );
            }
        }
        return moduleSources;
    } //-- ModuleSources parseModuleSources( XmlPullParser, boolean )

    /**
     * Method parseUnpackOptions.
     * 
     * @param parser a parser object.
     * @param strict a strict object.
     * @throws IOException IOException if any.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return UnpackOptions
     */
    private UnpackOptions parseUnpackOptions( XmlPullParser parser, boolean strict )
        throws IOException, XmlPullParserException
    {
        String tagName = parser.getName();
        UnpackOptions unpackOptions = new UnpackOptions();
        for ( int i = parser.getAttributeCount() - 1; i >= 0; i-- )
        {
            String name = parser.getAttributeName( i );
            String value = parser.getAttributeValue( i );

            if ( name.indexOf( ':' ) >= 0 )
            {
                // just ignore attributes with non-default namespace (for example: xmlns:xsi)
            }
            else
            {
                checkUnknownAttribute( parser, name, tagName, strict );
            }
        }
        java.util.Set parsed = new java.util.HashSet();
        while ( ( strict ? parser.nextTag() : nextTag( parser ) ) == XmlPullParser.START_TAG )
        {
            if ( checkFieldWithDuplicate( parser, "includes", null, parsed ) )
            {
                java.util.List<String> includes = new java.util.ArrayList<String>();
                unpackOptions.setIncludes( includes );
                while ( parser.nextTag() == XmlPullParser.START_TAG )
                {
                    if ( "include".equals( parser.getName() ) )
                    {
                        includes.add( interpolatedTrimmed( parser.nextText(), "includes" ) );
                    }
                    else
                    {
                        checkUnknownElement( parser, strict );
                    }
                }
            }
            else if ( checkFieldWithDuplicate( parser, "excludes", null, parsed ) )
            {
                java.util.List<String> excludes = new java.util.ArrayList<String>();
                unpackOptions.setExcludes( excludes );
                while ( parser.nextTag() == XmlPullParser.START_TAG )
                {
                    if ( "exclude".equals( parser.getName() ) )
                    {
                        excludes.add( interpolatedTrimmed( parser.nextText(), "excludes" ) );
                    }
                    else
                    {
                        checkUnknownElement( parser, strict );
                    }
                }
            }
            else if ( checkFieldWithDuplicate( parser, "filtered", null, parsed ) )
            {
                unpackOptions.setFiltered( getBooleanValue( interpolatedTrimmed( parser.nextText(), "filtered" ), "filtered", parser, "false" ) );
            }
            else if ( checkFieldWithDuplicate( parser, "nonFilteredFileExtensions", null, parsed ) )
            {
                java.util.List<String> nonFilteredFileExtensions = new java.util.ArrayList<String>();
                unpackOptions.setNonFilteredFileExtensions( nonFilteredFileExtensions );
                while ( parser.nextTag() == XmlPullParser.START_TAG )
                {
                    if ( "nonFilteredFileExtension".equals( parser.getName() ) )
                    {
                        nonFilteredFileExtensions.add( interpolatedTrimmed( parser.nextText(), "nonFilteredFileExtensions" ) );
                    }
                    else
                    {
                        checkUnknownElement( parser, strict );
                    }
                }
            }
            else if ( checkFieldWithDuplicate( parser, "lineEnding", null, parsed ) )
            {
                unpackOptions.setLineEnding( interpolatedTrimmed( parser.nextText(), "lineEnding" ) );
            }
            else if ( checkFieldWithDuplicate( parser, "useDefaultExcludes", null, parsed ) )
            {
                unpackOptions.setUseDefaultExcludes( getBooleanValue( interpolatedTrimmed( parser.nextText(), "useDefaultExcludes" ), "useDefaultExcludes", parser, "true" ) );
            }
            else if ( checkFieldWithDuplicate( parser, "encoding", null, parsed ) )
            {
                unpackOptions.setEncoding( interpolatedTrimmed( parser.nextText(), "encoding" ) );
            }
            else
            {
                checkUnknownElement( parser, strict );
            }
        }
        return unpackOptions;
    } //-- UnpackOptions parseUnpackOptions( XmlPullParser, boolean )

    /**
     * Method read.
     * 
     * @param parser a parser object.
     * @param strict a strict object.
     * @throws IOException IOException if any.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return Assembly
     */
    private Assembly read( XmlPullParser parser, boolean strict )
        throws IOException, XmlPullParserException
    {
        Assembly assembly = null;
        int eventType = parser.getEventType();
        boolean parsed = false;
        while ( eventType != XmlPullParser.END_DOCUMENT )
        {
            if ( eventType == XmlPullParser.START_TAG )
            {
                if ( strict && ! "assembly".equals( parser.getName() ) )
                {
                    throw new XmlPullParserException( "Expected root element 'assembly' but found '" + parser.getName() + "'", parser, null );
                }
                else if ( parsed )
                {
                    // fallback, already expected a XmlPullParserException due to invalid XML
                    throw new XmlPullParserException( "Duplicated tag: 'assembly'", parser, null );
                }
                assembly = parseAssembly( parser, strict );
                assembly.setModelEncoding( parser.getInputEncoding() );
                parsed = true;
            }
            eventType = parser.next();
        }
        if ( parsed )
        {
            return assembly;
        }
        throw new XmlPullParserException( "Expected root element 'assembly' but found no element at all: invalid XML document", parser, null );
    } //-- Assembly read( XmlPullParser, boolean )

    /**
     * Sets the state of the "add default entities" flag.
     * 
     * @param addDefaultEntities a addDefaultEntities object.
     */
    public void setAddDefaultEntities( boolean addDefaultEntities )
    {
        this.addDefaultEntities = addDefaultEntities;
    } //-- void setAddDefaultEntities( boolean )

    public static interface ContentTransformer
{
    /**
     * Interpolate the value read from the xpp3 document
     * @param source The source value
     * @param fieldName A description of the field being interpolated. The implementation may use this to
     *                           log stuff.
     * @return The interpolated value.
     */
    String transform( String source, String fieldName );
}

}
