/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.assembly.io;

import org.apache.maven.shared.io.location.ClasspathResourceLocatorStrategy;
import org.apache.maven.shared.io.location.Location;
import org.apache.maven.shared.io.logging.MessageHolder;

class PrefixedClasspathLocatorStrategy
extends ClasspathResourceLocatorStrategy {
    private final String prefix;

    public PrefixedClasspathLocatorStrategy(String prefix) {
        this.prefix = this.formatPrefix(prefix);
    }

    private String formatPrefix(String prefix) {
        if (prefix.startsWith("/")) {
            prefix = prefix.substring(1);
        }
        if (prefix.length() > 0 && !prefix.endsWith("/")) {
            prefix = prefix + "/";
        }
        return prefix;
    }

    public Location resolve(String locationSpecification, MessageHolder messageHolder) {
        String spec = this.formatLocation(locationSpecification);
        return super.resolve(spec, messageHolder);
    }

    private String formatLocation(String location) {
        if (location.startsWith("/")) {
            location = location.substring(1);
        }
        return this.prefix + location;
    }
}

