/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.module.xdoc;

import java.io.Writer;
import javax.swing.text.AttributeSet;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.html.HTML;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.doxia.module.xdoc.XdocMarkup;
import org.apache.maven.doxia.sink.SinkEventAttributes;
import org.apache.maven.doxia.sink.impl.SinkEventAttributeSet;
import org.apache.maven.doxia.sink.impl.SinkUtils;
import org.apache.maven.doxia.sink.impl.Xhtml5BaseSink;
import org.apache.maven.doxia.util.HtmlTools;

public class XdocSink
extends Xhtml5BaseSink
implements XdocMarkup {
    private boolean sourceFlag;
    private String encoding;
    private String languageId;

    protected XdocSink(Writer writer) {
        super(writer);
    }

    protected XdocSink(Writer writer, String encoding) {
        this(writer);
        this.encoding = encoding;
    }

    protected XdocSink(Writer writer, String encoding, String languageId) {
        this(writer, encoding);
        this.languageId = languageId;
    }

    protected void init() {
        super.init();
        this.sourceFlag = false;
    }

    public void head() {
        this.head(null);
    }

    public void head(SinkEventAttributes attributes) {
        this.init();
        this.setHeadFlag(true);
        this.write("<?xml version=\"1.0\"");
        if (this.encoding != null) {
            this.write(" encoding=\"" + this.encoding + "\"");
        }
        this.write("?>");
        SinkEventAttributeSet atts = new SinkEventAttributeSet();
        atts.addAttribute("xmlns", "http://maven.apache.org/XDOC/2.0");
        atts.addAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        atts.addAttribute("xsi:schemaLocation", "http://maven.apache.org/XDOC/2.0 https://maven.apache.org/xsd/xdoc-2.0.xsd");
        if (this.languageId != null) {
            atts.addAttribute(HTML.Attribute.LANG.toString(), this.languageId);
            atts.addAttribute("xml:lang", this.languageId);
        }
        if (attributes != null) {
            atts.addAttributes((AttributeSet)attributes);
        }
        this.writeStartTag(DOCUMENT_TAG, (MutableAttributeSet)atts);
        this.writeStartTag(PROPERTIES_TAG);
    }

    public void head_() {
        this.setHeadFlag(false);
        this.writeEndTag(PROPERTIES_TAG);
    }

    public void title() {
        this.writeStartTag(TITLE);
    }

    public void title_() {
        this.content(this.getTextBuffer().toString());
        this.writeEndTag(TITLE);
        this.resetTextBuffer();
    }

    public void author_() {
        if (this.getTextBuffer().length() > 0) {
            this.writeStartTag(AUTHOR_TAG);
            String text = HtmlTools.escapeHTML((String)this.getTextBuffer().toString());
            text = StringUtils.replace((String)text, (String)"&amp;#", (String)"&#");
            this.write(text);
            this.writeEndTag(AUTHOR_TAG);
            this.resetTextBuffer();
        }
    }

    public void date_() {
        if (this.getTextBuffer().length() > 0) {
            this.writeStartTag(DATE_TAG);
            this.content(this.getTextBuffer().toString());
            this.writeEndTag(DATE_TAG);
            this.resetTextBuffer();
        }
    }

    public void body() {
        this.body(null);
    }

    public void body(SinkEventAttributes attributes) {
        this.writeStartTag(BODY, (MutableAttributeSet)attributes);
    }

    public void body_() {
        this.writeEndTag(BODY);
        this.writeEndTag(DOCUMENT_TAG);
        this.flush();
        this.init();
    }

    protected void onSection(int depth, SinkEventAttributes attributes) {
        if (depth == 1) {
            this.write('<' + SECTION_TAG.toString() + SinkUtils.getAttributeString((AttributeSet)SinkUtils.filterAttributes((AttributeSet)attributes, (String[])SinkUtils.SINK_BASE_ATTRIBUTES)) + ' ' + HTML.Attribute.NAME + '=' + '\"');
        } else if (depth == 2) {
            this.write('<' + SUBSECTION_TAG.toString() + SinkUtils.getAttributeString((AttributeSet)SinkUtils.filterAttributes((AttributeSet)attributes, (String[])SinkUtils.SINK_BASE_ATTRIBUTES)) + ' ' + HTML.Attribute.NAME + '=' + '\"');
        }
    }

    protected void onSection_(int depth) {
        if (depth == 1) {
            this.writeEndTag(SECTION_TAG);
        } else if (depth == 2) {
            this.writeEndTag(SUBSECTION_TAG);
        }
    }

    protected void onSectionTitle(int depth, SinkEventAttributes attributes) {
        MutableAttributeSet atts = SinkUtils.filterAttributes((AttributeSet)attributes, (String[])SinkUtils.SINK_SECTION_ATTRIBUTES);
        if (depth == 3) {
            this.writeStartTag(H3, atts);
        } else if (depth == 4) {
            this.writeStartTag(H4, atts);
        } else if (depth == 5) {
            this.writeStartTag(H5, atts);
        }
    }

    protected void onSectionTitle_(int depth) {
        if (depth == 1 || depth == 2) {
            this.write(String.valueOf('\"') + '>');
        } else if (depth == 3) {
            this.writeEndTag(H3);
        } else if (depth == 4) {
            this.writeEndTag(H4);
        } else if (depth == 5) {
            this.writeEndTag(H5);
        }
    }

    public void verbatim(SinkEventAttributes attributes) {
        this.setVerbatimFlag(true);
        MutableAttributeSet atts = SinkUtils.filterAttributes((AttributeSet)attributes, (String[])SinkUtils.SINK_VERBATIM_ATTRIBUTES);
        if (atts == null) {
            atts = new SinkEventAttributeSet();
        }
        boolean source = false;
        if (atts.isDefined("decoration")) {
            this.sourceFlag = source = "source".equals(atts.getAttribute("decoration"));
        }
        atts.removeAttribute("decoration");
        if (source) {
            this.writeStartTag(SOURCE_TAG, atts);
        } else {
            this.writeStartTag(PRE, atts);
        }
    }

    public void verbatim_() {
        if (this.sourceFlag) {
            this.writeEndTag(SOURCE_TAG);
        } else {
            this.writeEndTag(PRE);
        }
        this.setVerbatimFlag(false);
        this.sourceFlag = false;
    }

    public void tableRows(int[] justification, boolean grid) {
        this.setCellJustif(justification);
        SinkEventAttributeSet att = new SinkEventAttributeSet();
        if (!this.tableAttributes.isDefined(HTML.Attribute.BORDER.toString())) {
            att.addAttribute(HTML.Attribute.BORDER, grid ? "1" : "0");
        }
        att.addAttributes(this.tableAttributes);
        this.tableAttributes.removeAttributes(this.tableAttributes);
        this.writeStartTag(TABLE, (MutableAttributeSet)att);
    }

    public void tableRow() {
        SinkEventAttributeSet att = new SinkEventAttributeSet();
        this.writeStartTag(TR, (MutableAttributeSet)att);
        this.setCellCount(0);
    }

    public void close() {
        super.close();
        this.init();
    }
}

