/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.range;

import org.apache.lucene.facet.range.Range;

public final class FloatRange
extends Range {
    private final float minIncl;
    private final float maxIncl;
    public final float min;
    public final float max;
    public final boolean minInclusive;
    public final boolean maxInclusive;

    public FloatRange(String label, float min, boolean minInclusive, float max, boolean maxInclusive) {
        super(label);
        this.min = min;
        this.max = max;
        this.minInclusive = minInclusive;
        this.maxInclusive = maxInclusive;
        if (Float.isNaN(min)) {
            throw new IllegalArgumentException("min cannot be NaN");
        }
        if (!minInclusive) {
            min = Math.nextUp(min);
        }
        if (Float.isNaN(max)) {
            throw new IllegalArgumentException("max cannot be NaN");
        }
        if (!maxInclusive) {
            max = Math.nextAfter(max, Double.NEGATIVE_INFINITY);
        }
        this.minIncl = min;
        this.maxIncl = max;
    }

    @Override
    public boolean accept(long value) {
        float floatValue = Float.intBitsToFloat((int)value);
        return floatValue >= this.minIncl && floatValue <= this.maxIncl;
    }
}

