/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.codecs.facet45;

import java.util.HashSet;
import java.util.Set;
import org.apache.lucene.codecs.DocValuesFormat;
import org.apache.lucene.codecs.lucene45.Lucene45Codec;
import org.apache.lucene.facet.params.CategoryListParams;
import org.apache.lucene.facet.params.FacetIndexingParams;

public class Facet45Codec
extends Lucene45Codec {
    private final Set<String> facetFields;
    private final DocValuesFormat facetsDVFormat = DocValuesFormat.forName((String)"Facet42");

    public Facet45Codec() {
        this(FacetIndexingParams.DEFAULT);
    }

    public Facet45Codec(FacetIndexingParams fip) {
        if (fip.getPartitionSize() != Integer.MAX_VALUE) {
            throw new IllegalArgumentException("this Codec does not support partitions");
        }
        this.facetFields = new HashSet<String>();
        for (CategoryListParams clp : fip.getAllCategoryListParams()) {
            this.facetFields.add(clp.field);
        }
    }

    public DocValuesFormat getDocValuesFormatForField(String field) {
        if (this.facetFields.contains(field)) {
            return this.facetsDVFormat;
        }
        return super.getDocValuesFormatForField(field);
    }
}

