/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.util;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import org.apache.lucene.facet.taxonomy.CategoryPath;
import org.apache.lucene.facet.taxonomy.TaxonomyReader;
import org.apache.lucene.facet.taxonomy.directory.DirectoryTaxonomyReader;
import org.apache.lucene.facet.taxonomy.directory.ParallelTaxonomyArrays;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;

public class PrintTaxonomyStats {
    public static void main(String[] args) throws IOException {
        boolean printTree = false;
        String path = null;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-printTree")) {
                printTree = true;
                continue;
            }
            path = args[i];
        }
        if (args.length != (printTree ? 2 : 1)) {
            System.out.println("\nUsage: java -classpath ... org.apache.lucene.facet.util.PrintTaxonomyStats [-printTree] /path/to/taxononmy/index\n");
            System.exit(1);
        }
        FSDirectory dir = FSDirectory.open((File)new File(path));
        DirectoryTaxonomyReader r = new DirectoryTaxonomyReader((Directory)dir);
        PrintTaxonomyStats.printStats(r, System.out, printTree);
        r.close();
        dir.close();
    }

    public static void printStats(TaxonomyReader r, PrintStream out, boolean printTree) throws IOException {
        ParallelTaxonomyArrays arrays = r.getParallelTaxonomyArrays();
        int[] children = arrays.children();
        int[] siblings = arrays.siblings();
        out.println(r.getSize() + " total categories.");
        int childOrd = children[0];
        while (childOrd != -1) {
            CategoryPath cp = r.getPath(childOrd);
            int childOrd2 = children[childOrd];
            int numImmediateChildren = 0;
            while (childOrd2 != -1) {
                ++numImmediateChildren;
                childOrd2 = siblings[childOrd2];
            }
            out.println("/" + cp + ": " + numImmediateChildren + " immediate children; " + (1 + PrintTaxonomyStats.countAllChildren(r, childOrd, children, siblings)) + " total categories");
            if (printTree) {
                PrintTaxonomyStats.printAllChildren(out, r, childOrd, children, siblings, "  ", 1);
            }
            childOrd = siblings[childOrd];
        }
    }

    private static int countAllChildren(TaxonomyReader r, int ord, int[] children, int[] siblings) throws IOException {
        int childOrd = children[ord];
        int count = 0;
        while (childOrd != -1) {
            count += 1 + PrintTaxonomyStats.countAllChildren(r, childOrd, children, siblings);
            childOrd = siblings[childOrd];
        }
        return count;
    }

    private static void printAllChildren(PrintStream out, TaxonomyReader r, int ord, int[] children, int[] siblings, String indent, int depth) throws IOException {
        int childOrd = children[ord];
        while (childOrd != -1) {
            out.println(indent + "/" + r.getPath((int)childOrd).components[depth]);
            PrintTaxonomyStats.printAllChildren(out, r, childOrd, children, siblings, indent + "  ", depth + 1);
            childOrd = siblings[childOrd];
        }
    }
}

