/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.index;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.facet.index.params.CategoryListParams;
import org.apache.lucene.facet.index.params.FacetIndexingParams;
import org.apache.lucene.index.PayloadProcessorProvider;
import org.apache.lucene.index.Term;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.encoding.IntDecoder;
import org.apache.lucene.util.encoding.IntEncoder;

public class FacetsPayloadProcessorProvider
extends PayloadProcessorProvider {
    private final Directory workDir;
    private final PayloadProcessorProvider.DirPayloadProcessor dirProcessor;

    public FacetsPayloadProcessorProvider(Directory dir, int[] ordinalMap, FacetIndexingParams indexingParams) {
        this.workDir = dir;
        this.dirProcessor = new FacetsDirPayloadProcessor(indexingParams, ordinalMap);
    }

    public PayloadProcessorProvider.DirPayloadProcessor getDirProcessor(Directory dir) throws IOException {
        if (this.workDir != dir) {
            return null;
        }
        return this.dirProcessor;
    }

    public static class FacetsPayloadProcessor
    extends PayloadProcessorProvider.PayloadProcessor {
        private final IntEncoder encoder;
        private final IntDecoder decoder;
        private final int[] ordinalMap;
        private final ByteArrayOutputStream os = new ByteArrayOutputStream();

        protected FacetsPayloadProcessor(CategoryListParams params, int[] ordinalMap) {
            this.encoder = params.createEncoder();
            this.decoder = this.encoder.createMatchingDecoder();
            this.ordinalMap = ordinalMap;
        }

        public int payloadLength() throws IOException {
            return this.os.size();
        }

        public byte[] processPayload(byte[] payload, int start, int length) throws IOException {
            long ordinal;
            ByteArrayInputStream is = new ByteArrayInputStream(payload, start, length);
            this.decoder.reInit(is);
            this.os.reset();
            this.encoder.reInit(this.os);
            while ((ordinal = this.decoder.decode()) != 0x100000000L) {
                int newOrdinal = this.ordinalMap[(int)ordinal];
                this.encoder.encode(newOrdinal);
            }
            this.encoder.close();
            return this.os.toByteArray();
        }
    }

    public static class FacetsDirPayloadProcessor
    extends PayloadProcessorProvider.DirPayloadProcessor {
        private final Map<Term, CategoryListParams> termMap = new HashMap<Term, CategoryListParams>(1);
        private final int[] ordinalMap;

        protected FacetsDirPayloadProcessor(FacetIndexingParams indexingParams, int[] ordinalMap) {
            this.ordinalMap = ordinalMap;
            for (CategoryListParams params : indexingParams.getAllCategoryListParams()) {
                this.termMap.put(params.getTerm(), params);
            }
        }

        public PayloadProcessorProvider.PayloadProcessor getProcessor(Term term) throws IOException {
            CategoryListParams params = this.termMap.get(term);
            if (params == null) {
                return null;
            }
            return new FacetsPayloadProcessor(params, this.ordinalMap);
        }
    }
}

