/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.demo.facet;

import java.io.Closeable;
import java.io.IOException;
import java.text.ParseException;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.core.WhitespaceAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.DoublePoint;
import org.apache.lucene.document.NumericDocValuesField;
import org.apache.lucene.expressions.Bindings;
import org.apache.lucene.expressions.Expression;
import org.apache.lucene.expressions.SimpleBindings;
import org.apache.lucene.expressions.js.JavascriptCompiler;
import org.apache.lucene.facet.DrillDownQuery;
import org.apache.lucene.facet.DrillSideways;
import org.apache.lucene.facet.FacetResult;
import org.apache.lucene.facet.Facets;
import org.apache.lucene.facet.FacetsCollector;
import org.apache.lucene.facet.FacetsCollectorManager;
import org.apache.lucene.facet.FacetsConfig;
import org.apache.lucene.facet.range.DoubleRange;
import org.apache.lucene.facet.range.DoubleRangeFacetCounts;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.CollectorManager;
import org.apache.lucene.search.DoubleValuesSource;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.ByteBuffersDirectory;
import org.apache.lucene.store.Directory;

public class DistanceFacetsExample
implements Closeable {
    final DoubleRange ONE_KM = new DoubleRange("< 1 km", 0.0, true, 1.0, false);
    final DoubleRange TWO_KM = new DoubleRange("< 2 km", 0.0, true, 2.0, false);
    final DoubleRange FIVE_KM = new DoubleRange("< 5 km", 0.0, true, 5.0, false);
    final DoubleRange TEN_KM = new DoubleRange("< 10 km", 0.0, true, 10.0, false);
    private final Directory indexDir = new ByteBuffersDirectory();
    private IndexSearcher searcher;
    private final FacetsConfig config = new FacetsConfig();
    public static final double ORIGIN_LATITUDE = 40.7143528;
    public static final double ORIGIN_LONGITUDE = -74.0059731;
    public static final double EARTH_RADIUS_KM = 6371.0087714;

    public void index() throws IOException {
        IndexWriter writer = new IndexWriter(this.indexDir, new IndexWriterConfig((Analyzer)new WhitespaceAnalyzer()).setOpenMode(IndexWriterConfig.OpenMode.CREATE));
        Document doc = new Document();
        doc.add((IndexableField)new DoublePoint("latitude", new double[]{40.759011}));
        doc.add((IndexableField)new NumericDocValuesField("latitude", Double.doubleToRawLongBits(40.759011)));
        doc.add((IndexableField)new DoublePoint("longitude", new double[]{-73.9844722}));
        doc.add((IndexableField)new NumericDocValuesField("longitude", Double.doubleToRawLongBits(-73.9844722)));
        writer.addDocument((Iterable)doc);
        doc = new Document();
        doc.add((IndexableField)new DoublePoint("latitude", new double[]{40.718266}));
        doc.add((IndexableField)new NumericDocValuesField("latitude", Double.doubleToRawLongBits(40.718266)));
        doc.add((IndexableField)new DoublePoint("longitude", new double[]{-74.007819}));
        doc.add((IndexableField)new NumericDocValuesField("longitude", Double.doubleToRawLongBits(-74.007819)));
        writer.addDocument((Iterable)doc);
        doc = new Document();
        doc.add((IndexableField)new DoublePoint("latitude", new double[]{40.7051157}));
        doc.add((IndexableField)new NumericDocValuesField("latitude", Double.doubleToRawLongBits(40.7051157)));
        doc.add((IndexableField)new DoublePoint("longitude", new double[]{-74.0088305}));
        doc.add((IndexableField)new NumericDocValuesField("longitude", Double.doubleToRawLongBits(-74.0088305)));
        writer.addDocument((Iterable)doc);
        this.searcher = new IndexSearcher((IndexReader)DirectoryReader.open((IndexWriter)writer));
        writer.close();
    }

    private DoubleValuesSource getDistanceValueSource() {
        Expression distance;
        try {
            distance = JavascriptCompiler.compile((String)"haversin(40.7143528,-74.0059731,latitude,longitude)");
        }
        catch (ParseException pe) {
            throw new RuntimeException(pe);
        }
        SimpleBindings bindings = new SimpleBindings();
        bindings.add("latitude", DoubleValuesSource.fromDoubleField((String)"latitude"));
        bindings.add("longitude", DoubleValuesSource.fromDoubleField((String)"longitude"));
        return distance.getDoubleValuesSource((Bindings)bindings);
    }

    public static Query getBoundingBoxQuery(double originLat, double originLng, double maxDistanceKM) {
        double maxLng;
        double minLng;
        double originLatRadians = Math.toRadians(originLat);
        double originLngRadians = Math.toRadians(originLng);
        double angle = maxDistanceKM / 6371.0087714;
        double minLat = originLatRadians - angle;
        double maxLat = originLatRadians + angle;
        if (minLat > Math.toRadians(-90.0) && maxLat < Math.toRadians(90.0)) {
            double delta = Math.asin(Math.sin(angle) / Math.cos(originLatRadians));
            minLng = originLngRadians - delta;
            if (minLng < Math.toRadians(-180.0)) {
                minLng += Math.PI * 2;
            }
            if ((maxLng = originLngRadians + delta) > Math.toRadians(180.0)) {
                maxLng -= Math.PI * 2;
            }
        } else {
            minLat = Math.max(minLat, Math.toRadians(-90.0));
            maxLat = Math.min(maxLat, Math.toRadians(90.0));
            minLng = Math.toRadians(-180.0);
            maxLng = Math.toRadians(180.0);
        }
        BooleanQuery.Builder f = new BooleanQuery.Builder();
        f.add(DoublePoint.newRangeQuery((String)"latitude", (double)Math.toDegrees(minLat), (double)Math.toDegrees(maxLat)), BooleanClause.Occur.FILTER);
        if (minLng > maxLng) {
            BooleanQuery.Builder lonF = new BooleanQuery.Builder();
            lonF.add(DoublePoint.newRangeQuery((String)"longitude", (double)Math.toDegrees(minLng), (double)Double.POSITIVE_INFINITY), BooleanClause.Occur.SHOULD);
            lonF.add(DoublePoint.newRangeQuery((String)"longitude", (double)Double.NEGATIVE_INFINITY, (double)Math.toDegrees(maxLng)), BooleanClause.Occur.SHOULD);
            f.add((Query)lonF.build(), BooleanClause.Occur.MUST);
        } else {
            f.add(DoublePoint.newRangeQuery((String)"longitude", (double)Math.toDegrees(minLng), (double)Math.toDegrees(maxLng)), BooleanClause.Occur.FILTER);
        }
        return f.build();
    }

    public FacetResult search() throws IOException {
        FacetsCollector fc = (FacetsCollector)this.searcher.search((Query)new MatchAllDocsQuery(), (CollectorManager)new FacetsCollectorManager());
        DoubleRangeFacetCounts facets = new DoubleRangeFacetCounts("field", this.getDistanceValueSource(), fc, DistanceFacetsExample.getBoundingBoxQuery(40.7143528, -74.0059731, 10.0), new DoubleRange[]{this.ONE_KM, this.TWO_KM, this.FIVE_KM, this.TEN_KM});
        return facets.getTopChildren(10, "field", new String[0]);
    }

    public TopDocs drillDown(DoubleRange range) throws IOException {
        DrillDownQuery q = new DrillDownQuery(null);
        final DoubleValuesSource vs = this.getDistanceValueSource();
        q.add("field", range.getQuery(DistanceFacetsExample.getBoundingBoxQuery(40.7143528, -74.0059731, range.max), vs));
        DrillSideways ds = new DrillSideways(this.searcher, this.config, null){

            protected Facets buildFacetsResult(FacetsCollector drillDowns, FacetsCollector[] drillSideways, String[] drillSidewaysDims) throws IOException {
                assert (drillSideways.length == 1);
                return new DoubleRangeFacetCounts("field", vs, drillSideways[0], new DoubleRange[]{DistanceFacetsExample.this.ONE_KM, DistanceFacetsExample.this.TWO_KM, DistanceFacetsExample.this.FIVE_KM, DistanceFacetsExample.this.TEN_KM});
            }
        };
        return ds.search((DrillDownQuery)q, (int)10).hits;
    }

    @Override
    public void close() throws IOException {
        this.searcher.getIndexReader().close();
        this.indexDir.close();
    }

    public static void main(String[] args) throws Exception {
        DistanceFacetsExample example = new DistanceFacetsExample();
        example.index();
        System.out.println("Distance facet counting example:");
        System.out.println("-----------------------");
        System.out.println(example.search());
        System.out.println("Distance facet drill-down example (field/< 2 km):");
        System.out.println("---------------------------------------------");
        TopDocs hits = example.drillDown(example.TWO_KM);
        System.out.println(hits.totalHits + " totalHits");
        example.close();
    }
}

