/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.demo;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Date;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.demo.knn.DemoEmbeddings;
import org.apache.lucene.demo.knn.KnnVectorDict;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.KnnFloatVectorField;
import org.apache.lucene.document.LongField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.VectorSimilarityFunction;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.util.IOUtils;

public class IndexFiles
implements AutoCloseable {
    static final String KNN_DICT = "knn-dict";
    private final DemoEmbeddings demoEmbeddings;
    private final KnnVectorDict vectorDict;

    private IndexFiles(KnnVectorDict vectorDict) throws IOException {
        if (vectorDict != null) {
            this.vectorDict = vectorDict;
            this.demoEmbeddings = new DemoEmbeddings(vectorDict);
        } else {
            this.vectorDict = null;
            this.demoEmbeddings = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        Path docDir;
        String usage = "java org.apache.lucene.demo.IndexFiles [-index INDEX_PATH] [-docs DOCS_PATH] [-update] [-knn_dict DICT_PATH]\n\nThis indexes the documents in DOCS_PATH, creating a Lucene indexin INDEX_PATH that can be searched with SearchFiles\nIF DICT_PATH contains a KnnVector dictionary, the index will also support KnnVector search";
        String indexPath = "index";
        String docsPath = null;
        String vectorDictSource = null;
        boolean create = true;
        block33: for (int i = 0; i < args.length; ++i) {
            switch (args[i]) {
                case "-index": {
                    indexPath = args[++i];
                    continue block33;
                }
                case "-docs": {
                    docsPath = args[++i];
                    continue block33;
                }
                case "-knn_dict": {
                    vectorDictSource = args[++i];
                    continue block33;
                }
                case "-update": {
                    create = false;
                    continue block33;
                }
                case "-create": {
                    create = true;
                    continue block33;
                }
                default: {
                    throw new IllegalArgumentException("unknown parameter " + args[i]);
                }
            }
        }
        if (docsPath == null) {
            System.err.println("Usage: " + usage);
            System.exit(1);
        }
        if (!Files.isReadable(docDir = Paths.get(docsPath, new String[0]))) {
            System.out.println("Document directory '" + docDir.toAbsolutePath() + "' does not exist or is not readable, please check the path");
            System.exit(1);
        }
        Date start = new Date();
        try {
            System.out.println("Indexing to directory '" + indexPath + "'...");
            FSDirectory dir = FSDirectory.open((Path)Paths.get(indexPath, new String[0]));
            StandardAnalyzer analyzer = new StandardAnalyzer();
            IndexWriterConfig iwc = new IndexWriterConfig((Analyzer)analyzer);
            if (create) {
                iwc.setOpenMode(IndexWriterConfig.OpenMode.CREATE);
            } else {
                iwc.setOpenMode(IndexWriterConfig.OpenMode.CREATE_OR_APPEND);
            }
            KnnVectorDict vectorDictInstance = null;
            long vectorDictSize = 0L;
            if (vectorDictSource != null) {
                KnnVectorDict.build(Paths.get(vectorDictSource, new String[0]), (Directory)dir, KNN_DICT);
                vectorDictInstance = new KnnVectorDict((Directory)dir, KNN_DICT);
                vectorDictSize = vectorDictInstance.ramBytesUsed();
            }
            try (IndexWriter writer = new IndexWriter((Directory)dir, iwc);
                 IndexFiles indexFiles = new IndexFiles(vectorDictInstance);){
                indexFiles.indexDocs(writer, docDir);
            }
            catch (Throwable throwable) {
                IOUtils.close((Closeable[])new Closeable[]{vectorDictInstance});
                throw throwable;
            }
            IOUtils.close((Closeable[])new Closeable[]{vectorDictInstance});
            Date end = new Date();
            try (DirectoryReader reader = DirectoryReader.open((Directory)dir);){
                System.out.println("Indexed " + reader.numDocs() + " documents in " + (end.getTime() - start.getTime()) + " ms");
                if (reader.numDocs() > 100 && vectorDictSize < 1000000L && System.getProperty("smoketester") == null) {
                    throw new RuntimeException("Are you (ab)using the toy vector dictionary? See the package javadocs to understand why you got this exception.");
                }
            }
        }
        catch (IOException e) {
            System.out.println(" caught a " + e.getClass() + "\n with message: " + e.getMessage());
        }
    }

    void indexDocs(final IndexWriter writer, Path path) throws IOException {
        if (Files.isDirectory(path, new LinkOption[0])) {
            Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                    try {
                        IndexFiles.this.indexDoc(writer, file, attrs.lastModifiedTime().toMillis());
                    }
                    catch (IOException ignore) {
                        ignore.printStackTrace(System.err);
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        } else {
            this.indexDoc(writer, path, Files.getLastModifiedTime(path, new LinkOption[0]).toMillis());
        }
    }

    void indexDoc(IndexWriter writer, Path file, long lastModified) throws IOException {
        try (InputStream stream = Files.newInputStream(file, new OpenOption[0]);){
            Document doc = new Document();
            StringField pathField = new StringField("path", file.toString(), Field.Store.YES);
            doc.add((IndexableField)pathField);
            doc.add((IndexableField)new LongField("modified", lastModified));
            doc.add((IndexableField)new TextField("contents", (Reader)new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8))));
            if (this.demoEmbeddings != null) {
                try (InputStream in = Files.newInputStream(file, new OpenOption[0]);){
                    float[] vector = this.demoEmbeddings.computeEmbedding(new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8)));
                    doc.add((IndexableField)new KnnFloatVectorField("contents-vector", vector, VectorSimilarityFunction.DOT_PRODUCT));
                }
            }
            if (writer.getConfig().getOpenMode() == IndexWriterConfig.OpenMode.CREATE) {
                System.out.println("adding " + file);
                writer.addDocument((Iterable)doc);
            } else {
                System.out.println("updating " + file);
                writer.updateDocument(new Term("path", file.toString()), (Iterable)doc);
            }
        }
    }

    @Override
    public void close() throws IOException {
        IOUtils.close((Closeable[])new Closeable[]{this.vectorDict});
    }
}

