/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.spi.commons.name;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.NameFactory;
import org.apache.jackrabbit.spi.Path;
import org.apache.jackrabbit.spi.PathFactory;
import org.apache.jackrabbit.spi.commons.name.NameFactoryImpl;

public class PathFactoryImpl
implements PathFactory {
    private static PathFactory FACTORY = new PathFactoryImpl();
    private static final String CURRENT_LITERAL = ".";
    private static final String PARENT_LITERAL = "..";
    private static final NameFactory NAME_FACTORY = NameFactoryImpl.getInstance();
    private static final Name CURRENT_NAME = NAME_FACTORY.create("", ".");
    private static final Name PARENT_NAME = NAME_FACTORY.create("", "..");
    private static final Name ROOT_NAME = NAME_FACTORY.create("", "");
    private static final Path.Element CURRENT_ELEMENT = new SpecialElement(CURRENT_NAME);
    private static final Path.Element PARENT_ELEMENT = new SpecialElement(PARENT_NAME);
    private static final Path.Element ROOT_ELEMENT = new SpecialElement(ROOT_NAME);
    private static final Path ROOT = new PathImpl(new Path.Element[]{ROOT_ELEMENT}, true);

    private PathFactoryImpl() {
    }

    public static PathFactory getInstance() {
        return FACTORY;
    }

    public Path create(Path parent, Path relPath, boolean normalize) throws IllegalArgumentException, RepositoryException {
        if (relPath.isAbsolute()) {
            throw new IllegalArgumentException("relPath is not a relative path");
        }
        ArrayList<Path.Element> l = new ArrayList<Path.Element>();
        l.addAll(Arrays.asList(parent.getElements()));
        l.addAll(Arrays.asList(relPath.getElements()));
        Builder pb = new Builder(l);
        Path path = pb.getPath();
        if (normalize) {
            return path.getNormalizedPath();
        }
        return path;
    }

    public Path create(Path parent, Name name, boolean normalize) throws RepositoryException {
        ArrayList<Path.Element> elements = new ArrayList<Path.Element>();
        elements.addAll(Arrays.asList(parent.getElements()));
        elements.add(this.createElement(name));
        Builder pb = new Builder(elements);
        Path path = pb.getPath();
        if (normalize) {
            return path.getNormalizedPath();
        }
        return path;
    }

    public Path create(Path parent, Name name, int index, boolean normalize) throws IllegalArgumentException, RepositoryException {
        ArrayList<Path.Element> elements = new ArrayList<Path.Element>();
        elements.addAll(Arrays.asList(parent.getElements()));
        elements.add(this.createElement(name, index));
        Builder pb = new Builder(elements);
        Path path = pb.getPath();
        if (normalize) {
            return path.getNormalizedPath();
        }
        return path;
    }

    public Path create(Name name) throws IllegalArgumentException {
        Path.Element elem = this.createElement(name);
        return new Builder(new Path.Element[]{elem}).getPath();
    }

    public Path create(Name name, int index) throws IllegalArgumentException {
        if (index < 0) {
            throw new IllegalArgumentException("Index must not be negative: " + index);
        }
        Path.Element elem = this.createElement(name, index);
        return new Builder(new Path.Element[]{elem}).getPath();
    }

    public Path create(Path.Element[] elements) throws IllegalArgumentException {
        return new Builder(elements).getPath();
    }

    public Path create(String pathString) throws IllegalArgumentException {
        if (pathString == null || "".equals(pathString)) {
            throw new IllegalArgumentException("Invalid Path literal");
        }
        int lastPos = 0;
        int pos = pathString.indexOf(9);
        ArrayList<Path.Element> list = new ArrayList<Path.Element>();
        while (lastPos >= 0) {
            Path.Element elem;
            if (pos >= 0) {
                elem = this.createElement(pathString.substring(lastPos, pos));
                lastPos = pos + 1;
                pos = pathString.indexOf(9, lastPos);
            } else {
                elem = this.createElement(pathString.substring(lastPos));
                lastPos = -1;
            }
            list.add(elem);
        }
        return new Builder(list).getPath();
    }

    public Path.Element createElement(Name name) throws IllegalArgumentException {
        if (name == null) {
            throw new IllegalArgumentException("name must not be null");
        }
        if (name.equals(PARENT_NAME)) {
            return PARENT_ELEMENT;
        }
        if (name.equals(CURRENT_NAME)) {
            return CURRENT_ELEMENT;
        }
        if (name.equals(ROOT_NAME)) {
            return ROOT_ELEMENT;
        }
        return new Element(name, 0);
    }

    public Path.Element createElement(Name name, int index) throws IllegalArgumentException {
        if (index < 0) {
            throw new IllegalArgumentException("The index may not be negative.");
        }
        if (name == null) {
            throw new IllegalArgumentException("The name must not be null");
        }
        if (name.equals(PARENT_NAME) || name.equals(CURRENT_NAME) || name.equals(ROOT_NAME)) {
            throw new IllegalArgumentException("Special path elements (root, '.' and '..') can not have an explicit index.");
        }
        return new Element(name, index);
    }

    private Path.Element createElement(String elementString) {
        if (elementString == null) {
            throw new IllegalArgumentException("null PathElement literal");
        }
        if (elementString.equals(ROOT_NAME.toString())) {
            return ROOT_ELEMENT;
        }
        if (elementString.equals(CURRENT_LITERAL)) {
            return CURRENT_ELEMENT;
        }
        if (elementString.equals(PARENT_LITERAL)) {
            return PARENT_ELEMENT;
        }
        int pos = elementString.indexOf(91);
        if (pos == -1) {
            Name name = NAME_FACTORY.create(elementString);
            return new Element(name, 0);
        }
        Name name = NAME_FACTORY.create(elementString.substring(0, pos));
        int pos1 = elementString.indexOf(93);
        if (pos1 == -1) {
            throw new IllegalArgumentException("invalid PathElement literal: " + elementString + " (missing ']')");
        }
        try {
            int index = Integer.valueOf(elementString.substring(pos + 1, pos1));
            if (index < 1) {
                throw new IllegalArgumentException("invalid PathElement literal: " + elementString + " (index is 1-based)");
            }
            return new Element(name, index);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("invalid PathElement literal: " + elementString + " (" + e.getMessage() + ")");
        }
    }

    public Path.Element getCurrentElement() {
        return CURRENT_ELEMENT;
    }

    public Path.Element getParentElement() {
        return PARENT_ELEMENT;
    }

    public Path.Element getRootElement() {
        return ROOT_ELEMENT;
    }

    public Path getRootPath() {
        return ROOT;
    }

    private static final class Builder {
        private final Path.Element[] elements;
        private boolean isNormalized = true;
        private boolean leadingParent = true;

        private Builder(List elemList) {
            this(elemList.toArray(new Path.Element[elemList.size()]));
        }

        private Builder(Path.Element[] elements) {
            if (elements == null || elements.length == 0) {
                throw new IllegalArgumentException("Cannot build path from null or 0 elements.");
            }
            this.elements = elements;
            for (int i = 0; i < elements.length; ++i) {
                Path.Element elem = elements[i];
                this.leadingParent &= elem.denotesParent();
                this.isNormalized &= !elem.denotesCurrent() && (this.leadingParent || !elem.denotesParent());
            }
        }

        private Path getPath() {
            return new PathImpl(this.elements, this.isNormalized);
        }
    }

    private static final class SpecialElement
    extends Element {
        private static final int ROOT = 1;
        private static final int CURRENT = 2;
        private static final int PARENT = 4;
        private final int type;

        private SpecialElement(Name name) {
            super(name, 0);
            if (ROOT_NAME.equals(name)) {
                this.type = 1;
            } else if (CURRENT_NAME.equals(name)) {
                this.type = 2;
            } else if (PARENT_NAME.equals(name)) {
                this.type = 4;
            } else {
                throw new IllegalArgumentException();
            }
        }

        public boolean denotesRoot() {
            return this.type == 1;
        }

        public boolean denotesParent() {
            return this.type == 4;
        }

        public boolean denotesCurrent() {
            return this.type == 2;
        }

        public boolean denotesName() {
            return false;
        }
    }

    private static class Element
    implements Path.Element {
        private final Name name;
        private final int index;

        private Element(Name name, int index) {
            this.index = index;
            this.name = name;
        }

        public Name getName() {
            return this.name;
        }

        public int getIndex() {
            return this.index;
        }

        public int getNormalizedIndex() {
            if (this.index == 0) {
                return 1;
            }
            return this.index;
        }

        public boolean denotesRoot() {
            return false;
        }

        public boolean denotesParent() {
            return false;
        }

        public boolean denotesCurrent() {
            return false;
        }

        public boolean denotesName() {
            return true;
        }

        public String getString() {
            return this.toString();
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append(this.name.toString());
            if (this.index > 1) {
                sb.append('[');
                sb.append(this.index);
                sb.append(']');
            }
            return sb.toString();
        }

        public int hashCode() {
            int h = 17;
            h = 37 * h + this.getNormalizedIndex();
            h = 37 * h + this.name.hashCode();
            return h;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof Path.Element) {
                Path.Element other = (Path.Element)obj;
                return this.name.equals(other.getName()) && this.getNormalizedIndex() == other.getNormalizedIndex();
            }
            return false;
        }
    }

    private static final class PathImpl
    implements Path {
        private final Path.Element[] elements;
        private final boolean normalized;
        private final boolean absolute;
        private transient int hash = 0;
        private transient String string;

        private PathImpl(Path.Element[] elements, boolean isNormalized) {
            if (elements == null || elements.length == 0) {
                throw new IllegalArgumentException("Empty paths are not allowed");
            }
            this.elements = elements;
            this.absolute = elements[0].denotesRoot();
            this.normalized = isNormalized;
        }

        public boolean denotesRoot() {
            return this.absolute && this.elements.length == 1;
        }

        public boolean isAbsolute() {
            return this.absolute;
        }

        public boolean isCanonical() {
            return this.absolute && this.normalized;
        }

        public boolean isNormalized() {
            return this.normalized;
        }

        public Path getNormalizedPath() throws RepositoryException {
            if (this.isNormalized()) {
                return this;
            }
            LinkedList<Path.Element> queue = new LinkedList<Path.Element>();
            Path.Element last = PARENT_ELEMENT;
            for (int i = 0; i < this.elements.length; ++i) {
                Path.Element elem = this.elements[i];
                if (elem.denotesParent() && !last.denotesParent()) {
                    if (last.denotesRoot()) {
                        throw new RepositoryException("Path can not be canonicalized: unresolvable '..' element");
                    }
                    queue.removeLast();
                    if (queue.isEmpty()) {
                        last = PARENT_ELEMENT;
                        continue;
                    }
                    last = (Path.Element)queue.getLast();
                    continue;
                }
                if (elem.denotesCurrent()) continue;
                last = elem;
                queue.add(last);
            }
            if (queue.isEmpty()) {
                throw new RepositoryException("Path can not be normalized: would result in an empty path.");
            }
            boolean isNormalized = true;
            return new PathImpl(queue.toArray(new Path.Element[queue.size()]), isNormalized);
        }

        public Path getCanonicalPath() throws RepositoryException {
            if (this.isCanonical()) {
                return this;
            }
            if (!this.isAbsolute()) {
                throw new RepositoryException("Only an absolute path can be canonicalized.");
            }
            return this.getNormalizedPath();
        }

        public Path computeRelativePath(Path other) throws RepositoryException {
            Path p1;
            if (other == null) {
                throw new IllegalArgumentException("null argument");
            }
            if (!this.isAbsolute() || !other.isAbsolute()) {
                throw new RepositoryException("Cannot compute relative path from relative paths");
            }
            Path p0 = this.getCanonicalPath();
            if (p0.equals(p1 = other.getCanonicalPath())) {
                Builder pb = new Builder(new Path.Element[]{CURRENT_ELEMENT});
                return pb.getPath();
            }
            int lengthCommon = 0;
            Path.Element[] elems0 = p0.getElements();
            Path.Element[] elems1 = p1.getElements();
            for (int i = 0; i < elems0.length && i < elems1.length && elems0[i].equals(elems1[i]); ++i) {
                ++lengthCommon;
            }
            ArrayList<Path.Element> l = new ArrayList<Path.Element>();
            if (lengthCommon < elems0.length) {
                int tmp = elems0.length - lengthCommon;
                while (tmp-- > 0) {
                    l.add(0, PARENT_ELEMENT);
                }
            }
            for (int i = lengthCommon; i < elems1.length; ++i) {
                l.add(elems1[i]);
            }
            return new Builder(l).getPath();
        }

        public Path getAncestor(int degree) throws IllegalArgumentException, PathNotFoundException {
            if (degree < 0) {
                throw new IllegalArgumentException("degree must be >= 0");
            }
            if (degree == 0) {
                return this;
            }
            int length = this.elements.length - degree;
            if (length < 1) {
                throw new PathNotFoundException("no such ancestor path of degree " + degree);
            }
            Path.Element[] elements = new Path.Element[length];
            System.arraycopy(this.elements, 0, elements, 0, length);
            return new PathImpl(elements, this.normalized);
        }

        public int getAncestorCount() {
            return this.getDepth() - 1;
        }

        public int getLength() {
            return this.elements.length;
        }

        public int getDepth() {
            int depth = 0;
            for (int i = 0; i < this.elements.length; ++i) {
                if (this.elements[i].denotesParent()) {
                    --depth;
                    continue;
                }
                if (this.elements[i].denotesCurrent()) continue;
                ++depth;
            }
            return depth;
        }

        public boolean isAncestorOf(Path other) throws IllegalArgumentException, RepositoryException {
            Path p1;
            if (other == null) {
                throw new IllegalArgumentException("null argument");
            }
            if (this.isAbsolute() != other.isAbsolute()) {
                throw new IllegalArgumentException("Cannot compare a relative path with an absolute path");
            }
            Path p0 = this.getNormalizedPath();
            if (p0.equals(p1 = other.getNormalizedPath())) {
                return false;
            }
            if (p0.getDepth() >= p1.getDepth()) {
                return false;
            }
            Path.Element[] elems0 = p0.getElements();
            Path.Element[] elems1 = p1.getElements();
            for (int i = 0; i < elems0.length; ++i) {
                if (elems0[i].equals(elems1[i])) continue;
                return false;
            }
            return true;
        }

        public boolean isDescendantOf(Path other) throws IllegalArgumentException, RepositoryException {
            if (other == null) {
                throw new IllegalArgumentException("Null argument");
            }
            return other.isAncestorOf((Path)this);
        }

        public Path subPath(int from, int to) throws IllegalArgumentException, RepositoryException {
            if (from < 0 || to >= this.elements.length || from >= to) {
                throw new IllegalArgumentException();
            }
            if (!this.isNormalized()) {
                throw new RepositoryException("Cannot extract sub-Path from a non-normalized Path.");
            }
            Path.Element[] dest = new Path.Element[to - from];
            System.arraycopy(this.elements, from, dest, 0, dest.length);
            Builder pb = new Builder(dest);
            return pb.getPath();
        }

        public Path.Element getNameElement() {
            return this.elements[this.elements.length - 1];
        }

        public String getString() {
            return this.toString();
        }

        public Path.Element[] getElements() {
            return this.elements;
        }

        public String toString() {
            if (this.string == null) {
                StringBuffer sb = new StringBuffer();
                for (int i = 0; i < this.elements.length; ++i) {
                    if (i > 0) {
                        sb.append('\t');
                    }
                    Path.Element element = this.elements[i];
                    String elem = element.toString();
                    sb.append(elem);
                }
                this.string = sb.toString();
            }
            return this.string;
        }

        public int hashCode() {
            int h = this.hash;
            if (h == 0) {
                h = 17;
                for (int i = 0; i < this.elements.length; ++i) {
                    h = 37 * h + this.elements[i].hashCode();
                }
                this.hash = h;
            }
            return h;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof Path) {
                Path other = (Path)obj;
                return Arrays.equals(this.elements, other.getElements());
            }
            return false;
        }
    }
}

