/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api.records.impl.pb;

import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.TextFormat;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.api.records.QueueACL;
import org.apache.hadoop.yarn.api.records.QueueUserACLInfo;
import org.apache.hadoop.yarn.api.records.impl.pb.ProtoUtils;
import org.apache.hadoop.yarn.api.records.impl.pb.QueueUserACLInfoPBImpl;
import org.apache.hadoop.yarn.proto.YarnProtos;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class QueueUserACLInfoPBImpl
extends QueueUserACLInfo {
    YarnProtos.QueueUserACLInfoProto proto = YarnProtos.QueueUserACLInfoProto.getDefaultInstance();
    YarnProtos.QueueUserACLInfoProto.Builder builder = null;
    boolean viaProto = false;
    List<QueueACL> userAclsList;

    public QueueUserACLInfoPBImpl() {
        this.builder = YarnProtos.QueueUserACLInfoProto.newBuilder();
    }

    public QueueUserACLInfoPBImpl(YarnProtos.QueueUserACLInfoProto proto) {
        this.proto = proto;
        this.viaProto = true;
    }

    public String getQueueName() {
        YarnProtos.QueueUserACLInfoProto p = this.viaProto ? this.proto : this.builder;
        return p.hasQueueName() ? p.getQueueName() : null;
    }

    public List<QueueACL> getUserAcls() {
        this.initLocalQueueUserAclsList();
        return this.userAclsList;
    }

    public void setQueueName(String queueName) {
        this.maybeInitBuilder();
        if (queueName == null) {
            this.builder.clearQueueName();
            return;
        }
        this.builder.setQueueName(queueName);
    }

    public void setUserAcls(List<QueueACL> userAclsList) {
        if (userAclsList == null) {
            this.builder.clearUserAcls();
        }
        this.userAclsList = userAclsList;
    }

    public YarnProtos.QueueUserACLInfoProto getProto() {
        this.mergeLocalToProto();
        this.proto = this.viaProto ? this.proto : this.builder.build();
        this.viaProto = true;
        return this.proto;
    }

    public int hashCode() {
        return this.getProto().hashCode();
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other.getClass().isAssignableFrom(this.getClass())) {
            return this.getProto().equals((Object)((QueueUserACLInfoPBImpl)this.getClass().cast(other)).getProto());
        }
        return false;
    }

    public String toString() {
        return TextFormat.shortDebugString((MessageOrBuilder)this.getProto());
    }

    private void initLocalQueueUserAclsList() {
        if (this.userAclsList != null) {
            return;
        }
        YarnProtos.QueueUserACLInfoProto p = this.viaProto ? this.proto : this.builder;
        List list = p.getUserAclsList();
        this.userAclsList = new ArrayList();
        for (YarnProtos.QueueACLProto a : list) {
            this.userAclsList.add(this.convertFromProtoFormat(a));
        }
    }

    private void addQueueACLsToProto() {
        this.maybeInitBuilder();
        this.builder.clearUserAcls();
        if (this.userAclsList == null) {
            return;
        }
        1 iterable = new /* Unavailable Anonymous Inner Class!! */;
        this.builder.addAllUserAcls((Iterable)iterable);
    }

    private void maybeInitBuilder() {
        if (this.viaProto || this.builder == null) {
            this.builder = YarnProtos.QueueUserACLInfoProto.newBuilder((YarnProtos.QueueUserACLInfoProto)this.proto);
        }
        this.viaProto = false;
    }

    private void mergeLocalToBuilder() {
        if (this.userAclsList != null) {
            this.addQueueACLsToProto();
        }
    }

    private void mergeLocalToProto() {
        if (this.viaProto) {
            this.maybeInitBuilder();
        }
        this.mergeLocalToBuilder();
        this.proto = this.builder.build();
        this.viaProto = true;
    }

    private QueueACL convertFromProtoFormat(YarnProtos.QueueACLProto q) {
        return ProtoUtils.convertFromProtoFormat((YarnProtos.QueueACLProto)q);
    }

    private YarnProtos.QueueACLProto convertToProtoFormat(QueueACL queueAcl) {
        return ProtoUtils.convertToProtoFormat((QueueACL)queueAcl);
    }

    static /* synthetic */ YarnProtos.QueueACLProto access$000(QueueUserACLInfoPBImpl x0, QueueACL x1) {
        return x0.convertToProtoFormat(x1);
    }
}

