/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import org.apache.hadoop.util.VersionUtil;
import org.junit.Assert;
import org.junit.Test;

public class TestVersionUtil {
    @Test
    public void testCompareVersions() {
        Assert.assertEquals((long)0L, (long)VersionUtil.compareVersions((String)"2.0.0", (String)"2.0.0"));
        Assert.assertEquals((long)0L, (long)VersionUtil.compareVersions((String)"2.0.0a", (String)"2.0.0a"));
        Assert.assertEquals((long)0L, (long)VersionUtil.compareVersions((String)"1", (String)"1"));
        Assert.assertEquals((long)0L, (long)VersionUtil.compareVersions((String)"2.0.0-SNAPSHOT", (String)"2.0.0-SNAPSHOT"));
        TestVersionUtil.assertExpectedValues("1", "2.0.0");
        TestVersionUtil.assertExpectedValues("1.0.0", "2");
        TestVersionUtil.assertExpectedValues("1.0.0", "2.0.0");
        TestVersionUtil.assertExpectedValues("1.0", "2.0.0");
        TestVersionUtil.assertExpectedValues("1.0.0", "2.0.0");
        TestVersionUtil.assertExpectedValues("1.0.0", "1.0.0a");
        TestVersionUtil.assertExpectedValues("1.0.0.0", "2.0.0");
        TestVersionUtil.assertExpectedValues("1.0.0", "1.0.0-dev");
        TestVersionUtil.assertExpectedValues("1.0.0", "1.0.1");
        TestVersionUtil.assertExpectedValues("1.0.0", "1.0.2");
        TestVersionUtil.assertExpectedValues("1.0.0", "1.1.0");
        TestVersionUtil.assertExpectedValues("2.0.0", "10.0.0");
        TestVersionUtil.assertExpectedValues("1.0.0", "1.0.0a");
        TestVersionUtil.assertExpectedValues("1.0.2a", "1.0.10");
        TestVersionUtil.assertExpectedValues("1.0.2a", "1.0.2b");
        TestVersionUtil.assertExpectedValues("1.0.2a", "1.0.2ab");
        TestVersionUtil.assertExpectedValues("1.0.0a1", "1.0.0a2");
        TestVersionUtil.assertExpectedValues("1.0.0a2", "1.0.0a10");
        TestVersionUtil.assertExpectedValues("1.0", "1.a");
        TestVersionUtil.assertExpectedValues("1.0", "1.a0");
        TestVersionUtil.assertExpectedValues("1.0-SNAPSHOT", "1.0");
        TestVersionUtil.assertExpectedValues("1.0", "1.0.0-SNAPSHOT");
        TestVersionUtil.assertExpectedValues("1.0.0-SNAPSHOT", "1.0.0");
        TestVersionUtil.assertExpectedValues("1.0.0", "1.0.1-SNAPSHOT");
        TestVersionUtil.assertExpectedValues("1.0.1-SNAPSHOT", "1.0.1");
    }

    private static void assertExpectedValues(String lower, String higher) {
        Assert.assertTrue((VersionUtil.compareVersions((String)lower, (String)higher) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((VersionUtil.compareVersions((String)higher, (String)lower) > 0 ? 1 : 0) != 0);
    }
}

