/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.UTFDataFormatException;
import java.util.Random;
import junit.framework.TestCase;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.TestWritable;
import org.apache.hadoop.io.UTF8;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.util.StringUtils;

public class TestUTF8
extends TestCase {
    private static final Random RANDOM = new Random();

    public TestUTF8(String name) {
        super(name);
    }

    public static String getTestString() throws Exception {
        StringBuilder buffer = new StringBuilder();
        int length = RANDOM.nextInt(100);
        for (int i = 0; i < length; ++i) {
            buffer.append((char)RANDOM.nextInt(65535));
        }
        return buffer.toString();
    }

    public void testWritable() throws Exception {
        for (int i = 0; i < 10000; ++i) {
            TestWritable.testWritable((Writable)new UTF8(TestUTF8.getTestString()));
        }
    }

    public void testGetBytes() throws Exception {
        for (int i = 0; i < 10000; ++i) {
            String before = TestUTF8.getTestString();
            TestUTF8.assertEquals((String)before, (String)new String(UTF8.getBytes((String)before), "UTF-8"));
        }
    }

    public void testIO() throws Exception {
        DataOutputBuffer out = new DataOutputBuffer();
        DataInputBuffer in = new DataInputBuffer();
        for (int i = 0; i < 10000; ++i) {
            String before = TestUTF8.getTestString();
            out.reset();
            UTF8.writeString((DataOutput)out, (String)before);
            in.reset(out.getData(), out.getLength());
            String after = UTF8.readString((DataInput)in);
            TestUTF8.assertEquals((String)before, (String)after);
            in.reset(out.getData(), out.getLength());
            String after2 = in.readUTF();
            TestUTF8.assertEquals((String)before, (String)after2);
            String after3 = new String(out.getData(), 2, out.getLength() - 2, "UTF-8");
            TestUTF8.assertEquals((String)before, (String)after3);
        }
    }

    public void testNullEncoding() throws Exception {
        String s = new String(new char[]{'\u0000'});
        DataOutputBuffer dob = new DataOutputBuffer();
        new UTF8(s).write((DataOutput)dob);
        TestUTF8.assertEquals((String)s, (String)new String(dob.getData(), 2, dob.getLength() - 2, "UTF-8"));
    }

    public void testNonBasicMultilingualPlane() throws Exception {
        String catFace = "\ud83d\udc31";
        byte[] encoded = catFace.getBytes("UTF-8");
        TestUTF8.assertEquals((int)4, (int)encoded.length);
        TestUTF8.assertEquals((String)"f09f90b1", (String)StringUtils.byteToHexString((byte[])encoded));
        String roundTrip = UTF8.fromBytes((byte[])encoded);
        TestUTF8.assertEquals((String)catFace, (String)roundTrip);
    }

    public void testInvalidUTF8() throws Exception {
        byte[] invalid = new byte[]{1, 2, -1, -1, 1, 2, 3, 4, 5};
        try {
            UTF8.fromBytes((byte[])invalid);
            TestUTF8.fail((String)"did not throw an exception");
        }
        catch (UTFDataFormatException utfde) {
            GenericTestUtils.assertExceptionContains("Invalid UTF8 at ffff01020304", utfde);
        }
    }

    public void test5ByteUtf8Sequence() throws Exception {
        byte[] invalid = new byte[]{1, 2, -8, -120, -128, -128, -128, 4, 5};
        try {
            UTF8.fromBytes((byte[])invalid);
            TestUTF8.fail((String)"did not throw an exception");
        }
        catch (UTFDataFormatException utfde) {
            GenericTestUtils.assertExceptionContains("Invalid UTF8 at f88880808004", utfde);
        }
    }

    public void testInvalidUTF8Truncated() throws Exception {
        byte[] truncated = new byte[]{-16, -97, -112};
        try {
            UTF8.fromBytes((byte[])truncated);
            TestUTF8.fail((String)"did not throw an exception");
        }
        catch (UTFDataFormatException utfde) {
            GenericTestUtils.assertExceptionContains("Truncated UTF8 at f09f90", utfde);
        }
    }
}

