/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.connector.outbound;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TimerTask;
import javax.resource.ResourceException;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import org.apache.geronimo.connector.outbound.AbstractSinglePoolConnectionInterceptor;
import org.apache.geronimo.connector.outbound.ConnectionInfo;
import org.apache.geronimo.connector.outbound.ConnectionInterceptor;
import org.apache.geronimo.connector.outbound.ConnectionReturnAction;
import org.apache.geronimo.connector.outbound.ManagedConnectionInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SinglePoolMatchAllConnectionInterceptor
extends AbstractSinglePoolConnectionInterceptor {
    private Map<ManagedConnection, ManagedConnectionInfo> pool;
    private final int maxSize;

    public SinglePoolMatchAllConnectionInterceptor(ConnectionInterceptor next, int maxSize, int minSize, int blockingTimeoutMilliseconds, int idleTimeoutMinutes) {
        super(next, maxSize, minSize, blockingTimeoutMilliseconds, idleTimeoutMinutes);
        this.maxSize = maxSize;
        this.pool = new HashMap<ManagedConnection, ManagedConnectionInfo>(maxSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void internalGetConnection(ConnectionInfo connectionInfo) throws ResourceException {
        Map<ManagedConnection, ManagedConnectionInfo> map = this.pool;
        synchronized (map) {
            if (this.destroyed) {
                throw new ResourceException("ManagedConnection pool has been destroyed");
            }
            try {
                ManagedConnectionInfo mci;
                ManagedConnectionFactory managedConnectionFactory;
                ManagedConnection matchedMC;
                if (!this.pool.isEmpty() && (matchedMC = (managedConnectionFactory = (mci = connectionInfo.getManagedConnectionInfo()).getManagedConnectionFactory()).matchManagedConnections(this.pool.keySet(), mci.getSubject(), mci.getConnectionRequestInfo())) != null) {
                    connectionInfo.setManagedConnectionInfo(this.pool.get(matchedMC));
                    this.pool.remove(matchedMC);
                    if (log.isTraceEnabled()) {
                        log.trace((Object)("Returning pooled connection " + connectionInfo.getManagedConnectionInfo()));
                    }
                    if (this.connectionCount < this.minSize) {
                        this.timer.schedule((TimerTask)new AbstractSinglePoolConnectionInterceptor.FillTask(connectionInfo), 10L);
                    }
                    return;
                }
                if (this.connectionCount == this.maxSize) {
                    Iterator<Map.Entry<ManagedConnection, ManagedConnectionInfo>> iterator = this.pool.entrySet().iterator();
                    ManagedConnectionInfo kill = iterator.next().getValue();
                    iterator.remove();
                    ConnectionInfo killInfo = new ConnectionInfo(kill);
                    this.internalReturn(killInfo, ConnectionReturnAction.DESTROY);
                }
                this.next.getConnection(connectionInfo);
                ++this.connectionCount;
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Returning new connection " + connectionInfo.getManagedConnectionInfo()));
                }
                if (this.connectionCount < this.minSize) {
                    this.timer.schedule((TimerTask)new AbstractSinglePoolConnectionInterceptor.FillTask(connectionInfo), 10L);
                }
            }
            catch (ResourceException e) {
                this.permits.release();
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean internalReturn(ConnectionInfo connectionInfo, ConnectionReturnAction connectionReturnAction) {
        ManagedConnectionInfo mci = connectionInfo.getManagedConnectionInfo();
        ManagedConnection mc = mci.getManagedConnection();
        try {
            mc.cleanup();
        }
        catch (ResourceException e) {
            connectionReturnAction = ConnectionReturnAction.DESTROY;
        }
        boolean wasInPool = false;
        Map<ManagedConnection, ManagedConnectionInfo> map = this.pool;
        synchronized (map) {
            if (this.destroyed) {
                try {
                    mc.destroy();
                }
                catch (ResourceException re) {
                    // empty catch block
                }
                return this.pool.remove(mci.getManagedConnection()) != null;
            }
            if (this.shrinkLater > 0) {
                connectionReturnAction = ConnectionReturnAction.DESTROY;
                --this.shrinkLater;
            } else {
                if (connectionReturnAction == ConnectionReturnAction.RETURN_HANDLE) {
                    mci.setLastUsed(System.currentTimeMillis());
                    this.pool.put(mci.getManagedConnection(), mci);
                    return wasInPool;
                }
                wasInPool = this.pool.remove(mci.getManagedConnection()) != null;
            }
        }
        this.next.returnConnection(connectionInfo, connectionReturnAction);
        --this.connectionCount;
        return wasInPool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void internalDestroy() {
        Map<ManagedConnection, ManagedConnectionInfo> map = this.pool;
        synchronized (map) {
            for (ManagedConnection managedConnection : this.pool.keySet()) {
                try {
                    managedConnection.destroy();
                }
                catch (ResourceException ignore) {}
            }
            this.pool.clear();
        }
    }

    @Override
    public int getPartitionMaxSize() {
        return this.maxSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getIdleConnectionCount() {
        Map<ManagedConnection, ManagedConnectionInfo> map = this.pool;
        synchronized (map) {
            return this.pool.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void transferConnections(int maxSize, int shrinkNow) {
        Map<ManagedConnection, ManagedConnectionInfo> map = this.pool;
        synchronized (map) {
            Map<ManagedConnection, ManagedConnectionInfo> oldPool = this.pool;
            HashMap<ManagedConnection, ManagedConnectionInfo> newPool = new HashMap<ManagedConnection, ManagedConnectionInfo>(maxSize);
            assert (oldPool.size() == this.connectionCount);
            Iterator<Map.Entry<ManagedConnection, ManagedConnectionInfo>> it = oldPool.entrySet().iterator();
            for (int i = 0; i < shrinkNow; ++i) {
                ConnectionInfo killInfo = new ConnectionInfo(it.next().getValue());
                this.internalReturn(killInfo, ConnectionReturnAction.DESTROY);
            }
            while (it.hasNext()) {
                Map.Entry<ManagedConnection, ManagedConnectionInfo> entry = it.next();
                newPool.put(entry.getKey(), entry.getValue());
            }
            this.pool = newPool;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void getExpiredManagedConnectionInfos(long threshold, List<ManagedConnectionInfo> killList) {
        Map<ManagedConnection, ManagedConnectionInfo> map = this.pool;
        synchronized (map) {
            for (ManagedConnectionInfo mci : this.pool.values()) {
                if (mci.getLastUsed() >= threshold) continue;
                killList.add(mci);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean addToPool(ManagedConnectionInfo mci) {
        boolean added;
        Map<ManagedConnection, ManagedConnectionInfo> map = this.pool;
        synchronized (map) {
            ++this.connectionCount;
            boolean bl = added = this.getPartitionMaxSize() > this.getIdleConnectionCount();
            if (added) {
                this.pool.put(mci.getManagedConnection(), mci);
            }
        }
        return added;
    }
}

