/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.bundleplugin.baseline;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import org.apache.felix.bundleplugin.baseline.AbstractBaselinePlugin;
import org.apache.felix.bundleplugin.baseline.DiffMessage;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.xml.PrettyPrintXMLWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BaselinePlugin
extends AbstractBaselinePlugin {
    private static final String TABLE_PATTERN = "%s %-50s %-10s %-10s %-10s %-10s %-10s";
    private File xmlOutputFile;
    private boolean logResults;
    private FileWriter xmlFileWriter;
    private PrettyPrintXMLWriter xmlWriter;

    @Override
    protected void init() {
        if (this.xmlOutputFile != null) {
            this.xmlOutputFile.getParentFile().mkdirs();
            try {
                this.xmlFileWriter = new FileWriter(this.xmlOutputFile);
                this.xmlWriter = new PrettyPrintXMLWriter((Writer)this.xmlFileWriter);
            }
            catch (IOException e) {
                this.getLog().warn((CharSequence)("No XML report will be produced, cannot write data to " + this.xmlOutputFile), (Throwable)e);
            }
        }
    }

    @Override
    protected void startBaseline(String generationDate, String bundleName, String currentVersion, String previousVersion) {
        if (this.isLoggingResults()) {
            this.log("Baseline Report - Generated by Apache Felix Maven Bundle Plugin on %s based on Bnd - see http://www.aqute.biz/Bnd/Bnd", generationDate);
            this.log("Comparing bundle %s version %s to version %s", bundleName, currentVersion, previousVersion);
            this.log("", new Object[0]);
            this.log(TABLE_PATTERN, " ", "PACKAGE_NAME", "DELTA", "CUR_VER", "BASE_VER", "REC_VER", "WARNINGS", "ATTRIBUTES");
            this.log(TABLE_PATTERN, "=", "==================================================", "==========", "==========", "==========", "==========", "==========", "==========");
        }
        if (this.isProducingXml()) {
            this.xmlWriter.startElement("baseline");
            this.xmlWriter.addAttribute("version", "1.0.0");
            this.xmlWriter.addAttribute("vendor", "The Apache Software Foundation");
            this.xmlWriter.addAttribute("vendorURL", "http://www.apache.org/");
            this.xmlWriter.addAttribute("generator", "Apache Felix Maven Bundle Plugin");
            this.xmlWriter.addAttribute("generatorURL", "http://felix.apache.org/site/apache-felix-maven-bundle-plugin-bnd.html");
            this.xmlWriter.addAttribute("analyzer", "Bnd");
            this.xmlWriter.addAttribute("analyzerURL", "http://www.aqute.biz/Bnd/Bnd");
            this.xmlWriter.addAttribute("generatedOn", generationDate);
            this.xmlWriter.addAttribute("bundleName", bundleName);
            this.xmlWriter.addAttribute("currentVersion", currentVersion);
            this.xmlWriter.addAttribute("previousVersion", previousVersion);
        }
    }

    @Override
    protected void startPackage(boolean mismatch, String name, String shortDelta, String delta, String newerVersion, String olderVersion, String suggestedVersion, DiffMessage diffMessage, Map<String, String> attributes) {
        if (this.isLoggingResults()) {
            this.log(TABLE_PATTERN, mismatch ? Character.valueOf('*') : shortDelta, name, delta, newerVersion, olderVersion, suggestedVersion, diffMessage != null ? diffMessage : Character.valueOf('-'), attributes);
        }
        if (this.isProducingXml()) {
            this.xmlWriter.startElement("package");
            this.xmlWriter.addAttribute("name", name);
            this.xmlWriter.addAttribute("delta", delta);
            this.simpleElement("mismatch", String.valueOf(mismatch));
            this.simpleElement("newerVersion", newerVersion);
            this.simpleElement("olderVersion", olderVersion);
            this.simpleElement("suggestedVersion", suggestedVersion);
            if (diffMessage != null) {
                this.simpleElement(diffMessage.getType().name(), diffMessage.getMessage());
            }
            this.xmlWriter.startElement("attributes");
            if (attributes != null) {
                for (Map.Entry<String, String> attribute : attributes.entrySet()) {
                    String attributeName = attribute.getKey();
                    if (':' == attributeName.charAt(attributeName.length() - 1)) {
                        attributeName = attributeName.substring(0, attributeName.length() - 1);
                    }
                    String attributeValue = attribute.getValue();
                    this.xmlWriter.startElement(attributeName);
                    this.xmlWriter.writeText(attributeValue);
                    this.xmlWriter.endElement();
                }
            }
            this.xmlWriter.endElement();
        }
    }

    @Override
    protected void startDiff(int depth, String type, String name, String delta, String shortDelta) {
        if (this.isLoggingResults()) {
            this.log("%-" + depth * 4 + "s %s %s %s", "", shortDelta, type, name);
        }
        if (this.isProducingXml()) {
            this.xmlWriter.startElement(type);
            this.xmlWriter.addAttribute("name", name);
            this.xmlWriter.addAttribute("delta", delta);
        }
    }

    @Override
    protected void endDiff(int depth) {
        if (this.isProducingXml()) {
            this.xmlWriter.endElement();
        }
    }

    @Override
    protected void endPackage() {
        if (this.isLoggingResults()) {
            this.log("-----------------------------------------------------------------------------------------------------------", new Object[0]);
        }
        if (this.isProducingXml()) {
            this.xmlWriter.endElement();
        }
    }

    @Override
    protected void endBaseline() {
        if (this.xmlWriter != null) {
            this.xmlWriter.endElement();
            IOUtil.close((Writer)this.xmlFileWriter);
        }
    }

    private boolean isProducingXml() {
        return this.xmlFileWriter != null && this.xmlWriter != null;
    }

    private boolean isLoggingResults() {
        return this.logResults && this.getLog().isInfoEnabled();
    }

    private void log(String format, Object ... args) {
        this.getLog().info((CharSequence)String.format(format, args));
    }

    private void simpleElement(String name, String value) {
        this.xmlWriter.startElement(name);
        this.xmlWriter.writeText(value);
        this.xmlWriter.endElement();
    }
}

