/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.bundleplugin;

import aQute.lib.osgi.Analyzer;
import aQute.lib.osgi.Builder;
import aQute.lib.osgi.Jar;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.jar.Manifest;
import org.apache.felix.bundleplugin.BundlePlugin;
import org.apache.felix.bundleplugin.DependencyEmbedder;
import org.apache.felix.bundleplugin.PackageVersionAnalyzer;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;

public class ManifestPlugin
extends BundlePlugin {
    protected void execute(MavenProject project, Map instructions, Properties properties, Jar[] classpath) throws MojoExecutionException {
        Manifest manifest;
        try {
            if ("bundle".equals(project.getPackaging())) {
                Builder builder = this.buildOSGiBundle(project, instructions, properties, classpath);
                manifest = builder.getJar().getManifest();
                builder.close();
            } else {
                manifest = this.getManifest(project, instructions, properties, classpath);
            }
        }
        catch (FileNotFoundException e) {
            throw new MojoExecutionException("Cannot find " + e.getMessage() + " (manifest goal must be run after compile phase)", (Exception)e);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error trying to generate Manifest", (Exception)e);
        }
        catch (MojoFailureException e) {
            this.getLog().error((CharSequence)e.getLocalizedMessage());
            throw new MojoExecutionException("Error(s) found in manifest configuration", (Exception)((Object)e));
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)"An internal error occurred", (Throwable)e);
            throw new MojoExecutionException("Internal error in maven-bundle-plugin", e);
        }
        File outputFile = new File(this.manifestLocation, "MANIFEST.MF");
        try {
            ManifestPlugin.writeManifest(manifest, outputFile);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error trying to write Manifest to file " + outputFile, (Exception)e);
        }
    }

    public Manifest getManifest(MavenProject project, Jar[] classpath) throws IOException, MojoFailureException, MojoExecutionException {
        return this.getManifest(project, new Properties(), new Properties(), classpath);
    }

    public Manifest getManifest(MavenProject project, Map instructions, Properties properties, Jar[] classpath) throws IOException, MojoFailureException, MojoExecutionException {
        String failok;
        Analyzer analyzer = this.getAnalyzer(project, instructions, properties, classpath);
        List errors = analyzer.getErrors();
        List warnings = analyzer.getWarnings();
        for (String msg : warnings) {
            this.getLog().warn((CharSequence)("Warning in manifest for " + project.getArtifact() + " : " + msg));
        }
        for (String msg : errors) {
            this.getLog().error((CharSequence)("Error in manifest for " + project.getArtifact() + " : " + msg));
        }
        if (errors.size() > 0 && (null == (failok = analyzer.getProperty("-failok")) || "false".equalsIgnoreCase(failok))) {
            throw new MojoFailureException("Error(s) found in manifest configuration");
        }
        Manifest manifest = analyzer.getJar().getManifest();
        analyzer.close();
        return manifest;
    }

    protected Analyzer getAnalyzer(MavenProject project, Jar[] classpath) throws IOException, MojoExecutionException {
        return this.getAnalyzer(project, new LinkedHashMap(), new Properties(), classpath);
    }

    protected Analyzer getAnalyzer(MavenProject project, Map instructions, Properties properties, Jar[] classpath) throws IOException, MojoExecutionException {
        File file = project.getArtifact().getFile();
        if (file == null) {
            file = this.getOutputDirectory();
        }
        if (!file.exists()) {
            throw new FileNotFoundException(file.getPath());
        }
        properties.putAll((Map<?, ?>)this.getDefaultProperties(project));
        properties.putAll((Map<?, ?>)ManifestPlugin.transformDirectives(instructions));
        PackageVersionAnalyzer analyzer = new PackageVersionAnalyzer();
        if (project.getBasedir() != null) {
            analyzer.setBase(project.getBasedir());
        }
        analyzer.setProperties(properties);
        if (classpath != null) {
            analyzer.setClasspath(classpath);
        }
        analyzer.setJar(file);
        if (analyzer.getProperty("Export-Package") == null && analyzer.getProperty("-exportcontents") == null && analyzer.getProperty("Private-Package") == null) {
            String export = analyzer.calculateExportsFromContents(analyzer.getJar());
            analyzer.setProperty("Export-Package", export);
        }
        Collection embeddableArtifacts = this.getEmbeddableArtifacts(project, analyzer);
        new DependencyEmbedder(this.getLog(), embeddableArtifacts).processHeaders(analyzer);
        ManifestPlugin.dumpInstructions("BND Instructions:", analyzer.getProperties(), this.getLog());
        ManifestPlugin.dumpClasspath("BND Classpath:", analyzer.getClasspath(), this.getLog());
        analyzer.mergeManifest(analyzer.getJar().getManifest());
        analyzer.calcManifest();
        ManifestPlugin.dumpManifest("BND Manifest:", analyzer.getJar().getManifest(), this.getLog());
        return analyzer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeManifest(Manifest manifest, File outputFile) throws IOException {
        outputFile.getParentFile().mkdirs();
        FileOutputStream os = new FileOutputStream(outputFile);
        try {
            manifest.write(os);
        }
        finally {
            try {
                os.close();
            }
            catch (IOException iOException) {}
        }
    }
}

