/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.schema.comparators;

import java.io.IOException;
import java.text.ParseException;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.schema.LdapComparator;
import org.apache.directory.shared.ldap.schema.PrepareString;
import org.apache.directory.shared.ldap.util.GeneralizedTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeneralizedTimeComparator
extends LdapComparator<String> {
    private static final Logger LOG = LoggerFactory.getLogger(GeneralizedTimeComparator.class);
    private static final long serialVersionUID = 1L;

    public GeneralizedTimeComparator(String oid) {
        super(oid);
    }

    @Override
    public int compare(String backendValue, String assertValue) {
        GeneralizedTime assertTime;
        GeneralizedTime backendTime;
        LOG.debug("comparing generalizedTimeOrdering objects '{}' with '{}'", (Object)backendValue, (Object)assertValue);
        if (backendValue == assertValue) {
            return 0;
        }
        if (backendValue == null || assertValue == null) {
            return backendValue == null ? -1 : 1;
        }
        try {
            String prepared = PrepareString.normalize(backendValue, PrepareString.StringType.DIRECTORY_STRING);
            backendTime = new GeneralizedTime(prepared);
        }
        catch (IOException ioe) {
            throw new IllegalArgumentException(I18n.err((String)"ERR_04224", (Object[])new Object[]{backendValue}));
        }
        catch (ParseException pe) {
            throw new IllegalArgumentException(I18n.err((String)"ERR_04224", (Object[])new Object[]{backendValue}));
        }
        try {
            String prepared = PrepareString.normalize(assertValue, PrepareString.StringType.DIRECTORY_STRING);
            assertTime = new GeneralizedTime(prepared);
        }
        catch (IOException ioe) {
            throw new IllegalArgumentException(I18n.err((String)"ERR_04224", (Object[])new Object[]{assertValue}));
        }
        catch (ParseException pe) {
            throw new IllegalArgumentException(I18n.err((String)"ERR_04224", (Object[])new Object[]{assertValue}));
        }
        return backendTime.compareTo(assertTime);
    }
}

