/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.actions;

import org.apache.directory.shared.asn1.ber.IAsn1Container;
import org.apache.directory.shared.asn1.ber.grammar.GrammarAction;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.asn1.codec.DecoderException;
import org.apache.directory.shared.ldap.codec.LdapMessageCodec;
import org.apache.directory.shared.ldap.codec.LdapMessageContainer;
import org.apache.directory.shared.ldap.codec.search.ExtensibleMatchFilter;
import org.apache.directory.shared.ldap.codec.search.SearchRequestCodec;
import org.apache.directory.shared.ldap.entry.client.ClientBinaryValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoreMatchValueAction
extends GrammarAction {
    private static final Logger log = LoggerFactory.getLogger(StoreMatchValueAction.class);
    private static final boolean IS_DEBUG = log.isDebugEnabled();

    public StoreMatchValueAction() {
        super("Store match Value");
    }

    public void action(IAsn1Container container) throws DecoderException {
        LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
        LdapMessageCodec ldapMessage = ldapMessageContainer.getLdapMessage();
        SearchRequestCodec searchRequest = ldapMessage.getSearchRequest();
        TLV tlv = ldapMessageContainer.getCurrentTLV();
        ExtensibleMatchFilter extensibleMatchFilter = (ExtensibleMatchFilter)searchRequest.getTerminalFilter();
        byte[] value = tlv.getValue().getData();
        extensibleMatchFilter.setMatchValue(new ClientBinaryValue(value));
        searchRequest.unstackFilters(container);
        if (IS_DEBUG) {
            log.debug("Stored a match value : {}", (Object)value);
        }
    }
}

