/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.xdbm.search.impl;

import org.apache.directory.server.core.entry.ServerEntry;
import org.apache.directory.server.xdbm.AbstractIndexCursor;
import org.apache.directory.server.xdbm.ForwardIndexEntry;
import org.apache.directory.server.xdbm.IndexCursor;
import org.apache.directory.server.xdbm.IndexEntry;
import org.apache.directory.server.xdbm.Store;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AllEntriesCursor
extends AbstractIndexCursor<Long, ServerEntry> {
    private IndexEntry<Long, ServerEntry> indexEntry = new ForwardIndexEntry<Long, ServerEntry>();
    private final IndexCursor<String, ServerEntry> wrapped;

    public AllEntriesCursor(Store<ServerEntry> db) throws Exception {
        this.wrapped = db.getNdnIndex().reverseCursor();
    }

    @Override
    public void afterValue(Long key, Long value) throws Exception {
        this.checkNotClosed("afterValue()");
        this.wrapped.afterValue(key, null);
    }

    @Override
    public void beforeValue(Long id, Long value) throws Exception {
        this.checkNotClosed("beforeValue()");
        this.wrapped.beforeValue(id, null);
    }

    @Override
    public void after(IndexEntry<Long, ServerEntry> indexEntry) throws Exception {
        this.checkNotClosed("after()");
        this.wrapped.afterValue(indexEntry.getId(), null);
    }

    @Override
    public void afterLast() throws Exception {
        this.checkNotClosed("afterLast()");
        this.wrapped.afterLast();
    }

    @Override
    public boolean available() {
        return this.wrapped.available();
    }

    @Override
    public void before(IndexEntry<Long, ServerEntry> indexEntry) throws Exception {
        this.checkNotClosed("before()");
        this.wrapped.beforeValue(indexEntry.getId(), null);
    }

    @Override
    public void beforeFirst() throws Exception {
        this.checkNotClosed("beforeFirst()");
        this.wrapped.beforeFirst();
    }

    @Override
    public boolean first() throws Exception {
        this.checkNotClosed("first()");
        return this.wrapped.first();
    }

    @Override
    public IndexEntry<Long, ServerEntry> get() throws Exception {
        this.checkNotClosed("get()");
        IndexEntry wrappedEntry = (IndexEntry)this.wrapped.get();
        this.indexEntry.setId(wrappedEntry.getId());
        this.indexEntry.setValue(wrappedEntry.getId());
        this.indexEntry.setObject((ServerEntry)wrappedEntry.getObject());
        return this.indexEntry;
    }

    @Override
    public boolean isElementReused() {
        return true;
    }

    @Override
    public boolean last() throws Exception {
        this.checkNotClosed("last()");
        return this.wrapped.last();
    }

    @Override
    public boolean next() throws Exception {
        this.checkNotClosed("next()");
        return this.wrapped.next();
    }

    @Override
    public boolean previous() throws Exception {
        this.checkNotClosed("previous()");
        return this.wrapped.previous();
    }
}

