/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.partition;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import javax.naming.ConfigurationException;
import javax.naming.NameNotFoundException;
import javax.naming.directory.SearchControls;
import javax.naming.ldap.LdapContext;
import org.apache.directory.server.core.CoreSession;
import org.apache.directory.server.core.DefaultCoreSession;
import org.apache.directory.server.core.DirectoryService;
import org.apache.directory.server.core.authn.LdapPrincipal;
import org.apache.directory.server.core.entry.ClonedServerEntry;
import org.apache.directory.server.core.entry.DefaultServerAttribute;
import org.apache.directory.server.core.entry.DefaultServerEntry;
import org.apache.directory.server.core.entry.ServerEntry;
import org.apache.directory.server.core.filtering.BaseEntryFilteringCursor;
import org.apache.directory.server.core.filtering.EntryFilteringCursor;
import org.apache.directory.server.core.interceptor.context.AddContextPartitionOperationContext;
import org.apache.directory.server.core.interceptor.context.AddOperationContext;
import org.apache.directory.server.core.interceptor.context.BindOperationContext;
import org.apache.directory.server.core.interceptor.context.CompareOperationContext;
import org.apache.directory.server.core.interceptor.context.DeleteOperationContext;
import org.apache.directory.server.core.interceptor.context.EntryOperationContext;
import org.apache.directory.server.core.interceptor.context.GetMatchedNameOperationContext;
import org.apache.directory.server.core.interceptor.context.GetRootDSEOperationContext;
import org.apache.directory.server.core.interceptor.context.GetSuffixOperationContext;
import org.apache.directory.server.core.interceptor.context.ListOperationContext;
import org.apache.directory.server.core.interceptor.context.ListSuffixOperationContext;
import org.apache.directory.server.core.interceptor.context.LookupOperationContext;
import org.apache.directory.server.core.interceptor.context.ModifyOperationContext;
import org.apache.directory.server.core.interceptor.context.MoveAndRenameOperationContext;
import org.apache.directory.server.core.interceptor.context.MoveOperationContext;
import org.apache.directory.server.core.interceptor.context.RemoveContextPartitionOperationContext;
import org.apache.directory.server.core.interceptor.context.RenameOperationContext;
import org.apache.directory.server.core.interceptor.context.SearchOperationContext;
import org.apache.directory.server.core.interceptor.context.UnbindOperationContext;
import org.apache.directory.server.core.partition.Partition;
import org.apache.directory.server.core.partition.PartitionNexus;
import org.apache.directory.server.core.partition.impl.btree.jdbm.JdbmIndex;
import org.apache.directory.server.core.partition.impl.btree.jdbm.JdbmPartition;
import org.apache.directory.server.schema.registries.AttributeTypeRegistry;
import org.apache.directory.server.schema.registries.OidRegistry;
import org.apache.directory.server.schema.registries.Registries;
import org.apache.directory.server.xdbm.Index;
import org.apache.directory.shared.ldap.MultiException;
import org.apache.directory.shared.ldap.NotImplementedException;
import org.apache.directory.shared.ldap.constants.AuthenticationLevel;
import org.apache.directory.shared.ldap.cursor.SingletonCursor;
import org.apache.directory.shared.ldap.entry.EntryAttribute;
import org.apache.directory.shared.ldap.entry.Value;
import org.apache.directory.shared.ldap.exception.LdapInvalidAttributeIdentifierException;
import org.apache.directory.shared.ldap.exception.LdapNameNotFoundException;
import org.apache.directory.shared.ldap.exception.LdapNoSuchAttributeException;
import org.apache.directory.shared.ldap.filter.ExprNode;
import org.apache.directory.shared.ldap.filter.PresenceNode;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.schema.AttributeType;
import org.apache.directory.shared.ldap.schema.Normalizer;
import org.apache.directory.shared.ldap.schema.SchemaUtils;
import org.apache.directory.shared.ldap.schema.UsageEnum;
import org.apache.directory.shared.ldap.util.DateUtils;
import org.apache.directory.shared.ldap.util.NamespaceTools;
import org.apache.directory.shared.ldap.util.tree.DnBranchNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultPartitionNexus
extends PartitionNexus {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultPartitionNexus.class);
    private static final boolean IS_DEBUG = LOG.isDebugEnabled();
    private static final String ASF = "Apache Software Foundation";
    private boolean initialized;
    private DirectoryService directoryService;
    private Partition system;
    private Map<String, Partition> partitions = new HashMap<String, Partition>();
    private DnBranchNode<Partition> partitionLookupTree = new DnBranchNode();
    private final ServerEntry rootDSE;
    private Registries registries;
    private AttributeTypeRegistry atRegistry;
    private OidRegistry oidRegistry;

    public DefaultPartitionNexus(ServerEntry rootDSE) throws Exception {
        this.rootDSE = rootDSE;
        rootDSE.put("subschemaSubentry", "cn=schema");
        rootDSE.put("supportedLDAPVersion", "3");
        rootDSE.put("supportedFeatures", "1.3.6.1.4.1.4203.1.5.1");
        rootDSE.put("supportedExtension", "1.3.6.1.4.1.1466.20036");
        rootDSE.put("supportedControl", "2.16.840.1.113730.3.4.3", "2.16.840.1.113730.3.4.7", "1.3.6.1.4.1.4203.1.10.1", "2.16.840.1.113730.3.4.2", "1.3.6.1.4.1.18060.0.0.1", "1.2.840.113556.1.4.319", "1.3.6.1.4.1.4203.1.9.1.3", "1.3.6.1.4.1.4203.1.9.1.4", "1.3.6.1.4.1.4203.1.9.1.1", "1.3.6.1.4.1.4203.1.9.1.2");
        rootDSE.put("objectClass", "top", "extensibleObject");
        rootDSE.put("vendorName", ASF);
        Properties props = new Properties();
        try {
            props.load(this.getClass().getResourceAsStream("version.properties"));
        }
        catch (IOException e) {
            LOG.error("failed to LOG version properties");
        }
        rootDSE.put("vendorVersion", props.getProperty("apacheds.version", "UNKNOWN"));
    }

    @Override
    public String getId() {
        return "NEXUS";
    }

    @Override
    public void setId(String id) {
        throw new UnsupportedOperationException("The id cannot be set for the partition nexus.");
    }

    @Override
    public String getSuffix() {
        return "";
    }

    @Override
    public void setSuffix(String suffix) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setCacheSize(int cacheSize) {
        throw new UnsupportedOperationException("You cannot set the cache size of the nexus");
    }

    @Override
    public int getCacheSize() {
        throw new UnsupportedOperationException("There is no cache size associated with the nexus");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init(DirectoryService directoryService) throws Exception {
        if (this.initialized) {
            return;
        }
        this.directoryService = directoryService;
        this.registries = directoryService.getRegistries();
        this.atRegistry = this.registries.getAttributeTypeRegistry();
        this.oidRegistry = this.registries.getOidRegistry();
        this.initializeSystemPartition();
        ArrayList<Partition> initializedPartitions = new ArrayList<Partition>();
        initializedPartitions.add(0, this.system);
        Iterator<? extends Partition> partitions = directoryService.getPartitions().iterator();
        try {
            while (partitions.hasNext()) {
                Partition partition = partitions.next();
                LdapDN adminDn = new LdapDN("0.9.2342.19200300.100.1.1=admin,2.5.4.11=system");
                adminDn.normalize(this.registries.getAttributeTypeRegistry().getNormalizerMapping());
                DefaultCoreSession adminSession = new DefaultCoreSession(new LdapPrincipal(adminDn, AuthenticationLevel.STRONG), directoryService);
                AddContextPartitionOperationContext opCtx = new AddContextPartitionOperationContext((CoreSession)adminSession, partition);
                this.addContextPartition(opCtx);
                initializedPartitions.add(opCtx.getPartition());
            }
            this.initialized = true;
        }
        finally {
            if (!this.initialized) {
                Iterator i = initializedPartitions.iterator();
                while (i.hasNext()) {
                    Partition partition = (Partition)i.next();
                    i.remove();
                    try {
                        partition.destroy();
                    }
                    catch (Exception e) {
                        LOG.warn("Failed to destroy a partition: " + partition.getSuffixDn(), e);
                    }
                    finally {
                        this.unregister(partition);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Partition initializeSystemPartition() throws Exception {
        String key;
        Partition override = this.directoryService.getSystemPartition();
        if (override != null) {
            if (!override.getId().equals("system")) {
                throw new ConfigurationException("System partition has wrong name: should be 'system' not '" + override.getId() + "'.");
            }
            if (override instanceof JdbmPartition) {
                Set<Index<?, ServerEntry>> indices = ((JdbmPartition)override).getIndexedAttributes();
                HashSet<String> indexOids = new HashSet<String>();
                OidRegistry registry = this.registries.getOidRegistry();
                for (Index<?, ServerEntry> index : indices) {
                    indexOids.add(registry.getOid(index.getAttributeId()));
                }
                if (!indexOids.contains(registry.getOid("objectClass"))) {
                    LOG.warn("CAUTION: You have not included objectClass as an indexed attributein the system partition configuration.  This will lead to poor performance.  The server is automatically adding this index for you.");
                    JdbmIndex index = new JdbmIndex();
                    index.setAttributeId("objectClass");
                    indices.add(index);
                }
                ((JdbmPartition)override).setIndexedAttributes(indices);
            }
            this.system = override;
        } else {
            this.system = new JdbmPartition();
            this.system.setId("system");
            this.system.setCacheSize(500);
            this.system.setSuffix("ou=system");
            HashSet indexedAttrs = new HashSet();
            indexedAttrs.add(new JdbmIndex("objectClass"));
            ((JdbmPartition)this.system).setIndexedAttributes(indexedAttrs);
        }
        this.system.init(this.directoryService);
        LdapDN systemSuffixDn = new LdapDN("ou=system");
        systemSuffixDn.normalize(this.registries.getAttributeTypeRegistry().getNormalizerMapping());
        DefaultServerEntry systemEntry = new DefaultServerEntry(this.registries, systemSuffixDn);
        systemEntry.put("objectClass", "top", "organizationalUnit", "extensibleObject");
        systemEntry.put("creatorsName", "uid=admin,ou=system");
        systemEntry.put("createTimestamp", DateUtils.getGeneralizedTime());
        systemEntry.add("entryCSN", this.directoryService.getCSN().toString());
        systemEntry.add("entryUUID", (byte[][])new byte[][]{SchemaUtils.uuidToBytes(UUID.randomUUID())});
        systemEntry.put(NamespaceTools.getRdnAttribute("ou=system"), NamespaceTools.getRdnValue("ou=system"));
        LdapDN adminDn = new LdapDN("0.9.2342.19200300.100.1.1=admin,2.5.4.11=system");
        adminDn.normalize(this.registries.getAttributeTypeRegistry().getNormalizerMapping());
        DefaultCoreSession adminSession = new DefaultCoreSession(new LdapPrincipal(adminDn, AuthenticationLevel.STRONG), this.directoryService);
        AddOperationContext addOperationContext = new AddOperationContext((CoreSession)adminSession, systemEntry);
        if (!this.system.hasEntry(new EntryOperationContext(adminSession, systemEntry.getDn()))) {
            this.system.add(addOperationContext);
        }
        if (this.partitions.containsKey(key = this.system.getSuffixDn().toString())) {
            throw new ConfigurationException("Duplicate partition suffix: " + key);
        }
        DnBranchNode<Partition> dnBranchNode = this.partitionLookupTree;
        synchronized (dnBranchNode) {
            this.partitions.put(key, this.system);
            this.partitionLookupTree.add(this.system.getSuffixDn(), this.system);
            EntryAttribute namingContexts = this.rootDSE.get("namingContexts");
            if (namingContexts == null) {
                namingContexts = new DefaultServerAttribute(this.registries.getAttributeTypeRegistry().lookup("namingContexts"), this.system.getUpSuffixDn().getUpName());
                this.rootDSE.put(namingContexts);
            } else {
                namingContexts.add(this.system.getUpSuffixDn().getUpName());
            }
        }
        return this.system;
    }

    @Override
    public boolean isInitialized() {
        return this.initialized;
    }

    @Override
    public synchronized void destroy() {
        if (!this.initialized) {
            return;
        }
        for (String suffix : new HashSet<String>(this.partitions.keySet())) {
            try {
                LdapDN adminDn = new LdapDN("0.9.2342.19200300.100.1.1=admin,2.5.4.11=system");
                adminDn.normalize(this.registries.getAttributeTypeRegistry().getNormalizerMapping());
                DefaultCoreSession adminSession = new DefaultCoreSession(new LdapPrincipal(adminDn, AuthenticationLevel.STRONG), this.directoryService);
                this.removeContextPartition(new RemoveContextPartitionOperationContext(adminSession, new LdapDN(suffix)));
            }
            catch (Exception e) {
                LOG.warn("Failed to destroy a partition: " + suffix, e);
            }
        }
        this.initialized = false;
    }

    @Override
    public void sync() throws Exception {
        MultiException error = null;
        for (Partition partition : this.partitions.values()) {
            try {
                partition.sync();
            }
            catch (Exception e) {
                LOG.warn("Failed to flush partition data out.", e);
                if (error == null) {
                    error = new MultiException("Grouping many exceptions on root nexus sync()");
                }
                error.addThrowable(e);
            }
        }
        if (error != null) {
            throw error;
        }
    }

    @Override
    public boolean compare(CompareOperationContext compareContext) throws Exception {
        Partition partition = this.getPartition(compareContext.getDn());
        AttributeTypeRegistry registry = this.registries.getAttributeTypeRegistry();
        if (!registry.hasAttributeType(compareContext.getOid())) {
            throw new LdapInvalidAttributeIdentifierException(compareContext.getOid() + " not found within the attributeType registry");
        }
        AttributeType attrType = registry.lookup(compareContext.getOid());
        EntryAttribute attr = partition.lookup(compareContext.newLookupContext(compareContext.getDn())).get(attrType.getName());
        if (attr == null) {
            throw new LdapNoSuchAttributeException();
        }
        if (attr.contains(compareContext.getValue())) {
            return true;
        }
        Normalizer normalizer = attrType.getEquality().getNormalizer();
        Value<?> reqVal = normalizer.normalize(compareContext.getValue());
        for (Value value : attr) {
            Value<?> attrValObj = normalizer.normalize(value);
            if (!attrValObj.equals(reqVal)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void addContextPartition(AddContextPartitionOperationContext opContext) throws Exception {
        Partition partition = opContext.getPartition();
        String key = partition.getSuffix();
        if (this.partitions.containsKey(key)) {
            throw new ConfigurationException("Duplicate partition suffix: " + key);
        }
        if (!partition.isInitialized()) {
            partition.init(this.directoryService);
        }
        DnBranchNode<Partition> dnBranchNode = this.partitionLookupTree;
        synchronized (dnBranchNode) {
            LdapDN partitionSuffix = partition.getSuffixDn();
            if (partitionSuffix == null) {
                throw new ConfigurationException("The current partition does not have any suffix: " + partition.getId());
            }
            this.partitions.put(partitionSuffix.toString(), partition);
            this.partitionLookupTree.add(partition.getSuffixDn(), partition);
            EntryAttribute namingContexts = this.rootDSE.get("namingContexts");
            LdapDN partitionUpSuffix = partition.getUpSuffixDn();
            if (partitionUpSuffix == null) {
                throw new ConfigurationException("The current partition does not have any user provided suffix: " + partition.getId());
            }
            if (namingContexts == null) {
                namingContexts = new DefaultServerAttribute(this.registries.getAttributeTypeRegistry().lookup("namingContexts"), partitionUpSuffix.getUpName());
                this.rootDSE.put(namingContexts);
            } else {
                namingContexts.add(partitionUpSuffix.getUpName());
            }
        }
    }

    @Override
    public synchronized void removeContextPartition(RemoveContextPartitionOperationContext removeContextPartition) throws Exception {
        String key = removeContextPartition.getDn().getNormName();
        Partition partition = this.partitions.get(key);
        if (partition == null) {
            String msg = "No partition with suffix: " + key;
            LOG.error(msg);
            throw new NameNotFoundException(msg);
        }
        String partitionSuffix = partition.getUpSuffixDn().getUpName();
        EntryAttribute namingContexts = this.rootDSE.get("namingContexts");
        if (namingContexts != null) {
            if (namingContexts.contains(partitionSuffix)) {
                namingContexts.remove(partitionSuffix);
            } else {
                String msg = "No partition with suffix '" + key + "' can be found in the NamingContexts";
                LOG.error(msg);
                throw new NameNotFoundException(msg);
            }
        }
        this.partitionLookupTree.remove(partition);
        this.partitions.remove(key);
        partition.destroy();
    }

    @Override
    public Partition getSystemPartition() {
        return this.system;
    }

    @Override
    public LdapContext getLdapContext() {
        throw new NotImplementedException();
    }

    @Override
    public LdapDN getMatchedName(GetMatchedNameOperationContext matchedNameContext) throws Exception {
        LdapDN dn = (LdapDN)matchedNameContext.getDn().clone();
        while (dn.size() > 0) {
            if (this.hasEntry(new EntryOperationContext(matchedNameContext.getSession(), dn))) {
                return dn;
            }
            dn.remove(dn.size() - 1);
        }
        return dn;
    }

    @Override
    public LdapDN getSuffixDn() {
        return LdapDN.EMPTY_LDAPDN;
    }

    @Override
    public LdapDN getUpSuffixDn() {
        return LdapDN.EMPTY_LDAPDN;
    }

    @Override
    public LdapDN getSuffix(GetSuffixOperationContext getSuffixContext) throws Exception {
        Partition backend = this.getPartition(getSuffixContext.getDn());
        return backend.getSuffixDn();
    }

    @Override
    public Set<String> listSuffixes(ListSuffixOperationContext emptyContext) throws Exception {
        return Collections.unmodifiableSet(this.partitions.keySet());
    }

    @Override
    public ClonedServerEntry getRootDSE(GetRootDSEOperationContext getRootDSEContext) {
        return new ClonedServerEntry(this.rootDSE);
    }

    private void unregister(Partition partition) throws Exception {
        EntryAttribute namingContexts = this.rootDSE.get("namingContexts");
        if (namingContexts != null) {
            namingContexts.remove(partition.getSuffixDn().getUpName());
        }
        this.partitions.remove(partition.getSuffixDn().toString());
    }

    @Override
    public void bind(BindOperationContext bindContext) throws Exception {
        Partition partition = this.getPartition(bindContext.getDn());
        partition.bind(bindContext);
    }

    @Override
    public void unbind(UnbindOperationContext unbindContext) throws Exception {
        Partition partition = this.getPartition(unbindContext.getDn());
        partition.unbind(unbindContext);
    }

    @Override
    public void delete(DeleteOperationContext deleteContext) throws Exception {
        Partition backend = this.getPartition(deleteContext.getDn());
        backend.delete(deleteContext);
    }

    @Override
    public void add(AddOperationContext addContext) throws Exception {
        Partition backend = this.getPartition(addContext.getDn());
        backend.add(addContext);
    }

    @Override
    public void modify(ModifyOperationContext modifyContext) throws Exception {
        if (modifyContext.getModItems().size() == 0) {
            return;
        }
        Partition backend = this.getPartition(modifyContext.getDn());
        backend.modify(modifyContext);
    }

    @Override
    public EntryFilteringCursor list(ListOperationContext opContext) throws Exception {
        Partition backend = this.getPartition(opContext.getDn());
        return backend.list(opContext);
    }

    @Override
    public EntryFilteringCursor search(SearchOperationContext opContext) throws Exception {
        LdapDN base = opContext.getDn();
        SearchControls searchCtls = opContext.getSearchControls();
        ExprNode filter = opContext.getFilter();
        if (base.size() == 0) {
            boolean isObjectScope = searchCtls.getSearchScope() == 0;
            boolean isSearchAll = false;
            if (filter instanceof PresenceNode) {
                isSearchAll = ((PresenceNode)filter).getAttribute().equals("2.5.4.0");
            }
            if (filter instanceof PresenceNode && isObjectScope && isSearchAll) {
                DefaultServerEntry serverEntry;
                String[] ids = searchCtls.getReturningAttributes();
                if (ids == null || ids.length == 0) {
                    ServerEntry rootDSE = this.getRootDSE(null).clone();
                    return new BaseEntryFilteringCursor(new SingletonCursor<ServerEntry>(rootDSE), opContext);
                }
                HashSet<String> realIds = new HashSet<String>();
                boolean containsAsterisk = false;
                boolean containsPlus = false;
                boolean containsOneDotOne = false;
                for (String id : ids) {
                    String idTrimmed = id.trim();
                    if (idTrimmed.equals("*")) {
                        containsAsterisk = true;
                        continue;
                    }
                    if (idTrimmed.equals("+")) {
                        containsPlus = true;
                        continue;
                    }
                    if (idTrimmed.equals("1.1")) {
                        containsOneDotOne = true;
                        continue;
                    }
                    try {
                        realIds.add(this.oidRegistry.getOid(idTrimmed));
                    }
                    catch (Exception e) {
                        realIds.add(idTrimmed);
                    }
                }
                if (containsOneDotOne) {
                    serverEntry = new DefaultServerEntry(this.registries, base);
                    return new BaseEntryFilteringCursor(new SingletonCursor<ServerEntry>(serverEntry), opContext);
                }
                if (containsAsterisk && containsPlus) {
                    ServerEntry rootDSE = this.getRootDSE(null).clone();
                    return new BaseEntryFilteringCursor(new SingletonCursor<ServerEntry>(rootDSE), opContext);
                }
                serverEntry = new DefaultServerEntry(this.registries, opContext.getDn());
                ClonedServerEntry rootDSE = this.getRootDSE(new GetRootDSEOperationContext(opContext.getSession()));
                for (EntryAttribute attribute : rootDSE) {
                    AttributeType type = this.atRegistry.lookup(attribute.getUpId());
                    if (realIds.contains(type.getOid())) {
                        serverEntry.put(attribute);
                        continue;
                    }
                    if (containsAsterisk && type.getUsage() == UsageEnum.USER_APPLICATIONS) {
                        serverEntry.put(attribute);
                        continue;
                    }
                    if (!containsPlus || type.getUsage() == UsageEnum.USER_APPLICATIONS) continue;
                    serverEntry.put(attribute);
                }
                return new BaseEntryFilteringCursor(new SingletonCursor<ServerEntry>(serverEntry), opContext);
            }
            throw new LdapNameNotFoundException();
        }
        Partition backend = this.getPartition(base);
        return backend.search(opContext);
    }

    @Override
    public ClonedServerEntry lookup(LookupOperationContext opContext) throws Exception {
        LdapDN dn = opContext.getDn();
        if (dn.size() == 0) {
            ClonedServerEntry retval = new ClonedServerEntry(this.rootDSE);
            Set<AttributeType> attributeTypes = this.rootDSE.getAttributeTypes();
            if (opContext.getAttrsId() != null && !opContext.getAttrsId().isEmpty()) {
                for (AttributeType attributeType : attributeTypes) {
                    String oid = attributeType.getOid();
                    if (opContext.getAttrsId().contains(oid)) continue;
                    retval.removeAttributes(attributeType);
                }
                return retval;
            }
            return new ClonedServerEntry(this.rootDSE);
        }
        Partition backend = this.getPartition(dn);
        return backend.lookup(opContext);
    }

    @Override
    public boolean hasEntry(EntryOperationContext opContext) throws Exception {
        LdapDN dn = opContext.getDn();
        if (IS_DEBUG) {
            LOG.debug("Check if DN '" + dn + "' exists.");
        }
        if (dn.size() == 0) {
            return true;
        }
        Partition backend = this.getPartition(dn);
        return backend.hasEntry(opContext);
    }

    @Override
    public void rename(RenameOperationContext opContext) throws Exception {
        Partition backend = this.getPartition(opContext.getDn());
        backend.rename(opContext);
    }

    @Override
    public void move(MoveOperationContext opContext) throws Exception {
        Partition backend = this.getPartition(opContext.getDn());
        backend.move(opContext);
    }

    @Override
    public void moveAndRename(MoveAndRenameOperationContext opContext) throws Exception {
        Partition backend = this.getPartition(opContext.getDn());
        backend.moveAndRename(opContext);
    }

    @Override
    public Partition getPartition(LdapDN dn) throws Exception {
        Partition parent = this.partitionLookupTree.getParentElement(dn);
        if (parent == null) {
            throw new LdapNameNotFoundException(" Cannot find a partition for " + dn);
        }
        return parent;
    }

    @Override
    public void registerSupportedExtensions(Set<String> extensionOids) throws Exception {
        EntryAttribute supportedExtension = this.rootDSE.get("supportedExtension");
        if (supportedExtension == null) {
            this.rootDSE.set("supportedExtension");
            supportedExtension = this.rootDSE.get("supportedExtension");
        }
        for (String extensionOid : extensionOids) {
            supportedExtension.add(extensionOid);
        }
    }

    @Override
    public void registerSupportedSaslMechanisms(Set<String> supportedSaslMechanisms) throws Exception {
        EntryAttribute supportedSaslMechanismsAttribute = this.rootDSE.get("supportedSASLMechanisms");
        if (supportedSaslMechanismsAttribute == null) {
            this.rootDSE.set("supportedSASLMechanisms");
            supportedSaslMechanismsAttribute = this.rootDSE.get("supportedSASLMechanisms");
        }
        for (String saslMechanism : supportedSaslMechanisms) {
            supportedSaslMechanismsAttribute.add(saslMechanism);
        }
    }

    @Override
    public ClonedServerEntry lookup(Long id) throws Exception {
        throw new NotImplementedException();
    }
}

