/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.functors;

import java.io.Serializable;
import java.util.Objects;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.collections4.Transformer;
import org.apache.commons.collections4.functors.NOPTransformer;

public class IfTransformer<I, O>
implements Transformer<I, O>,
Serializable {
    private static final long serialVersionUID = 8069309411242014252L;
    private final Predicate<? super I> iPredicate;
    private final Transformer<? super I, ? extends O> iTrueTransformer;
    private final Transformer<? super I, ? extends O> iFalseTransformer;

    public static <I, O> Transformer<I, O> ifTransformer(Predicate<? super I> predicate, Transformer<? super I, ? extends O> trueTransformer, Transformer<? super I, ? extends O> falseTransformer) {
        return new IfTransformer<I, O>(Objects.requireNonNull(predicate, "predicate"), Objects.requireNonNull(trueTransformer, "trueTransformer"), Objects.requireNonNull(falseTransformer, "falseTransformer"));
    }

    public static <T> Transformer<T, T> ifTransformer(Predicate<? super T> predicate, Transformer<? super T, ? extends T> trueTransformer) {
        return new IfTransformer<T, T>(Objects.requireNonNull(predicate, "predicate"), Objects.requireNonNull(trueTransformer, "trueTransformer"), NOPTransformer.nopTransformer());
    }

    public IfTransformer(Predicate<? super I> predicate, Transformer<? super I, ? extends O> trueTransformer, Transformer<? super I, ? extends O> falseTransformer) {
        this.iPredicate = predicate;
        this.iTrueTransformer = trueTransformer;
        this.iFalseTransformer = falseTransformer;
    }

    public Transformer<? super I, ? extends O> getFalseTransformer() {
        return this.iFalseTransformer;
    }

    public Predicate<? super I> getPredicate() {
        return this.iPredicate;
    }

    public Transformer<? super I, ? extends O> getTrueTransformer() {
        return this.iTrueTransformer;
    }

    @Override
    public O transform(I input) {
        if (this.iPredicate.evaluate(input)) {
            return this.iTrueTransformer.transform(input);
        }
        return this.iFalseTransformer.transform(input);
    }
}

