/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.bloomfilter;

import java.util.TreeMap;
import java.util.function.IntPredicate;
import org.apache.commons.collections4.bloomfilter.IndexExtractor;

@FunctionalInterface
public interface CellExtractor
extends IndexExtractor {
    public static CellExtractor from(final IndexExtractor indexExtractor) {
        return new CellExtractor(){
            TreeMap<CounterCell, CounterCell> counterCells = new TreeMap();

            @Override
            public int[] asIndexArray() {
                this.populate();
                return this.counterCells.keySet().stream().mapToInt(c -> c.idx).toArray();
            }

            @Override
            public boolean processCells(CellPredicate consumer) {
                this.populate();
                for (CounterCell cell : this.counterCells.values()) {
                    if (consumer.test(cell.idx, cell.count)) continue;
                    return false;
                }
                return true;
            }

            private void populate() {
                if (this.counterCells.isEmpty()) {
                    indexExtractor.processIndices(idx -> {
                        CounterCell cell = new CounterCell(idx, 1);
                        CounterCell counter = this.counterCells.get(cell);
                        if (counter == null) {
                            this.counterCells.put(cell, cell);
                        } else {
                            ++counter.count;
                        }
                        return true;
                    });
                }
            }

            final class CounterCell
            implements Comparable<CounterCell> {
                final int idx;
                int count;

                CounterCell(int idx, int count) {
                    this.idx = idx;
                    this.count = count;
                }

                @Override
                public int compareTo(CounterCell other) {
                    return Integer.compare(this.idx, other.idx);
                }
            }
        };
    }

    public boolean processCells(CellPredicate var1);

    @Override
    default public boolean processIndices(IntPredicate predicate) {
        return this.processCells((i, v) -> predicate.test(i));
    }

    @Override
    default public IndexExtractor uniqueIndices() {
        return this;
    }

    @FunctionalInterface
    public static interface CellPredicate {
        public boolean test(int var1, int var2);
    }
}

