/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.server.impl.browser;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.chemistry.opencmis.commons.data.ObjectData;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.chemistry.opencmis.commons.impl.JSONConverter;
import org.apache.chemistry.opencmis.commons.impl.TypeCache;
import org.apache.chemistry.opencmis.commons.server.CallContext;
import org.apache.chemistry.opencmis.commons.server.CmisService;
import org.apache.chemistry.opencmis.commons.spi.Holder;
import org.apache.chemistry.opencmis.server.impl.atompub.AtomPubUtils;
import org.apache.chemistry.opencmis.server.impl.browser.BrowserBindingUtils;
import org.apache.chemistry.opencmis.server.shared.HttpUtils;
import org.json.simple.JSONObject;
import org.json.simple.JSONStreamAware;

public class MultiFilingService {
    public static void addObjectToFolder(CallContext context, CmisService service, String repositoryId, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String objectId = (String)context.get("org.apache.chemistry.opencmis.browserbinding.objectId");
        String folderId = HttpUtils.getStringParameter(request, "folderId");
        Boolean allVersions = HttpUtils.getBooleanParameter(request, "allVersions");
        Holder objectIdHolder = new Holder((Object)objectId);
        service.addObjectToFolder(repositoryId, objectId, folderId, allVersions, null);
        String newObjectId = objectIdHolder.getValue() == null ? objectId : (String)objectIdHolder.getValue();
        ObjectData object = BrowserBindingUtils.getSimpleObject(service, repositoryId, newObjectId);
        if (object == null) {
            throw new CmisRuntimeException("Object is null!");
        }
        String location = AtomPubUtils.compileUrl(AtomPubUtils.compileBaseUrl(request, repositoryId), "content", newObjectId);
        response.setStatus(201);
        response.setHeader("Location", location);
        TypeCache typeCache = new TypeCache(repositoryId, service);
        JSONObject jsonObject = JSONConverter.convert((ObjectData)object, (TypeCache)typeCache);
        BrowserBindingUtils.writeJSON((JSONStreamAware)jsonObject, request, response);
    }

    public static void removeObjectFromFolder(CallContext context, CmisService service, String repositoryId, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String objectId = (String)context.get("org.apache.chemistry.opencmis.browserbinding.objectId");
        String folderId = HttpUtils.getStringParameter(request, "folderId");
        Holder objectIdHolder = new Holder((Object)objectId);
        service.removeObjectFromFolder(repositoryId, objectId, folderId, null);
        String newObjectId = objectIdHolder.getValue() == null ? objectId : (String)objectIdHolder.getValue();
        ObjectData object = BrowserBindingUtils.getSimpleObject(service, repositoryId, newObjectId);
        if (object == null) {
            throw new CmisRuntimeException("Object is null!");
        }
        String location = AtomPubUtils.compileUrl(AtomPubUtils.compileBaseUrl(request, repositoryId), "content", newObjectId);
        response.setStatus(201);
        response.setHeader("Location", location);
        TypeCache typeCache = new TypeCache(repositoryId, service);
        JSONObject jsonObject = JSONConverter.convert((ObjectData)object, (TypeCache)typeCache);
        BrowserBindingUtils.writeJSON((JSONStreamAware)jsonObject, request, response);
    }
}

