/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mail;

import java.util.Map;
import javax.activation.DataHandler;
import javax.mail.MessagingException;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.mail.MailBinding;
import org.apache.camel.component.mail.MailUtils;
import org.apache.camel.impl.DefaultMessage;
import org.apache.camel.util.ExchangeHelper;

public class MailMessage
extends DefaultMessage {
    private javax.mail.Message originalMailMessage;
    private javax.mail.Message mailMessage;

    public MailMessage() {
    }

    public MailMessage(javax.mail.Message message) {
        this.originalMailMessage = this.mailMessage = message;
    }

    public String toString() {
        if (this.mailMessage != null) {
            return "MailMessage: " + MailUtils.dumpMessage(this.mailMessage);
        }
        return "MailMessage: " + this.getBody();
    }

    public MailMessage copy() {
        MailMessage answer = (MailMessage)super.copy();
        answer.originalMailMessage = this.originalMailMessage;
        answer.mailMessage = this.mailMessage;
        return answer;
    }

    public javax.mail.Message getOriginalMessage() {
        return this.originalMailMessage;
    }

    public javax.mail.Message getMessage() {
        return this.mailMessage;
    }

    public void setMessage(javax.mail.Message mailMessage) {
        if (this.originalMailMessage == null) {
            this.originalMailMessage = mailMessage;
        }
        this.mailMessage = mailMessage;
    }

    public MailMessage newInstance() {
        return new MailMessage();
    }

    protected Object createBody() {
        if (this.mailMessage != null) {
            MailBinding binding = (MailBinding)ExchangeHelper.getBinding((Exchange)this.getExchange(), MailBinding.class);
            return binding != null ? binding.extractBodyFromMail(this.getExchange(), this) : null;
        }
        return null;
    }

    protected void populateInitialHeaders(Map<String, Object> map) {
        if (this.mailMessage != null) {
            try {
                MailBinding binding = (MailBinding)ExchangeHelper.getBinding((Exchange)this.getExchange(), MailBinding.class);
                if (binding != null) {
                    map.putAll(binding.extractHeadersFromMail(this.mailMessage, this.getExchange()));
                }
            }
            catch (MessagingException e) {
                throw new RuntimeCamelException("Error accessing headers due to: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    protected void populateInitialAttachments(Map<String, DataHandler> map) {
        if (this.mailMessage != null) {
            try {
                MailBinding binding = (MailBinding)ExchangeHelper.getBinding((Exchange)this.getExchange(), MailBinding.class);
                if (binding != null) {
                    binding.extractAttachmentsFromMail(this.mailMessage, map);
                }
            }
            catch (Exception e) {
                throw new RuntimeCamelException("Error populating the initial mail message attachments", (Throwable)e);
            }
        }
    }

    public void copyFrom(Message that) {
        super.copyFrom(that);
        if (that instanceof MailMessage) {
            MailMessage mailMessage = (MailMessage)that;
            this.originalMailMessage = mailMessage.originalMailMessage;
            this.mailMessage = mailMessage.mailMessage;
        }
    }
}

