/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.util;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Iterator;
import javax.xml.namespace.QName;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.addressing.RelatesTo;
import org.apache.axis2.client.Options;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ConfigurationContextFactory;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.ServiceContext;
import org.apache.axis2.context.ServiceGroupContext;
import org.apache.axis2.description.AxisModule;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.axis2.description.Flow;
import org.apache.axis2.description.HandlerDescription;
import org.apache.axis2.description.InOutAxisOperation;
import org.apache.axis2.description.OutInAxisOperation;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.PhaseRule;
import org.apache.axis2.description.TransportOutDescription;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.AxisError;
import org.apache.axis2.engine.Handler;
import org.apache.axis2.engine.MessageReceiver;
import org.apache.axis2.i18n.Messages;
import org.apache.axis2.receivers.RawXMLINOutMessageReceiver;
import org.apache.axis2.util.JavaUtils;
import org.apache.axis2.util.UUIDGenerator;

public class Utils {
    public static void addHandler(Flow flow, Handler handler, String phaseName) {
        HandlerDescription handlerDesc = new HandlerDescription();
        PhaseRule rule = new PhaseRule(phaseName);
        handlerDesc.setRules(rule);
        handler.init(handlerDesc);
        handlerDesc.setHandler(handler);
        flow.addHandler(handlerDesc);
    }

    public static MessageContext createOutMessageContext(MessageContext inMessageContext) throws AxisFault {
        MessageContext newmsgCtx = new MessageContext();
        newmsgCtx.setConfigurationContext(inMessageContext.getConfigurationContext());
        newmsgCtx.setSessionContext(inMessageContext.getSessionContext());
        newmsgCtx.setTransportIn(inMessageContext.getTransportIn());
        newmsgCtx.setTransportOut(inMessageContext.getTransportOut());
        Options oldOptions = inMessageContext.getOptions();
        newmsgCtx.setMessageID(UUIDGenerator.getUUID());
        newmsgCtx.setTo(oldOptions.getReplyTo());
        newmsgCtx.setProperty("WSAddressingVersion", inMessageContext.getProperty("WSAddressingVersion"));
        newmsgCtx.setProperty("disableAddressingForOutMessages", inMessageContext.getProperty("disableAddressingForOutMessages"));
        newmsgCtx.getConfigurationContext().getAxisConfiguration().getTargetResolverChain().resolveTarget(newmsgCtx);
        newmsgCtx.addRelatesTo(new RelatesTo(oldOptions.getMessageId()));
        AxisService axisService = inMessageContext.getAxisService();
        if (axisService != null && "soapsession".equals(axisService.getScope())) {
            newmsgCtx.setReplyTo(new EndpointReference("http://www.w3.org/2005/08/addressing/anonymous"));
            String serviceGroupContextId = inMessageContext.getServiceGroupContextId();
            if (serviceGroupContextId != null && !"".equals(serviceGroupContextId)) {
                EndpointReference replyToEPR = newmsgCtx.getReplyTo();
                replyToEPR.addReferenceParameter(new QName("http://ws.apache.org/namespaces/axis2", "ServiceGroupId", "axis2"), serviceGroupContextId);
            }
        } else {
            newmsgCtx.setReplyTo(new EndpointReference("http://www.w3.org/2005/08/addressing/none"));
        }
        AxisOperation ao = inMessageContext.getAxisOperation();
        if (ao.getOutputAction() != null) {
            newmsgCtx.setWSAAction(ao.getOutputAction());
        } else {
            newmsgCtx.setWSAAction(oldOptions.getAction());
        }
        newmsgCtx.setAxisMessage(ao.getMessage("Out"));
        newmsgCtx.setOperationContext(inMessageContext.getOperationContext());
        newmsgCtx.setServiceContext(inMessageContext.getServiceContext());
        newmsgCtx.setProperty("TRANSPORT_OUT", inMessageContext.getProperty("TRANSPORT_OUT"));
        newmsgCtx.setProperty("OutTransportInfo", inMessageContext.getProperty("OutTransportInfo"));
        newmsgCtx.setProperty("CHARACTER_SET_ENCODING", inMessageContext.getProperty("CHARACTER_SET_ENCODING"));
        newmsgCtx.setDoingREST(inMessageContext.isDoingREST());
        newmsgCtx.setDoingMTOM(inMessageContext.isDoingMTOM());
        newmsgCtx.setServerSide(inMessageContext.isServerSide());
        newmsgCtx.setServiceGroupContextId(inMessageContext.getServiceGroupContextId());
        TransportOutDescription transportOut = newmsgCtx.getTransportOut();
        try {
            EndpointReference responseEPR = newmsgCtx.getTo();
            if (newmsgCtx.isServerSide() && responseEPR != null && !responseEPR.hasAnonymousAddress() && !responseEPR.hasNoneAddress()) {
                URI uri = new URI(responseEPR.getAddress());
                String scheme = uri.getScheme();
                if (!transportOut.getName().getLocalPart().equals(scheme)) {
                    ConfigurationContext configurationContext = newmsgCtx.getConfigurationContext();
                    transportOut = configurationContext.getAxisConfiguration().getTransportOut(new QName(scheme));
                    if (transportOut == null) {
                        throw new AxisFault("Can not find the transport sender : " + scheme);
                    }
                    newmsgCtx.setTransportOut(transportOut);
                }
                inMessageContext.getOperationContext().setProperty("DIFFERENT_EPR", "true");
            }
        }
        catch (URISyntaxException e) {
            throw new AxisFault(e);
        }
        return newmsgCtx;
    }

    public static AxisService createSimpleService(QName serviceName, String className, QName opName) throws AxisFault {
        return Utils.createSimpleService(serviceName, new RawXMLINOutMessageReceiver(), className, opName);
    }

    public static AxisService createSimpleServiceforClient(QName serviceName, String className, QName opName) throws AxisFault {
        return Utils.createSimpleServiceforClient(serviceName, new RawXMLINOutMessageReceiver(), className, opName);
    }

    public static AxisService createSimpleService(QName serviceName, MessageReceiver messageReceiver, String className, QName opName) throws AxisFault {
        AxisService service = new AxisService(serviceName.getLocalPart());
        service.setClassLoader(Thread.currentThread().getContextClassLoader());
        service.addParameter(new Parameter("ServiceClass", className));
        InOutAxisOperation axisOp = new InOutAxisOperation(opName);
        axisOp.setMessageReceiver(messageReceiver);
        axisOp.setStyle("rpc");
        service.addOperation(axisOp);
        service.mapActionToOperation("http://ws.apache.org/namespaces/axis2/" + opName.getLocalPart(), axisOp);
        return service;
    }

    public static AxisService createSimpleServiceforClient(QName serviceName, MessageReceiver messageReceiver, String className, QName opName) throws AxisFault {
        AxisService service = new AxisService(serviceName.getLocalPart());
        service.setClassLoader(Thread.currentThread().getContextClassLoader());
        service.addParameter(new Parameter("ServiceClass", className));
        OutInAxisOperation axisOp = new OutInAxisOperation(opName);
        axisOp.setMessageReceiver(messageReceiver);
        axisOp.setStyle("rpc");
        service.addOperation(axisOp);
        return service;
    }

    public static ServiceContext fillContextInformation(AxisService axisService, ConfigurationContext configurationContext) {
        return Utils.fillServiceContextAndServiceGroupContext(axisService, configurationContext);
    }

    private static ServiceContext fillServiceContextAndServiceGroupContext(AxisService axisService, ConfigurationContext configurationContext) {
        String serviceGroupContextId = UUIDGenerator.getUUID();
        ServiceGroupContext serviceGroupContext = new ServiceGroupContext(configurationContext, (AxisServiceGroup)axisService.getParent());
        serviceGroupContext.setId(serviceGroupContextId);
        configurationContext.registerServiceGroupContext(serviceGroupContext);
        return new ServiceContext(axisService, serviceGroupContext);
    }

    public static String[] parseRequestURLForServiceAndOperation(String path, String servicePath) {
        if (path == null) {
            return null;
        }
        String[] values = new String[2];
        int index = path.lastIndexOf(servicePath);
        if (-1 != index) {
            int serviceStart = index + servicePath.length();
            if (path.length() > serviceStart + 1) {
                int operationIndex;
                String service = path.substring(serviceStart + 1);
                int queryIndex = service.indexOf(63);
                if (queryIndex > 0) {
                    service = service.substring(0, queryIndex);
                }
                if ((operationIndex = service.indexOf(47)) > 0) {
                    values[0] = service.substring(0, operationIndex);
                    values[1] = service.substring(operationIndex + 1);
                } else {
                    values[0] = service;
                }
            }
        }
        return values;
    }

    public static ConfigurationContext getNewConfigurationContext(String repositry) throws Exception {
        File file = new File(repositry);
        if (!file.exists()) {
            throw new Exception("repository directory " + file.getAbsolutePath() + " does not exists");
        }
        File axis2xml = new File(file, "axis.xml");
        String axis2xmlString = null;
        if (axis2xml.exists()) {
            axis2xmlString = axis2xml.getName();
        }
        return ConfigurationContextFactory.createConfigurationContextFromFileSystem(file.getAbsolutePath(), axis2xmlString);
    }

    public static String getParameterValue(Parameter param) {
        if (param == null) {
            return null;
        }
        return (String)param.getValue();
    }

    public static String getModuleName(String moduleName) {
        int version_seperator = 45;
        int version_index = moduleName.lastIndexOf(version_seperator);
        if (version_index > 0) {
            return moduleName.substring(0, version_index);
        }
        return moduleName;
    }

    public static String getModuleVersion(String moduleName) {
        int version_seperator = 45;
        int version_index = moduleName.lastIndexOf(version_seperator);
        if (version_index > 0) {
            return moduleName.substring(version_index + 1, moduleName.length());
        }
        return null;
    }

    public static QName getModuleName(String name, String versionID) {
        String moduleName = versionID != null && versionID.length() != 0 ? name + "-" + versionID : name;
        return new QName(moduleName);
    }

    public static boolean checkVersion(QName deployingModuleName, QName deployedModulename) throws AxisFault {
        String module1name = Utils.getModuleName(deployingModuleName.getLocalPart());
        String module2name = Utils.getModuleName(deployedModulename.getLocalPart());
        String module1version = Utils.getModuleVersion(deployingModuleName.getLocalPart());
        String module2version = Utils.getModuleVersion(deployedModulename.getLocalPart());
        if (module1name.equals(module2name)) {
            if (module1version != null) {
                if (!module1version.equals(module2version)) {
                    throw new AxisFault("trying to engage two different module versions " + module1version + " : " + module2version);
                }
                return false;
            }
            if (module2version == null) {
                return false;
            }
        }
        return true;
    }

    public static void calculateDefaultModuleVersion(HashMap modules, AxisConfiguration axisConfig) {
        Object moduleName;
        Iterator allModules = modules.values().iterator();
        HashMap<String, String> defaultModules = new HashMap<String, String>();
        while (allModules.hasNext()) {
            AxisModule axisModule = (AxisModule)allModules.next();
            moduleName = axisModule.getName();
            String moduleNameString = Utils.getModuleName(((QName)moduleName).getLocalPart());
            String moduleVersionString = Utils.getModuleVersion(((QName)moduleName).getLocalPart());
            String currentDefaultVerison = (String)defaultModules.get(moduleNameString);
            if (currentDefaultVerison != null) {
                if (moduleVersionString == null || !Utils.isLatest(moduleVersionString, currentDefaultVerison)) continue;
                defaultModules.put(moduleNameString, moduleVersionString);
                continue;
            }
            defaultModules.put(moduleNameString, moduleVersionString);
        }
        Iterator def_mod_itr = defaultModules.keySet().iterator();
        while (def_mod_itr.hasNext()) {
            moduleName = (String)def_mod_itr.next();
            axisConfig.addDefaultModuleVersion((String)moduleName, (String)defaultModules.get(moduleName));
        }
    }

    public static boolean isLatest(String moduleVersion, String currentDefaultVersion) {
        float m_c_vresion;
        if ("SNAPSHOT".equals(moduleVersion)) {
            return true;
        }
        float m_version = Float.parseFloat(moduleVersion);
        return m_version > (m_c_vresion = Float.parseFloat(currentDefaultVersion));
    }

    public static boolean isExplicitlyTrue(MessageContext messageContext, String propertyName) {
        Object flag = messageContext.getProperty(propertyName);
        return JavaUtils.isTrueExplicitly(flag);
    }

    public static int getAxisSpecifMEPConstant(String messageExchangePattern) {
        int mepConstant = -1;
        if ("http://www.w3.org/2004/08/wsdl/in-out".equals(messageExchangePattern) || "http://www.w3.org/2006/01/wsdl/in-out".equals(messageExchangePattern)) {
            mepConstant = 12;
        } else if ("http://www.w3.org/2004/08/wsdl/in-only".equals(messageExchangePattern) || "http://www.w3.org/2006/01/wsdl/in-only".equals(messageExchangePattern)) {
            mepConstant = 10;
        } else if ("http://www.w3.org/2004/08/wsdl/in-opt-out".equals(messageExchangePattern) || "http://www.w3.org/2006/01/wsdl/in-opt-out".equals(messageExchangePattern)) {
            mepConstant = 13;
        } else if ("http://www.w3.org/2004/08/wsdl/out-in".equals(messageExchangePattern) || "http://www.w3.org/2006/01/wsdl/out-in".equals(messageExchangePattern)) {
            mepConstant = 16;
        } else if ("http://www.w3.org/2004/08/wsdl/out-only".equals(messageExchangePattern) || "http://www.w3.org/2006/01/wsdl/out-only".equals(messageExchangePattern)) {
            mepConstant = 14;
        } else if ("http://www.w3.org/2004/08/wsdl/out-opt-in".equals(messageExchangePattern) || "http://www.w3.org/2006/01/wsdl/out-opt-in".equals(messageExchangePattern)) {
            mepConstant = 17;
        } else if ("http://www.w3.org/2004/08/wsdl/robust-in-only".equals(messageExchangePattern) || "http://www.w3.org/2006/01/wsdl/robust-in-only".equals(messageExchangePattern)) {
            mepConstant = 11;
        } else if ("http://www.w3.org/2004/08/wsdl/robust-out-only".equals(messageExchangePattern) || "http://www.w3.org/2006/01/wsdl/robust-out-only".equals(messageExchangePattern)) {
            mepConstant = 15;
        }
        if (mepConstant == -1) {
            throw new AxisError(Messages.getMessage("mepmappingerror"));
        }
        return mepConstant;
    }
}

