/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.engine;

import javax.xml.namespace.QName;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.HandlerDescription;
import org.apache.axis2.engine.AbstractDispatcher;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.util.Utils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RequestURIBasedDispatcher
extends AbstractDispatcher {
    public static final String NAME = "RequestURIBasedDispatcher";
    private static final Log log = LogFactory.getLog((Class)RequestURIBasedDispatcher.class);

    public AxisOperation findOperation(AxisService service, MessageContext messageContext) throws AxisFault {
        EndpointReference toEPR = messageContext.getTo();
        if (toEPR != null) {
            String filePart = toEPR.getAddress();
            String[] values = Utils.parseRequestURLForServiceAndOperation(filePart, messageContext.getConfigurationContext().getServiceContextPath());
            if (values.length >= 2 && values[1] != null) {
                QName operationName = new QName(values[1]);
                log.debug((Object)("Checking for Operation using QName(target endpoint URI fragment) : " + operationName));
                return service.getOperation(operationName);
            }
            log.debug((Object)"Attempted to check for Operation using target endpoint URI, but the operation fragment was missing");
            return null;
        }
        log.debug((Object)"Attempted to check for Operation using null target endpoint URI");
        return null;
    }

    public AxisService findService(MessageContext messageContext) throws AxisFault {
        EndpointReference toEPR = messageContext.getTo();
        if (toEPR != null) {
            log.debug((Object)("Checking for Service using target endpoint address : " + toEPR.getAddress()));
            String filePart = toEPR.getAddress();
            String[] values = Utils.parseRequestURLForServiceAndOperation(filePart, messageContext.getConfigurationContext().getServiceContextPath());
            if (values.length >= 1 && values[0] != null) {
                AxisConfiguration registry = messageContext.getConfigurationContext().getAxisConfiguration();
                return registry.getService(values[0]);
            }
            log.debug((Object)"Attempted to check for Service using target endpoint URI, but the service fragment was missing");
            return null;
        }
        log.debug((Object)"Attempted to check for Service using null target endpoint URI");
        return null;
    }

    public void initDispatcher() {
        this.init(new HandlerDescription(NAME));
    }
}

