/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.engine;

import java.util.ArrayList;
import java.util.List;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.engine.Phase;
import org.apache.axis2.i18n.Messages;

public class DispatchPhase
extends Phase {
    private static final long serialVersionUID = -6596799621473224363L;

    public DispatchPhase() {
    }

    public DispatchPhase(String phaseName) {
        super(phaseName);
    }

    public void checkPostConditions(MessageContext msgContext) throws AxisFault {
        EndpointReference toEPR = msgContext.getTo();
        if (msgContext.getAxisService() == null) {
            throw new AxisFault(Messages.getMessage("servicenotfoundforepr", toEPR != null ? toEPR.getAddress() : ""));
        }
        if (msgContext.getAxisOperation() == null) {
            throw new AxisFault(Messages.getMessage("operationnotfoundforepr", toEPR != null ? toEPR.getAddress() : "", msgContext.getWSAAction()));
        }
        this.validateTransport(msgContext);
        if (msgContext.getOperationContext() == null) {
            throw new AxisFault(Messages.getMessage("cannotBeNullOperationContext"));
        }
        if (msgContext.getServiceContext() == null) {
            throw new AxisFault(Messages.getMessage("cannotBeNullServiceContext"));
        }
        if (msgContext.getAxisOperation() == null && msgContext.getOperationContext() != null) {
            msgContext.setAxisOperation(msgContext.getOperationContext().getAxisOperation());
        }
        if (msgContext.getAxisService() == null && msgContext.getServiceContext() != null) {
            msgContext.setAxisService(msgContext.getServiceContext().getAxisService());
        }
        ArrayList operationChain = msgContext.getAxisOperation().getRemainingPhasesInFlow();
        msgContext.setExecutionChain((ArrayList)operationChain.clone());
    }

    private void validateTransport(MessageContext msgctx) throws AxisFault {
        AxisService service = msgctx.getAxisService();
        if (service.isEnableAllTransports()) {
            return;
        }
        List trs = service.getExposedTransports();
        String incommingTrs = msgctx.getIncomingTransportName();
        for (int i = 0; i < trs.size(); ++i) {
            String tr = (String)trs.get(i);
            if (incommingTrs == null || !incommingTrs.equals(tr)) continue;
            return;
        }
        EndpointReference toEPR = msgctx.getTo();
        throw new AxisFault(Messages.getMessage("servicenotfoundforepr", toEPR != null ? toEPR.getAddress() : ""));
    }
}

