/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.description;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.AxisFault;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.Flow;
import org.apache.axis2.description.FlowInclude;
import org.apache.axis2.description.FlowIncludeImpl;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.ParameterInclude;
import org.apache.axis2.description.ParameterIncludeImpl;
import org.apache.axis2.description.PolicyInclude;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.i18n.Messages;
import org.apache.axis2.modules.Module;

public class AxisModule
implements FlowInclude,
ParameterInclude {
    private final FlowInclude flowInclude = new FlowIncludeImpl();
    private final ParameterInclude parameters = new ParameterIncludeImpl();
    private Module module;
    private ClassLoader moduleClassLoader;
    private URL fileName;
    private QName name;
    private HashMap operations = new HashMap();
    private AxisConfiguration parent;
    private PolicyInclude policyInclude = null;
    private String moduleDescription;
    private String[] supportedPolicyNames;
    private QName[] localPolicyAssertions;

    public AxisModule() {
    }

    public AxisModule(QName name) {
        this();
        this.name = name;
    }

    public void addOperation(AxisOperation axisOperation) {
        this.operations.put(axisOperation.getName(), axisOperation);
    }

    public void addParameter(Parameter param) throws AxisFault {
        if (this.isParameterLocked(param.getName())) {
            throw new AxisFault(Messages.getMessage("paramterlockedbyparent", param.getName()));
        }
        this.parameters.addParameter(param);
    }

    public void removeParameter(Parameter param) throws AxisFault {
        if (this.isParameterLocked(param.getName())) {
            throw new AxisFault(Messages.getMessage("paramterlockedbyparent", param.getName()));
        }
        this.parameters.removeParameter(param);
    }

    public void deserializeParameters(OMElement parameterElement) throws AxisFault {
        this.parameters.deserializeParameters(parameterElement);
    }

    public Flow getFaultInFlow() {
        return this.flowInclude.getFaultInFlow();
    }

    public Flow getFaultOutFlow() {
        return this.flowInclude.getFaultOutFlow();
    }

    public Flow getInFlow() {
        return this.flowInclude.getInFlow();
    }

    public Module getModule() {
        return this.module;
    }

    public ClassLoader getModuleClassLoader() {
        return this.moduleClassLoader;
    }

    public QName getName() {
        return this.name;
    }

    public HashMap getOperations() {
        return this.operations;
    }

    public Flow getOutFlow() {
        return this.flowInclude.getOutFlow();
    }

    public Parameter getParameter(String name) {
        return this.parameters.getParameter(name);
    }

    public ArrayList getParameters() {
        return this.parameters.getParameters();
    }

    public AxisConfiguration getParent() {
        return this.parent;
    }

    public boolean isParameterLocked(String parameterName) {
        boolean loscked = false;
        if (this.parent != null) {
            loscked = this.parent.isParameterLocked(parameterName);
        }
        if (loscked) {
            return true;
        }
        Parameter parameter = this.getParameter(parameterName);
        return parameter != null && parameter.isLocked();
    }

    public void setFaultInFlow(Flow faultFlow) {
        this.flowInclude.setFaultInFlow(faultFlow);
    }

    public void setFaultOutFlow(Flow faultFlow) {
        this.flowInclude.setFaultOutFlow(faultFlow);
    }

    public void setInFlow(Flow inFlow) {
        this.flowInclude.setInFlow(inFlow);
    }

    public void setModule(Module module) {
        this.module = module;
    }

    public void setModuleClassLoader(ClassLoader moduleClassLoader) {
        this.moduleClassLoader = moduleClassLoader;
    }

    public void setName(QName name) {
        this.name = name;
    }

    public void setOutFlow(Flow outFlow) {
        this.flowInclude.setOutFlow(outFlow);
    }

    public void setParent(AxisConfiguration parent) {
        this.parent = parent;
    }

    public void setPolicyInclude(PolicyInclude policyInclude) {
        this.policyInclude = policyInclude;
    }

    public PolicyInclude getPolicyInclude() {
        if (this.policyInclude == null) {
            this.policyInclude = new PolicyInclude();
        }
        return this.policyInclude;
    }

    public String getModuleDescription() {
        return this.moduleDescription;
    }

    public void setModuleDescription(String moduleDescription) {
        this.moduleDescription = moduleDescription;
    }

    public String[] getSupportedPolicyNamespaces() {
        return this.supportedPolicyNames;
    }

    public void setSupportedPolicyNamespaces(String[] supportedPolicyNamespaces) {
        this.supportedPolicyNames = supportedPolicyNamespaces;
    }

    public QName[] getLocalPolicyAssertions() {
        return this.localPolicyAssertions;
    }

    public void setLocalPolicyAssertions(QName[] localPolicyAssertions) {
        this.localPolicyAssertions = localPolicyAssertions;
    }

    public URL getFileName() {
        return this.fileName;
    }

    public void setFileName(URL fileName) {
        this.fileName = fileName;
    }
}

