/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.context;

import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.AbstractContext;
import org.apache.axis2.context.ServiceContext;
import org.apache.axis2.context.ServiceGroupContext;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.DependencyManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SessionContext
extends AbstractContext {
    private transient HashMap serviceContextMap = new HashMap();
    private transient HashMap serviceGroupContextMap = new HashMap();
    private transient String cookieID;
    private static final Log log = LogFactory.getLog((Class)SessionContext.class);
    public transient long sessionContextTimeoutInterval = 30000L;

    public SessionContext(AbstractContext parent) {
        super(parent);
    }

    public void init(AxisConfiguration axisConfiguration) throws AxisFault {
    }

    public ServiceContext getServiceContext(AxisService axisService) {
        return (ServiceContext)this.serviceContextMap.get(axisService.getName());
    }

    public void addServiceContext(ServiceContext serviceContext) {
        this.serviceContextMap.put(serviceContext.getAxisService().getName(), serviceContext);
    }

    public void addServiceGroupContext(ServiceGroupContext serviceGroupContext, String serviceGroupID) {
        this.serviceGroupContextMap.put(serviceGroupID, serviceGroupContext);
    }

    public ServiceGroupContext getServiceGroupContext(String serviceGroupID) {
        return (ServiceGroupContext)this.serviceGroupContextMap.get(serviceGroupID);
    }

    public String getCookieID() {
        return this.cookieID;
    }

    public void setCookieID(String cookieID) {
        this.cookieID = cookieID;
    }

    public void touch() {
        this.lastTouchedTime = new Date().getTime();
        if (this.parent != null) {
            this.parent.touch();
        }
    }

    public long getLastTouchedTime() {
        return this.lastTouchedTime;
    }

    public Iterator getServiceGroupContext() {
        if (this.serviceGroupContextMap != null) {
            return this.serviceGroupContextMap.values().iterator();
        }
        return null;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.serviceGroupContextMap != null && !this.serviceGroupContextMap.isEmpty()) {
            Iterator valuse = this.serviceGroupContextMap.values().iterator();
            while (valuse.hasNext()) {
                ServiceGroupContext serviceGroupContext = (ServiceGroupContext)valuse.next();
                this.cleanupServiceContextes(serviceGroupContext);
            }
        }
    }

    private void cleanupServiceContextes(ServiceGroupContext serviceGroupContext) {
        Iterator serviceContecxtes = serviceGroupContext.getServiceContexts();
        while (serviceContecxtes.hasNext()) {
            ServiceContext serviceContext = (ServiceContext)serviceContecxtes.next();
            try {
                DependencyManager.destroyServiceObject(serviceContext);
            }
            catch (AxisFault axisFault) {
                log.info((Object)axisFault.getMessage());
            }
        }
    }
}

