/*
 * Decompiled with CFR 0.152.
 */
package org.andromda.repositories.emf;

import java.io.InputStream;
import java.net.URL;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.andromda.core.common.AndroMDALogger;
import org.andromda.core.common.ResourceUtils;
import org.andromda.repositories.emf.EMFRepositoryFacadeUtils;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.impl.ExtensibleURIConverterImpl;

public class EMFURIConverter
extends ExtensibleURIConverterImpl {
    private List<String> moduleSearchPaths;
    private Map<URI, URI> normalizedUris = new HashMap<URI, URI>();
    private static final Logger logger = Logger.getLogger(EMFURIConverter.class);

    public EMFURIConverter(List<String> moduleSearchPaths, Map<URI, URI> uriMap) {
        this.normalizedUris = uriMap;
        this.moduleSearchPaths = moduleSearchPaths;
        if (logger.isDebugEnabled()) {
            for (String path : moduleSearchPaths) {
                logger.debug((Object)("Model search path:" + path));
            }
        }
    }

    public EMFURIConverter(List<String> moduleSearchPaths) {
        this.moduleSearchPaths = moduleSearchPaths;
        if (logger.isDebugEnabled()) {
            for (String path : moduleSearchPaths) {
                logger.debug((Object)("Model search path:" + path));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URI normalize(URI uri) {
        URI normalizedUri = super.normalize(uri);
        if (normalizedUri.equals((Object)uri) && this.moduleSearchPaths != null) {
            if (!this.normalizedUris.containsKey(uri)) {
                String resourceName = uri.toString().replaceAll(".*(\\\\+|/)", "");
                for (String searchPath : this.moduleSearchPaths) {
                    String ms;
                    URI fileURI;
                    Date now1;
                    block14: {
                        now1 = new Date();
                        fileURI = EMFRepositoryFacadeUtils.createUri(ResourceUtils.normalizePath((String)searchPath));
                        long ms1 = new Date().getTime() - now1.getTime();
                        if (fileURI != null && fileURI.lastSegment() != null && fileURI.lastSegment().equals(resourceName)) {
                            String ms2 = ms1 > 100L ? ms1 + " ms" : "";
                            AndroMDALogger.info((Object)("referenced model --> '" + fileURI + "' " + ms2));
                            normalizedUri = fileURI;
                            this.normalizedUris.put(uri, normalizedUri);
                            break;
                        }
                        String completePath = ResourceUtils.normalizePath((String)(searchPath + '/' + resourceName));
                        try {
                            long ms2;
                            InputStream stream;
                            Date now = new Date();
                            URL url = ResourceUtils.toURL((String)completePath);
                            if (url == null) break block14;
                            try {
                                stream = url.openStream();
                                stream.close();
                                ms2 = new Date().getTime() - now.getTime();
                                String ms3 = ms2 > 100L ? ms2 + " ms" : "";
                                AndroMDALogger.info((Object)("referenced model --> '" + url + "' " + ms3));
                            }
                            catch (Exception exception) {
                                url = null;
                            }
                            finally {
                                stream = null;
                            }
                            if (url != null) {
                                ms2 = new Date().getTime() - now.getTime();
                                normalizedUri = EMFRepositoryFacadeUtils.createUri(url.toString());
                                this.normalizedUris.put(uri, normalizedUri);
                                if (!AndroMDALogger.isDebugEnabled()) break;
                                AndroMDALogger.debug((Object)("loaded model --> '" + url + "' " + ms2 + " ms"));
                                break;
                            }
                        }
                        catch (Exception exception) {
                            logger.debug((Object)"Caught exception in EMFURIConverter", (Throwable)exception);
                        }
                    }
                    long ms2 = new Date().getTime() - now1.getTime();
                    String string = ms = ms2 > 100L ? ms2 + " ms" : "";
                    if (!AndroMDALogger.isDebugEnabled()) continue;
                    AndroMDALogger.debug((Object)("loaded model --> '" + fileURI + "' " + ms));
                }
                if (!this.normalizedUris.containsKey(uri)) {
                    this.normalizedUris.put(uri, normalizedUri);
                }
            } else {
                normalizedUri = this.normalizedUris.get(uri);
            }
        }
        return normalizedUri;
    }
}

