/*
 * Decompiled with CFR 0.152.
 */
package org.andromda.maven.plugin;

import java.io.File;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.andromda.core.common.ResourceUtils;
import org.andromda.core.configuration.Configuration;
import org.andromda.core.configuration.Model;
import org.andromda.core.configuration.Repository;
import org.andromda.maven.plugin.AbstractAndroMDAMojo;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;

public class MagicDrawExportEMFXMIMojo
extends AbstractAndroMDAMojo {
    private final String MD_HOME = "MD_HOME";
    private String magicDrawHome;
    private boolean checkedMagicDraw = false;
    private String exportExt = "";
    private String exporterPath;

    @Override
    public void execute(Configuration configuration) throws MojoExecutionException {
        try {
            Repository[] repositories = configuration.getRepositories();
            if (repositories == null || repositories.length == 0) {
                this.getLog().info((CharSequence)"No repositories for export in configuration defined.");
                return;
            }
            for (Repository repository : repositories) {
                if (repository == null) continue;
                for (Model model : repository.getModels()) {
                    if (!"emf-uml2".equals(model.getType())) continue;
                    String[] uris = model.getUris();
                    for (int u = 0; u < uris.length; ++u) {
                        this.exportFile(uris[u]);
                    }
                }
            }
        }
        catch (Throwable throwable) {
            throw new MojoExecutionException("Error exporting MagicDraw project file to EMF XMI", throwable);
        }
    }

    private void exportFile(String dest) throws Exception {
        int length;
        String UML2EXT = ".uml2";
        String MDEXT1 = ".xml.zip";
        String MDEXT2 = ".mdzip";
        if (!dest.endsWith(".uml2")) {
            this.getLog().warn((CharSequence)("Ignoring model file " + dest + ", since it seems not to be of type 'uml2'"));
            return;
        }
        String source = StringUtils.replace((String)dest, (String)".uml2", (String)".xml.zip");
        URL sourceUrl = null;
        try {
            sourceUrl = new URL(ResourceUtils.normalizePath((String)source));
        }
        catch (MalformedURLException e) {
            throw new MojoExecutionException("Invalid source model file name [" + source + "]: " + e.getMessage());
        }
        File sourceFile = new File(sourceUrl.getFile());
        if (!sourceFile.exists()) {
            source = StringUtils.replace((String)dest, (String)".uml2", (String)".mdzip");
            try {
                sourceUrl = new URL(ResourceUtils.normalizePath((String)source));
            }
            catch (MalformedURLException e) {
                throw new MojoExecutionException("Invalid source model file name [" + source + "]: " + e.getMessage());
            }
        }
        if (!(sourceFile = new File(sourceUrl.getFile())).exists()) {
            throw new MojoExecutionException("Model file [" + source + "] does not exist");
        }
        URL destUrl = null;
        try {
            destUrl = new URL(ResourceUtils.normalizePath((String)dest));
        }
        catch (MalformedURLException e) {
            throw new MojoExecutionException("Invalid destination model file name [" + dest + "]: " + e.getMessage());
        }
        File destFile = new File(destUrl.getFile());
        if (!destFile.exists()) {
            this.getLog().debug((CharSequence)("No old model file [" + dest + "] existing"));
        } else {
            if (this.getLog().isDebugEnabled()) {
                SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                this.getLog().debug((CharSequence)("- MagicDraw model file [" + sourceFile.getName() + "] date = " + formatter.format((Object)new Date(sourceFile.lastModified()))));
                this.getLog().debug((CharSequence)("- EMF model file [" + destFile.getName() + "] date = " + formatter.format((Object)new Date(destFile.lastModified()))));
            }
            if (destFile.lastModified() >= sourceFile.lastModified()) {
                this.getLog().info((CharSequence)("Model file [" + dest + "] is up-to-date"));
                return;
            }
        }
        this.checkForMagicDraw();
        this.getLog().info((CharSequence)("Exporting model file [" + source + "] ..."));
        String command = '\"' + this.exporterPath + '\"' + " project_file=\"" + sourceFile.getPath() + '\"' + " destination_dir=\"" + sourceFile.getParent() + '\"' + " load_all_modules=true";
        Process process = Runtime.getRuntime().exec(command);
        InputStream is = process.getInputStream();
        byte[] buf = new byte[128];
        while ((length = is.read(buf)) > 0) {
            this.getLog().info((CharSequence)new String(buf, 0, length));
        }
        process.waitFor();
        process.destroy();
        int err = process.exitValue();
        if (err != 0) {
            throw new MojoExecutionException("MagicDraw export returned error code " + err);
        }
        this.getLog().info((CharSequence)"Successfully exported model file.");
    }

    private void checkForMagicDraw() throws MojoExecutionException {
        if (!this.checkedMagicDraw) {
            if (this.magicDrawHome == null) {
                this.magicDrawHome = System.getenv("MD_HOME");
            }
            if (this.magicDrawHome == null) {
                throw new MojoExecutionException("MagicDraw home directory not defined: please define either a configuration variable \"magicDrawHome\" in your pom or the environment variable \"MD_HOME\"!");
            }
            File home = new File(this.magicDrawHome);
            if (!home.exists()) {
                throw new MojoExecutionException("Invalid MagicDraw home directory specified: " + this.magicDrawHome);
            }
            String os = System.getProperty("os.name");
            if (os.contains("Windows")) {
                this.exportExt = ".exe";
            }
            String pluginName115 = "com.nomagic.magicdraw.emfuml2export";
            String pluginName116 = "com.nomagic.magicdraw.emfuml2xmi";
            String pluginName15 = "com.nomagic.magicdraw.emfuml2xmi_v1";
            this.exporterPath = this.magicDrawHome + File.separator + "plugins" + File.separator + pluginName15 + File.separator + "exportEMFXMI" + this.exportExt;
            File exporter = new File(this.exporterPath);
            if (!exporter.exists()) {
                this.exporterPath = this.magicDrawHome + File.separator + "plugins" + File.separator + pluginName116 + File.separator + "exportEMFXMI" + this.exportExt;
                exporter = new File(this.exporterPath);
                if (!exporter.exists()) {
                    this.exporterPath = this.magicDrawHome + File.separator + "plugins" + File.separator + pluginName115 + File.separator + "exportEMFXMI" + this.exportExt;
                }
            }
            if (!(exporter = new File(this.exporterPath)).exists()) {
                throw new MojoExecutionException("No exporter plugin found in MagicDraw home directory " + this.magicDrawHome);
            }
            this.checkedMagicDraw = true;
        }
    }
}

