/*
 * Decompiled with CFR 0.152.
 */
package org.andromda.maven.plugin;

import java.io.File;
import java.net.URL;
import org.andromda.core.AndroMDA;
import org.andromda.core.common.ResourceUtils;
import org.andromda.core.configuration.Configuration;
import org.andromda.core.configuration.Model;
import org.andromda.core.configuration.Repository;
import org.andromda.maven.plugin.AbstractAndroMDAMojo;
import org.apache.maven.plugin.MojoExecutionException;

public class AndroMDAMojo
extends AbstractAndroMDAMojo {
    private boolean lastModifiedCheck = false;
    private boolean skipProcessing = false;
    private File buildSourceDirectory;
    private File modelOutputHistory;

    public void setLastModifiedCheck(boolean lastModifiedCheck) {
        this.lastModifiedCheck = lastModifiedCheck;
    }

    public void setBuildSourceDirectory(File buildSourceDirectory) {
        this.buildSourceDirectory = buildSourceDirectory;
    }

    public void setModelOutputHistory(File modelOutputHistory) {
        this.modelOutputHistory = modelOutputHistory;
    }

    @Override
    public void execute(Configuration configuration) throws MojoExecutionException {
        if (!this.skipProcessing) {
            boolean execute = true;
            if (this.lastModifiedCheck) {
                long date = this.getLastModelConfigDate(configuration);
                execute = ResourceUtils.modifiedAfter((long)date, (File)this.buildSourceDirectory);
            }
            if (execute) {
                AndroMDA andromda = AndroMDA.newInstance();
                String historyPath = this.modelOutputHistory != null ? this.modelOutputHistory.getAbsolutePath() : null;
                andromda.run(configuration, this.lastModifiedCheck, historyPath);
                andromda.shutdown();
            } else {
                this.getLog().info((CharSequence)"Files are up-to-date, skipping AndroMDA execution");
            }
        }
        if (this.buildSourceDirectory != null) {
            this.getProject().addCompileSourceRoot(this.buildSourceDirectory.getPath());
        }
    }

    private long getLastModelConfigDate(Configuration configuration) {
        URL configurationUri = ResourceUtils.toURL((String)this.configurationUri);
        long date = ResourceUtils.getLastModifiedTime((URL)configurationUri);
        for (Repository repository : configuration.getRepositories()) {
            if (repository == null) continue;
            for (Model model : repository.getModels()) {
                long newDate = model.getLastModified();
                if (newDate <= date) continue;
                date = newDate;
            }
        }
        return date;
    }
}

