/*
 * Decompiled with CFR 0.152.
 */
package org.andromda.maven.plugin;

import java.io.FileNotFoundException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.andromda.core.common.AndroMDALogger;
import org.andromda.core.common.ExceptionUtils;
import org.andromda.core.common.ResourceUtils;
import org.andromda.core.configuration.Configuration;
import org.andromda.maven.plugin.configuration.AbstractConfigurationMojo;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Settings;

public abstract class AbstractAndroMDAMojo
extends AbstractConfigurationMojo {
    protected String configurationUri;
    protected boolean allowMultipleRuns;
    protected MavenProject project;
    protected List<String> propertyFiles;
    protected Settings settings;
    protected ArtifactFactory factory;
    protected List<Plugin> plugins;
    protected ArtifactRepository localRepository;
    private static List<String> configurations = new ArrayList<String>();

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.allowMultipleRuns || !configurations.contains(this.configurationUri)) {
            try {
                if (!this.allowMultipleRuns) {
                    configurations.add(this.configurationUri);
                }
                AndroMDALogger.initialize();
                URL configurationUri = ResourceUtils.toURL((String)this.configurationUri);
                if (configurationUri == null) {
                    throw new MojoExecutionException("Configuration could not be loaded from '" + this.configurationUri + '\'');
                }
                this.addPluginDependencies("andromda-maven-plugin", "runtime");
                this.initializeClasspathFromClassPathElements(this.project.getRuntimeClasspathElements());
                Configuration configuration = this.getConfiguration(configurationUri);
                this.execute(configuration);
            }
            catch (Throwable throwable) {
                String message = "Error running AndroMDA";
                throwable = ExceptionUtils.getRootCause((Throwable)throwable);
                if (throwable instanceof MalformedURLException || throwable instanceof FileNotFoundException) {
                    message = "Configuration is not valid '" + this.configurationUri + '\'';
                }
                throw new MojoExecutionException(message, throwable);
            }
        }
    }

    protected abstract void execute(Configuration var1) throws Exception;

    public void setConfigurationUri(String configurationUri) {
        this.configurationUri = configurationUri;
    }

    public void setProject(MavenProject project) {
        this.project = project;
    }

    public void setSettings(Settings settings) {
        this.settings = settings;
    }

    public void setPropertyFiles(List<String> propertyFiles) {
        this.propertyFiles = propertyFiles;
    }

    protected MavenProject getProject() {
        return this.project;
    }

    protected List<String> getPropertyFiles() {
        return this.propertyFiles;
    }

    protected Settings getSettings() {
        return this.settings;
    }

    protected ArtifactFactory getFactory() {
        return this.factory;
    }

    protected List<Plugin> getPlugins() {
        return this.plugins;
    }

    protected ArtifactRepository getLocalRepository() {
        return this.localRepository;
    }
}

