/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.test.cluster;

import java.io.StringWriter;
import org.alfresco.jlan.client.DiskSession;
import org.alfresco.jlan.debug.Debug;
import org.alfresco.jlan.smb.SMBException;
import org.alfresco.jlan.test.cluster.BooleanTestResult;
import org.alfresco.jlan.test.cluster.ExceptionTestResult;
import org.alfresco.jlan.test.cluster.Test;
import org.alfresco.jlan.test.cluster.TestResult;

public class CreateFolderTest
extends Test {
    public CreateFolderTest() {
        super("CreateFolder");
    }

    @Override
    public TestResult runTest(int threadId, int iteration, DiskSession sess, StringWriter log) {
        TestResult result = null;
        try {
            String testFolderName = this.getPerTestFolderName(threadId, iteration);
            this.testLog(log, "CreateFolder Test");
            if (sess.FileExists(testFolderName)) {
                this.testLog(log, "Folder " + testFolderName + " exists");
                result = new BooleanTestResult(true);
            } else {
                this.testLog(log, "Creating folder " + testFolderName + " via " + sess.getServer());
                try {
                    sess.CreateDirectory(testFolderName);
                    if (sess.FileExists(testFolderName)) {
                        this.testLog(log, "Re-check, folder now exists, " + testFolderName);
                        result = new BooleanTestResult(true);
                    } else {
                        this.testLog(log, "** Folder does not exist after create, " + testFolderName);
                        result = new BooleanTestResult(false, "Folder does not exist after create, " + testFolderName);
                    }
                }
                catch (SMBException ex) {
                    if (ex.getErrorClass() == 6 && ex.getErrorCode() == -1073741771) {
                        this.testLog(log, "Create failed with object name collision (expected), " + testFolderName);
                        result = new BooleanTestResult(true);
                    }
                    result = new ExceptionTestResult(ex);
                }
            }
            this.testLog(log, "Test completed");
        }
        catch (Exception ex) {
            Debug.println(ex);
            result = new ExceptionTestResult(ex);
        }
        return result;
    }

    @Override
    public void cleanupTest(int threadId, int iter, DiskSession sess, StringWriter log) throws Exception {
        if (threadId == 1) {
            String fName = this.getPerTestFolderName(threadId, iter);
            this.testLog(log, "Cleanup test folder " + fName);
            sess.DeleteDirectory(fName);
        }
    }
}

