/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.smb.server.nio.win32;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import org.alfresco.jlan.debug.Debug;
import org.alfresco.jlan.netbios.NetBIOSName;
import org.alfresco.jlan.netbios.win32.NetBIOSSelectionKey;
import org.alfresco.jlan.netbios.win32.NetBIOSSelector;
import org.alfresco.jlan.netbios.win32.NetBIOSSocket;
import org.alfresco.jlan.server.SessionHandlerList;
import org.alfresco.jlan.server.config.InvalidConfigurationException;
import org.alfresco.jlan.smb.server.CIFSConfigSection;
import org.alfresco.jlan.smb.server.CifsConnectionsHandler;
import org.alfresco.jlan.smb.server.PacketHandler;
import org.alfresco.jlan.smb.server.SMBServer;
import org.alfresco.jlan.smb.server.SMBSrvSession;
import org.alfresco.jlan.smb.server.nio.RequestHandler;
import org.alfresco.jlan.smb.server.nio.RequestHandlerListener;
import org.alfresco.jlan.smb.server.nio.win32.AsyncWinsockCIFSRequestHandler;
import org.alfresco.jlan.smb.server.nio.win32.AsyncWinsockNetBIOSSessionHandler;

public class AsyncWinsockCifsConnectionsHandler
implements CifsConnectionsHandler,
RequestHandlerListener,
Runnable {
    public static final int SessionSocketsPerHandler = 64;
    private NetBIOSName m_srvNbName;
    private NetBIOSName m_wksNbName;
    private int m_srvLANA;
    private SessionHandlerList m_handlerList = new SessionHandlerList();
    private NetBIOSSelector m_nbSelector;
    private Vector<AsyncWinsockCIFSRequestHandler> m_requestHandlers;
    private SMBServer m_server;
    private Thread m_thread;
    private boolean m_shutdown;
    private int m_sessId;
    private int m_clientSocketTimeout;
    private IdleSessionReaper m_idleSessReaper;
    private boolean m_debug;

    public final boolean hasDebug() {
        return this.m_debug;
    }

    @Override
    public int numberOfSessionHandlers() {
        return this.m_handlerList.numberOfHandlers();
    }

    @Override
    public final void initializeHandler(SMBServer srv, CIFSConfigSection config) throws InvalidConfigurationException {
        this.m_server = srv;
        if ((config.getSessionDebugFlags() & 0x400000) != 0) {
            this.m_debug = true;
        }
        if (config.hasWin32NetBIOS()) {
            String srvName = null;
            srvName = srv.getCIFSConfiguration().getWin32ServerName() != null ? srv.getCIFSConfiguration().getWin32ServerName() : srv.getCIFSConfiguration().getServerName();
            this.m_srvNbName = new NetBIOSName(srvName, ' ', false);
            this.m_wksNbName = new NetBIOSName(srvName, '\u0000', false);
            try {
                int lana = srv.getCIFSConfiguration().getWin32LANA();
                AsyncWinsockNetBIOSSessionHandler sessHandler = new AsyncWinsockNetBIOSSessionHandler(lana, this.m_srvNbName, srv);
                sessHandler.initializeSessionHandler(this.m_server);
                this.m_handlerList.addHandler(sessHandler);
                this.m_srvLANA = sessHandler.getLANA();
                sessHandler = new AsyncWinsockNetBIOSSessionHandler(lana, this.m_wksNbName, srv);
                sessHandler.initializeSessionHandler(this.m_server);
                this.m_handlerList.addHandler(sessHandler);
            }
            catch (IOException ex) {
                if (this.hasDebug()) {
                    Debug.println("[SMB] Error initializing session handler, " + ex.getMessage());
                }
                throw new InvalidConfigurationException(ex.getMessage());
            }
        }
        if (this.m_handlerList.numberOfHandlers() == 0) {
            throw new InvalidConfigurationException("No CIFS session handlers enabled");
        }
        this.m_clientSocketTimeout = config.getSocketTimeout();
        this.m_requestHandlers = new Vector();
        AsyncWinsockCIFSRequestHandler reqHandler = new AsyncWinsockCIFSRequestHandler(this.m_srvNbName, this.m_srvLANA, this.m_server.getThreadPool(), 64, this.m_clientSocketTimeout);
        reqHandler.setListener(this);
        reqHandler.setDebug(this.hasDebug());
        this.m_requestHandlers.add(reqHandler);
    }

    @Override
    public final void startHandler() {
        this.m_thread = new Thread(this);
        this.m_thread.setName("WinsockCIFSConnectionsHandler");
        this.m_thread.setDaemon(false);
        this.m_thread.start();
        if (this.m_clientSocketTimeout > 0) {
            this.m_idleSessReaper = new IdleSessionReaper(this.m_clientSocketTimeout / 2);
        }
    }

    @Override
    public final void stopHandler() {
        if (this.m_thread != null) {
            AsyncWinsockNetBIOSSessionHandler sessHandler;
            NetBIOSSocket srvSock;
            this.m_shutdown = true;
            if (this.m_idleSessReaper != null) {
                this.m_idleSessReaper.shutdownRequest();
            }
            if (this.m_handlerList.numberOfHandlers() > 0 && (srvSock = (sessHandler = (AsyncWinsockNetBIOSSessionHandler)this.m_handlerList.getHandlerAt(0)).getSocket()) != null) {
                try {
                    srvSock.closeSocket();
                }
                catch (Exception ex) {
                    Debug.println(ex);
                }
            }
        }
    }

    @Override
    public void run() {
        block21: {
            int idx;
            this.m_shutdown = false;
            try {
                this.m_nbSelector = new NetBIOSSelector();
                for (idx = 0; idx < this.m_handlerList.numberOfHandlers(); ++idx) {
                    AsyncWinsockNetBIOSSessionHandler curHandler = (AsyncWinsockNetBIOSSessionHandler)this.m_handlerList.getHandlerAt(idx);
                    NetBIOSSocket srvSocket = curHandler.getSocket();
                    srvSocket.configureBlocking(false);
                    srvSocket.register(this.m_nbSelector, 1, curHandler);
                    if (!this.hasDebug()) continue;
                    Debug.println("[SMB] Listening for connections on " + curHandler);
                }
            }
            catch (IOException ex) {
                if (this.hasDebug()) {
                    Debug.println("[SMB] Error opening/registering Selector");
                    Debug.println(ex);
                }
                this.m_shutdown = true;
            }
            while (!this.m_shutdown) {
                int connCnt;
                block19: {
                    if (this.hasDebug()) {
                        Debug.println("[SMB] Waiting for new connection ...");
                    }
                    connCnt = 0;
                    try {
                        connCnt = this.m_nbSelector.select();
                    }
                    catch (IOException ex) {
                        if (!this.hasDebug()) break block19;
                        Debug.println("[SMB] Error waiting for connection");
                        Debug.println(ex);
                    }
                }
                if (connCnt == 0) continue;
                Iterator<NetBIOSSelectionKey> keysIter = this.m_nbSelector.selectedKeys().iterator();
                while (keysIter.hasNext()) {
                    block20: {
                        NetBIOSSelectionKey selKey = keysIter.next();
                        if (selKey.isAcceptable()) {
                            try {
                                AsyncWinsockNetBIOSSessionHandler channelHandler = (AsyncWinsockNetBIOSSessionHandler)selKey.attachment();
                                NetBIOSSocket clientSock = channelHandler.getSocket().accept();
                                if (channelHandler.getNetBIOSName().getType() == ' ') {
                                    PacketHandler pktHandler = channelHandler.createPacketHandler(clientSock);
                                    SMBSrvSession sess = SMBSrvSession.createSession(pktHandler, this.m_server, ++this.m_sessId);
                                    if (this.hasDebug()) {
                                        Debug.println("[SMB] Connection from " + clientSock.getName() + ", handler=" + channelHandler + ", sess=" + sess.getUniqueId());
                                    }
                                    this.queueSessionToHandler(sess);
                                }
                            }
                            catch (IOException ex) {
                                if (!this.hasDebug()) break block20;
                                Debug.println("[SMB] Failed to accept connection");
                                Debug.println(ex);
                            }
                        }
                    }
                    keysIter.remove();
                }
            }
            for (idx = 0; idx < this.m_handlerList.numberOfHandlers(); ++idx) {
                AsyncWinsockNetBIOSSessionHandler sessHandler = (AsyncWinsockNetBIOSSessionHandler)this.m_handlerList.getHandlerAt(idx);
                sessHandler.closeSessionHandler(null);
                if (!this.hasDebug()) continue;
                Debug.println("[SMB] Closed session handler " + sessHandler);
            }
            while (this.m_requestHandlers.size() > 0) {
                AsyncWinsockCIFSRequestHandler reqHandler = this.m_requestHandlers.remove(0);
                reqHandler.closeHandler();
                if (!this.hasDebug()) continue;
                Debug.println("[SMB] Closed request handler, " + reqHandler.getName());
            }
            if (this.m_nbSelector != null) {
                try {
                    this.m_nbSelector.close();
                }
                catch (Exception ex) {
                    if (!this.hasDebug()) break block21;
                    Debug.println("[SMB] Error closing socket selector, " + ex.getMessage());
                }
            }
        }
        this.m_thread = null;
    }

    private final void queueSessionToHandler(SMBSrvSession sess) {
        AsyncWinsockCIFSRequestHandler reqHandler = this.m_requestHandlers.firstElement();
        if (reqHandler == null || !reqHandler.hasFreeSessionSlot()) {
            reqHandler = new AsyncWinsockCIFSRequestHandler(this.m_srvNbName, this.m_srvLANA, this.m_server.getThreadPool(), 64, this.m_clientSocketTimeout);
            reqHandler.setListener(this);
            reqHandler.setDebug(this.hasDebug());
            this.m_requestHandlers.add(0, reqHandler);
            if (this.hasDebug()) {
                Debug.println("[SMB] Added new CIFS request handler, " + reqHandler);
            }
        }
        reqHandler.queueSessionToHandler(sess);
    }

    public final void setDebug(boolean ena) {
        this.m_debug = ena;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void requestHandlerEmpty(RequestHandler reqHandler) {
        SessionHandlerList sessionHandlerList = this.m_handlerList;
        synchronized (sessionHandlerList) {
            if (!this.m_requestHandlers.get(0).getName().equals(reqHandler.getName())) {
                this.m_requestHandlers.remove(reqHandler);
                reqHandler.closeHandler();
                if (this.hasDebug()) {
                    Debug.println("[SMB] Removed empty request handler, " + reqHandler.getName());
                }
            }
        }
    }

    protected class IdleSessionReaper
    implements Runnable {
        private long m_wakeup;
        private Thread m_reaperThread;
        private boolean m_shutdown = false;

        public IdleSessionReaper(long intvl) {
            this.m_wakeup = intvl;
            this.m_reaperThread = new Thread(this);
            this.m_reaperThread.setDaemon(true);
            this.m_reaperThread.setName("CIFS_IdleSessionReaper_Winsock");
            this.m_reaperThread.start();
        }

        public final void shutdownRequest() {
            this.m_shutdown = true;
            this.m_reaperThread.interrupt();
        }

        @Override
        public void run() {
            while (!this.m_shutdown) {
                try {
                    Thread.sleep(this.m_wakeup);
                }
                catch (InterruptedException ex) {
                    // empty catch block
                }
                if (this.m_shutdown) break;
                Enumeration enumHandlers = AsyncWinsockCifsConnectionsHandler.this.m_requestHandlers.elements();
                while (enumHandlers.hasMoreElements()) {
                    int idleCnt;
                    AsyncWinsockCIFSRequestHandler curHandler = (AsyncWinsockCIFSRequestHandler)enumHandlers.nextElement();
                    if (curHandler == null || (idleCnt = curHandler.checkForIdleSessions()) <= 0 || !AsyncWinsockCifsConnectionsHandler.this.hasDebug()) continue;
                    Debug.println("[SMB] Idle session check, removed " + idleCnt + " sessions for " + curHandler.getName());
                }
            }
        }
    }
}

