/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.smb.dcerpc.server;

import java.io.IOException;
import org.alfresco.jlan.server.filesys.NetworkFile;
import org.alfresco.jlan.smb.dcerpc.DCEBuffer;
import org.alfresco.jlan.smb.dcerpc.DCEPipeType;
import org.alfresco.jlan.smb.dcerpc.server.DCEHandler;
import org.alfresco.jlan.smb.dcerpc.server.DCEPipeHandler;

public class DCEPipeFile
extends NetworkFile {
    private int m_maxRxFragSize;
    private int m_maxTxFragSize;
    private int m_state;
    private DCEHandler m_handler;
    private DCEBuffer m_dceData;

    public DCEPipeFile(int id) {
        super(id);
        this.setName(DCEPipeType.getTypeAsString(id));
        this.setRequestHandler(DCEPipeHandler.getHandlerForType(id));
    }

    public final int getMaxReceiveFragmentSize() {
        return this.m_maxRxFragSize;
    }

    public final int getMaxTransmitFragmentSize() {
        return this.m_maxTxFragSize;
    }

    public final int getPipeState() {
        return this.m_state;
    }

    public final int getPipeId() {
        return this.getFileId();
    }

    public final boolean hasRequestHandler() {
        return this.m_handler != null;
    }

    public final DCEHandler getRequestHandler() {
        return this.m_handler;
    }

    public final boolean hasBufferedData() {
        return this.m_dceData != null;
    }

    public final DCEBuffer getBufferedData() {
        return this.m_dceData;
    }

    public final void setBufferedData(DCEBuffer buf) {
        this.m_dceData = buf;
    }

    public final void setMaxReceiveFragmentSize(int siz) {
        this.m_maxRxFragSize = siz;
    }

    public final void setMaxTransmitFragmentSize(int siz) {
        this.m_maxTxFragSize = siz;
    }

    public final void setPipeState(int state) {
        this.m_state = state;
    }

    public final void setRequestHandler(DCEHandler handler) {
        this.m_handler = handler;
    }

    public final void DumpFile() {
        System.out.println("** DCE/RPC Named Pipe: " + this.getName());
        System.out.println("  File ID : " + this.getFileId());
        System.out.println("  State   : 0x" + Integer.toHexString(this.getPipeState()));
        System.out.println("  Max Rx  : " + this.getMaxReceiveFragmentSize());
        System.out.println("  Max Tx  : " + this.getMaxTransmitFragmentSize());
        System.out.println("  Handler : " + this.getRequestHandler());
    }

    @Override
    public void closeFile() throws IOException {
    }

    @Override
    public void openFile(boolean createFlag) throws IOException {
    }

    @Override
    public int readFile(byte[] buf, int len, int pos, long fileOff) throws IOException {
        return 0;
    }

    @Override
    public void flushFile() throws IOException {
    }

    @Override
    public long seekFile(long pos, int typ) throws IOException {
        return 0L;
    }

    @Override
    public void truncateFile(long siz) throws IOException {
    }

    @Override
    public void writeFile(byte[] buf, int len, int pos, long fileOff) throws IOException {
    }
}

