/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.smb.dcerpc;

public class PolicyHandle {
    public static final int POLICY_HANDLE_SIZE = 20;
    private byte[] m_handle;
    private String m_name;

    public PolicyHandle() {
        this.setName("");
    }

    public PolicyHandle(byte[] buf, int off) {
        this.initialize(buf, off);
        this.setName("");
    }

    public PolicyHandle(String name, byte[] buf, int off) {
        this.initialize(buf, off);
        this.setName(name);
    }

    public final boolean isValid() {
        return this.m_handle != null;
    }

    public final byte[] getBytes() {
        return this.m_handle;
    }

    public final String getName() {
        return this.m_name;
    }

    public final void setName(String name) {
        this.m_name = name;
    }

    public final int storePolicyHandle(byte[] buf, int off) {
        if (!this.isValid()) {
            return -1;
        }
        for (int i = 0; i < 20; ++i) {
            buf[off + i] = this.m_handle[i];
        }
        return off + 20;
    }

    public final int loadPolicyHandle(byte[] buf, int off) {
        this.initialize(buf, off);
        return off + 20;
    }

    protected final void clearHandle() {
        this.m_handle = null;
    }

    private final void initialize(byte[] buf, int off) {
        if (off + 20 <= buf.length) {
            this.m_handle = new byte[20];
            for (int i = 0; i < 20; ++i) {
                this.m_handle[i] = buf[off + i];
            }
        }
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        str.append("[");
        if (this.getName() != null) {
            str.append(this.getName());
        }
        str.append(":");
        if (this.isValid()) {
            for (int i = 0; i < 20; ++i) {
                int val = this.m_handle[i] & 0xFF;
                if (val <= 16) {
                    str.append("0");
                }
                str.append(Integer.toHexString(val).toUpperCase());
                str.append("-");
            }
            str.setLength(str.length() - 1);
            str.append("]");
        }
        return str.toString();
    }
}

