/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.server.filesys.db;

import java.io.IOException;
import org.alfresco.jlan.debug.Debug;
import org.alfresco.jlan.server.filesys.AccessDeniedException;
import org.alfresco.jlan.server.filesys.FileInfo;
import org.alfresco.jlan.server.filesys.FileOfflineException;
import org.alfresco.jlan.server.filesys.cache.FileState;
import org.alfresco.jlan.server.filesys.cache.FileStateProxy;
import org.alfresco.jlan.server.filesys.db.DBNetworkFile;
import org.alfresco.jlan.server.filesys.loader.FileLoader;
import org.alfresco.jlan.server.filesys.loader.FileRequest;
import org.alfresco.jlan.server.filesys.loader.FileSegment;
import org.alfresco.jlan.server.filesys.loader.SingleFileRequest;

public class CachedNetworkFile
extends DBNetworkFile {
    protected static final long DataLoadWaitTime = 20000L;
    protected static final long DataPollSleepTime = 250L;
    private static final boolean DEBUG = false;
    protected FileSegment m_cacheFile;
    protected long m_lastReadPos = -1L;
    protected int m_lastReadLen = -1;
    protected int m_seqReads;
    protected boolean m_seqOnly;

    public CachedNetworkFile(String name, int fid, int stid, int did, FileStateProxy state, FileSegment segment, FileLoader loader) {
        super(name, fid, stid, did);
        this.m_cacheFile = segment;
        this.setFileState(state);
        this.setLoader(loader);
    }

    public final FileSegment getFileSegment() {
        return this.m_cacheFile;
    }

    public final boolean isSequentialOnly() {
        return this.m_seqOnly;
    }

    public final void setSequentialOnly(boolean seq) {
        this.m_seqOnly = seq;
    }

    @Override
    public void openFile(boolean createFlag) throws IOException {
        if (!this.m_cacheFile.fileExists()) {
            this.m_cacheFile.createTemporaryFile();
        }
        this.m_cacheFile.openFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int readFile(byte[] buf, int len, int pos, long fileOff) throws IOException {
        boolean seqRead = false;
        if (this.m_lastReadPos != -1L && fileOff == this.m_lastReadPos + (long)this.m_lastReadLen) {
            seqRead = true;
            ++this.m_seqReads;
        }
        if (this.m_cacheFile.hasStatus() == 7) {
            throw new IOException("Load file error - " + this.getFullName());
        }
        this.m_lastReadPos = fileOff;
        this.m_lastReadLen = len;
        if (this.m_cacheFile.hasStatus() == 0 && !this.m_cacheFile.isQueued()) {
            if (!this.m_cacheFile.fileExists()) {
                this.m_cacheFile.createTemporaryFile();
            }
            FileState fileState = this.getFileState();
            synchronized (fileState) {
                if (!this.m_cacheFile.isQueued()) {
                    this.getLoader().queueFileRequest(this.createFileRequest(0));
                }
            }
        }
        int rdlen = 0;
        if (this.m_cacheFile.isDataAvailable()) {
            rdlen = this.m_cacheFile.readBytes(buf, len, pos, fileOff);
            if (rdlen <= 0) {
                this.m_cacheFile.closeFile();
                this.m_cacheFile.openFile();
                rdlen = this.m_cacheFile.readBytes(buf, len, pos, fileOff);
            }
            return rdlen;
        }
        long waitTime = 0L;
        boolean readDone = false;
        boolean dataAvailable = false;
        while (!readDone && waitTime < 20000L && (this.m_cacheFile.isDataLoading() || this.m_cacheFile.isDataAvailable())) {
            dataAvailable = this.m_cacheFile.isDataAvailable();
            if (!dataAvailable) {
                long fileLen = this.m_cacheFile.getReadableLength();
                if (fileLen != -1L && fileLen + 65535L > fileOff + (long)len) {
                    rdlen = this.m_cacheFile.readBytes(buf, len, pos, fileOff);
                }
            } else {
                rdlen = this.m_cacheFile.readBytes(buf, len, pos, fileOff);
            }
            if (rdlen > 0) {
                if (!dataAvailable && rdlen < len) {
                    readDone = false;
                    continue;
                }
                readDone = true;
                continue;
            }
            if (dataAvailable) {
                readDone = true;
                continue;
            }
            try {
                this.setIOPending(true);
                long startTime = System.currentTimeMillis();
                this.m_cacheFile.waitForData(250L);
                long endTime = System.currentTimeMillis();
                waitTime += endTime - startTime;
                this.setIOPending(false);
            }
            catch (Exception ex) {
                // empty catch block
            }
            if (!this.m_cacheFile.hasLoadError()) continue;
            throw new IOException("Load file error - " + this.getFullName());
        }
        if (this.m_cacheFile.hasLoadError()) {
            throw new IOException("Load file error - " + this.getFullName());
        }
        if (readDone) {
            return rdlen;
        }
        throw new FileOfflineException("File data not available");
    }

    @Override
    public void writeFile(byte[] buf, int len, int pos, long offset) throws IOException {
        if (this.getGrantedAccess() == 1) {
            throw new AccessDeniedException("File is read-only");
        }
        this.m_cacheFile.writeBytes(buf, len, pos, offset);
        this.incrementWriteCount();
        long fileLen = this.m_cacheFile.getFileLength();
        if (fileLen != -1L) {
            this.updateFileSize(fileLen, -1L);
        }
    }

    @Override
    public void flushFile() throws IOException {
        if (this.m_cacheFile != null && this.m_cacheFile.isOpen()) {
            this.m_cacheFile.flush();
        }
    }

    @Override
    public long seekFile(long pos, int typ) throws IOException {
        return 0L;
    }

    @Override
    public void truncateFile(long siz) throws IOException {
        if (this.getGrantedAccess() == 1) {
            throw new AccessDeniedException("File is read-only");
        }
        this.m_cacheFile.truncate(siz);
        this.updateFileSize(siz, siz);
        this.incrementWriteCount();
    }

    @Override
    public void closeFile() {
        if (this.m_cacheFile != null) {
            try {
                long fileSize;
                if (this.m_cacheFile.isDataAvailable() && this.m_cacheFile.isOpen() && (fileSize = this.m_cacheFile.getFileLength()) != -1L) {
                    this.setFileSize(fileSize);
                }
                this.m_cacheFile.closeFile();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    protected final void updateFileSize(long siz, long alloc) {
        FileInfo finfo;
        if (this.hasFileState() && (finfo = (FileInfo)this.getFileState().findAttribute("FileInfo")) != null && finfo.getSize() != siz) {
            finfo.setSize(siz);
            if (alloc != -1L || finfo.getSize() > finfo.getAllocationSize()) {
                finfo.setAllocationSize(alloc);
            }
        }
        this.setFileSize(siz);
    }

    protected FileRequest createFileRequest(int typ) {
        return new SingleFileRequest(typ, this.getFileId(), this.getStreamId(), this.m_cacheFile.getInfo(), this.getFullName(), this.getFileState());
    }

    protected final boolean hasDebug() {
        return false;
    }

    protected void finalize() {
        if (this.m_cacheFile != null && this.m_cacheFile.isOpen()) {
            try {
                this.m_cacheFile.closeFile();
                this.m_cacheFile = null;
            }
            catch (Exception ex) {
                Debug.println(ex);
            }
        }
    }
}

