/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.server.filesys;

public class NotifyChange {
    public static final int FileName = 1;
    public static final int DirectoryName = 2;
    public static final int Attributes = 4;
    public static final int Size = 8;
    public static final int LastWrite = 16;
    public static final int LastAccess = 32;
    public static final int Creation = 64;
    public static final int Security = 256;
    public static final int ActionAdded = 1;
    public static final int ActionRemoved = 2;
    public static final int ActionModified = 3;
    public static final int ActionRenamedOldName = 4;
    public static final int ActionRenamedNewName = 5;
    public static final int ActionAddedStream = 6;
    public static final int ActionRemovedStream = 7;
    public static final int ActionModifiedStream = 8;
    private static final String[] _actnNames = new String[]{"Added", "Removed", "Modified", "RenamedOldName", "RenamedNewName", "AddedStream", "RemovedStream", "ModifiedStream"};

    public static final String getActionAsString(int action) {
        if (action <= 0 || action > _actnNames.length) {
            return "Unknown";
        }
        return _actnNames[action - 1];
    }

    public static final String getFilterAsString(int filter) {
        if (filter == 0) {
            return "";
        }
        String filtStr = null;
        switch (filter) {
            case 1: {
                filtStr = "FileName";
                break;
            }
            case 2: {
                filtStr = "DirectoryName";
                break;
            }
            case 4: {
                filtStr = "Attributes";
                break;
            }
            case 8: {
                filtStr = "Size";
                break;
            }
            case 16: {
                filtStr = "LastWrite";
                break;
            }
            case 32: {
                filtStr = "LastAccess";
                break;
            }
            case 64: {
                filtStr = "Creation";
                break;
            }
            case 256: {
                filtStr = "Security";
            }
        }
        return filtStr;
    }

    public static final String getFilterFlagsAsString(int filter) {
        if (filter == 0) {
            return "";
        }
        StringBuffer filtStr = new StringBuffer();
        for (int i = 1; i < 256; i <<= 1) {
            String name;
            if ((filter & i) == 0 || (name = NotifyChange.getFilterAsString(i)) == null) continue;
            if (filtStr.length() > 0) {
                filtStr.append(",");
            }
            filtStr.append(name);
        }
        return filtStr.toString();
    }
}

