/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.server.auth.asn;

import java.io.IOException;
import org.alfresco.jlan.server.auth.asn.DERBuffer;
import org.alfresco.jlan.server.auth.asn.DERObject;

public class DERInteger
extends DERObject {
    private long m_integer;

    public DERInteger() {
    }

    public DERInteger(int val) {
        this.m_integer = val;
    }

    public DERInteger(long val) {
        this.m_integer = val;
    }

    public final long getValue() {
        return this.m_integer;
    }

    public final int intValue() {
        return (int)this.m_integer;
    }

    @Override
    public void derDecode(DERBuffer buf) throws IOException {
        if (buf.unpackType() == 2) {
            int len = buf.unpackByte();
            this.m_integer = 0L;
            if (len == 1) {
                this.m_integer = buf.unpackByte();
            } else if (len > 1) {
                while (len-- > 0) {
                    this.m_integer = (this.m_integer << 8) + (long)buf.unpackByte();
                }
            }
        } else {
            throw new IOException("Wrong DER type, expected Integer");
        }
    }

    @Override
    public void derEncode(DERBuffer buf) throws IOException {
        int bytLen;
        buf.packByte(2);
        for (bytLen = 8; bytLen > 0 && (this.m_integer & 255L << (bytLen - 1) * 8) == 0L; --bytLen) {
        }
        buf.packLength(bytLen);
        while (bytLen > 0) {
            buf.packByte((int)(this.m_integer >> --bytLen * 8) & 0xFF);
        }
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        str.append("[Integer:");
        str.append(this.getValue());
        str.append("]");
        return str.toString();
    }
}

