/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.server.auth.asn;

import java.io.IOException;
import org.alfresco.jlan.server.auth.asn.DERBuffer;
import org.alfresco.jlan.server.auth.asn.DERObject;

public class DERBoolean
extends DERObject {
    private boolean m_bool;

    public DERBoolean() {
    }

    public DERBoolean(boolean bool) {
        this.m_bool = bool;
    }

    public final boolean getValue() {
        return this.m_bool;
    }

    @Override
    public void derDecode(DERBuffer buf) throws IOException {
        if (buf.unpackType() != 1) {
            throw new IOException("Wrong DER type, expected Boolean");
        }
        buf.unpackByte();
        this.m_bool = buf.unpackByte() == 255;
    }

    @Override
    public void derEncode(DERBuffer buf) throws IOException {
        buf.packByte(1);
        buf.packByte(1);
        buf.packByte(this.m_bool ? 255 : 0);
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        str.append("[Boolean:");
        str.append(this.m_bool);
        str.append("]");
        return str.toString();
    }
}

