/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.oncrpc.nfs;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import org.alfresco.jlan.debug.Debug;
import org.alfresco.jlan.oncrpc.RpcAuthenticator;
import org.alfresco.jlan.oncrpc.nfs.NFSSrvSession;
import org.alfresco.jlan.server.SrvSession;
import org.alfresco.jlan.server.filesys.DiskInterface;
import org.alfresco.jlan.server.filesys.NetworkFile;
import org.alfresco.jlan.server.filesys.TreeConnection;

public class NetworkFileCache {
    public static final long DefaultFileTimeout = 5000L;
    public static final long ClosedFileTimeout = 30000L;
    private Hashtable<Integer, FileEntry> m_fileCache = new Hashtable();
    private FileExpiry m_expiryThread;
    private long m_fileIOTmo = 5000L;
    private long m_fileCloseTmo = 30000L;
    private RpcAuthenticator m_authenticator;
    private boolean m_debug = false;

    public NetworkFileCache(String name) {
        this.m_expiryThread = new FileExpiry(name);
    }

    public final boolean hasDebug() {
        return this.m_debug;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void addFile(NetworkFile file, TreeConnection conn, NFSSrvSession sess) {
        Hashtable<Integer, FileEntry> hashtable = this.m_fileCache;
        synchronized (hashtable) {
            this.m_fileCache.put(new Integer(file.getFileId()), new FileEntry(file, conn, sess));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void removeFile(int id) {
        Integer fileId = new Integer(id);
        Hashtable<Integer, FileEntry> hashtable = this.m_fileCache;
        synchronized (hashtable) {
            this.m_fileCache.remove(fileId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized NetworkFile findFile(int id, SrvSession sess) {
        Integer fileId = new Integer(id);
        FileEntry fentry = null;
        Hashtable<Integer, FileEntry> hashtable = this.m_fileCache;
        synchronized (hashtable) {
            fentry = this.m_fileCache.get(fileId);
        }
        if (fentry != null) {
            fentry.updateTimeout();
            if (fentry.isClosed()) {
                fentry.openFile();
            }
            return fentry.getFile();
        }
        return null;
    }

    public final int numberOfEntries() {
        return this.m_fileCache.size();
    }

    public final void closeAllFiles() {
        Enumeration<Integer> keys = this.m_fileCache.keys();
        while (keys.hasMoreElements()) {
            Integer key = keys.nextElement();
            FileEntry entry = this.m_fileCache.get(key);
            entry.updateTimeout(0L);
        }
        this.m_expiryThread.requestShutdown();
    }

    public final void setDebug(boolean ena) {
        this.m_debug = ena;
    }

    public final void setIOTimer(long ioTimer) {
        this.m_fileIOTmo = ioTimer;
    }

    public final void setCloseTimer(long closeTimer) {
        this.m_fileCloseTmo = closeTimer;
    }

    public final void setRpcAuthenticator(RpcAuthenticator auth) {
        this.m_authenticator = auth;
    }

    public final void dumpCache() {
        Debug.println("NetworkFileCache entries=" + this.numberOfEntries());
        Enumeration<Integer> keys = this.m_fileCache.keys();
        while (keys.hasMoreElements()) {
            Integer key = keys.nextElement();
            FileEntry entry = this.m_fileCache.get(key);
            Debug.println("fid=" + key + ": " + entry);
        }
    }

    protected class FileExpiry
    implements Runnable {
        private Thread m_thread = new Thread(this);
        private boolean m_shutdown;

        public FileExpiry(String name) {
            this.m_thread.setDaemon(true);
            this.m_thread.setName("NFSFileExpiry_" + name);
            this.m_thread.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!this.m_shutdown) {
                try {
                    Thread.sleep(NetworkFileCache.this.m_fileIOTmo / 2L);
                }
                catch (InterruptedException ex) {
                    // empty catch block
                }
                long timeNow = System.currentTimeMillis();
                Hashtable hashtable = NetworkFileCache.this.m_fileCache;
                synchronized (hashtable) {
                    Enumeration enm = NetworkFileCache.this.m_fileCache.keys();
                    while (enm.hasMoreElements()) {
                        Integer fileId = (Integer)enm.nextElement();
                        FileEntry fentry = (FileEntry)NetworkFileCache.this.m_fileCache.get(fileId);
                        if (fentry == null || fentry.getTimeout() >= timeNow) continue;
                        NetworkFile netFile = fentry.getFile();
                        if (netFile.hasIOPending()) {
                            fentry.updateTimeout();
                            if (!NetworkFileCache.this.hasDebug()) continue;
                            Debug.println("NFSFileExpiry: I/O pending file=" + fentry.getFile().getFullName() + ", fid=" + fileId);
                            continue;
                        }
                        if (fentry.getSession().hasTransaction()) {
                            fentry.getSession().endTransaction();
                        }
                        if (!fentry.isClosed() && netFile != null) {
                            try {
                                NetworkFileCache.this.m_authenticator.setCurrentUser(fentry.getSession(), fentry.getSession().getNFSClientInformation());
                                if (!netFile.allowsOpenCloseViaNetworkFile()) {
                                    fentry.markAsClosed();
                                    if (NetworkFileCache.this.hasDebug()) {
                                        Debug.println("NFSFileExpiry: Marked as closed file=" + fentry.getFile().getFullName() + ", fid=" + fileId + " (cached)");
                                    }
                                } else {
                                    fentry.closeFile();
                                    fentry.updateTimeout(System.currentTimeMillis() + NetworkFileCache.this.m_fileCloseTmo);
                                    if (NetworkFileCache.this.hasDebug()) {
                                        Debug.println("NFSFileExpiry: Closed file=" + fentry.getFile().getFullName() + ", fid=" + fileId + " (cached)");
                                    }
                                }
                                if (fentry.getSession().hasTransaction()) {
                                    fentry.getSession().endTransaction();
                                }
                                NetworkFileCache.this.m_authenticator.setCurrentUser(fentry.getSession(), null);
                            }
                            catch (Exception ex) {
                                if (!NetworkFileCache.this.hasDebug()) continue;
                                Debug.println("Error closing file, fentry=" + fentry + ", ex=" + ex.getMessage());
                                Debug.println(ex);
                            }
                            continue;
                        }
                        NetworkFileCache.this.m_fileCache.remove(fileId);
                        try {
                            NetworkFileCache.this.m_authenticator.setCurrentUser(fentry.getSession(), fentry.getSession().getNFSClientInformation());
                            DiskInterface disk = (DiskInterface)fentry.getConnection().getInterface();
                            if (disk.fileExists(fentry.getSession(), fentry.getConnection(), netFile.getFullName()) != 0) {
                                if (!netFile.isClosed()) {
                                    disk.closeFile(fentry.getSession(), fentry.getConnection(), netFile);
                                    if (NetworkFileCache.this.hasDebug()) {
                                        Debug.println("NFSFileExpiry: Closed file=" + fentry.getFile().getFullName() + ", fid=" + fileId + " (removed)");
                                    }
                                } else if (NetworkFileCache.this.hasDebug()) {
                                    Debug.println("NFSFileExpiry: File already closed, file=" + fentry.getFile().getFullName() + ", fid=" + fileId);
                                }
                            } else if (NetworkFileCache.this.hasDebug()) {
                                Debug.println("NFSFileExpiry: File deleted before close, " + netFile.getFullName());
                            }
                            if (fentry.getSession().hasTransaction()) {
                                fentry.getSession().endTransaction();
                            }
                            NetworkFileCache.this.m_authenticator.setCurrentUser(fentry.getSession(), null);
                        }
                        catch (Exception ex) {
                            if (!NetworkFileCache.this.hasDebug()) continue;
                            Debug.println("Error closing file, fentry=" + fentry + ", ex=" + ex.getMessage());
                            Debug.println(ex);
                        }
                    }
                }
            }
        }

        public final void requestShutdown() {
            this.m_shutdown = true;
            try {
                this.m_thread.interrupt();
            }
            catch (Exception ex) {
                // empty catch block
            }
            try {
                this.m_thread.join(NetworkFileCache.this.m_fileIOTmo);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected class FileEntry {
        private NetworkFile m_file;
        private boolean m_closed;
        private TreeConnection m_conn;
        private long m_timeout;
        private NFSSrvSession m_sess;

        public FileEntry(NetworkFile file, TreeConnection conn, NFSSrvSession sess) {
            this.m_file = file;
            this.m_conn = conn;
            this.m_sess = sess;
            this.updateTimeout();
        }

        public final long getTimeout() {
            return this.m_timeout;
        }

        public final NetworkFile getFile() {
            return this.m_file;
        }

        public final TreeConnection getConnection() {
            return this.m_conn;
        }

        public final NFSSrvSession getSession() {
            return this.m_sess;
        }

        public final void updateTimeout() {
            this.m_timeout = System.currentTimeMillis() + NetworkFileCache.this.m_fileIOTmo;
        }

        public final void updateTimeout(long tmo) {
            this.m_timeout = tmo;
        }

        public final void setSession(NFSSrvSession sess) {
            this.m_sess = sess;
        }

        public final boolean isClosed() {
            return this.m_closed;
        }

        public final void closeFile() {
            if (this.m_file != null) {
                try {
                    this.m_file.closeFile();
                    this.m_closed = true;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }

        public final void openFile() {
            if (this.m_file != null) {
                try {
                    this.m_file.openFile(false);
                    this.m_closed = false;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }

        public final void markAsClosed() {
            if (this.m_file != null) {
                this.m_closed = true;
            }
        }
    }
}

