/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.netbios.win32;

import java.io.IOException;
import java.nio.channels.IllegalBlockingModeException;
import org.alfresco.jlan.netbios.NetBIOSName;
import org.alfresco.jlan.netbios.win32.NetBIOSSelectionKey;
import org.alfresco.jlan.netbios.win32.NetBIOSSelector;
import org.alfresco.jlan.netbios.win32.NetBIOSSocketException;
import org.alfresco.jlan.netbios.win32.Win32NetBIOS;
import org.alfresco.jlan.netbios.win32.WinsockNetBIOSException;

public class NetBIOSSocket {
    public static final int SocketWouldBlock = -2;
    private static boolean _nbSocketInit;
    private int m_lana;
    private int m_socket;
    private NetBIOSName m_nbName;
    private boolean m_listenerSocket;
    private boolean m_nonBlockMode;
    private NetBIOSSelector m_selector;

    public static final void initializeSockets() throws WinsockNetBIOSException {
        if (!_nbSocketInit) {
            Win32NetBIOS.InitializeSockets();
            _nbSocketInit = true;
        }
    }

    public static final void shutdownSockets() {
        if (_nbSocketInit) {
            _nbSocketInit = false;
            Win32NetBIOS.ShutdownSockets();
        }
    }

    public static final boolean isInitialized() {
        return _nbSocketInit;
    }

    public static final int SelectReceiveSockets(int sockCnt, int[] sockList, int[] sockEvent) throws WinsockNetBIOSException {
        return Win32NetBIOS.SelectReceiveSockets(sockCnt, sockList, sockEvent);
    }

    public static final NetBIOSSocket createListenerSocket(int lana, NetBIOSName nbName) throws WinsockNetBIOSException, NetBIOSSocketException {
        return NetBIOSSocket.createListenerSocket(lana, nbName, false);
    }

    public static final NetBIOSSocket createListenerSocket(int lana, NetBIOSName nbName, boolean fastAddName) throws WinsockNetBIOSException, NetBIOSSocketException {
        NetBIOSSocket.initializeSockets();
        int sockPtr = Win32NetBIOS.CreateSocket(lana);
        if (sockPtr == 0) {
            throw new NetBIOSSocketException("Failed to create NetBIOS socket");
        }
        if (Win32NetBIOS.BindSocket(sockPtr, nbName.getNetBIOSName(), fastAddName) != 0) {
            throw new NetBIOSSocketException("Failed to bind NetBIOS socket");
        }
        return new NetBIOSSocket(lana, sockPtr, nbName, true);
    }

    public static final NetBIOSSocket connectSocket(int lana, NetBIOSName remoteName) throws WinsockNetBIOSException, NetBIOSSocketException {
        NetBIOSSocket.initializeSockets();
        int sockPtr = Win32NetBIOS.CreateSocket(lana);
        if (sockPtr == 0) {
            throw new NetBIOSSocketException("Failed to create NetBIOS socket");
        }
        Win32NetBIOS.ConnectSocket(sockPtr, remoteName.getNetBIOSName());
        return new NetBIOSSocket(lana, sockPtr, remoteName, false);
    }

    private NetBIOSSocket(int lana, int sockPtr, NetBIOSName nbName, boolean listener) {
        this.m_lana = lana;
        this.m_nbName = nbName;
        this.m_socket = sockPtr;
        this.m_listenerSocket = listener;
    }

    public final int getLana() {
        return this.m_lana;
    }

    public final boolean isListener() {
        return this.m_listenerSocket;
    }

    public final boolean hasSocket() {
        return this.m_socket != 0;
    }

    public final int getSocket() {
        return this.m_socket;
    }

    public final NetBIOSName getName() {
        return this.m_nbName;
    }

    public final void configureBlocking(boolean nonBlocking) throws WinsockNetBIOSException {
        Win32NetBIOS.SetNonBlockingSocket(this.getSocket(), nonBlocking);
        this.m_nonBlockMode = !nonBlocking;
    }

    public final int write(byte[] buf, int off, int len) throws WinsockNetBIOSException {
        return Win32NetBIOS.SendSocket(this.getSocket(), buf, off, len);
    }

    public final int available() throws WinsockNetBIOSException {
        return Win32NetBIOS.ReceiveLengthSocket(this.getSocket());
    }

    public final int read(byte[] buf, int off, int maxLen) throws WinsockNetBIOSException {
        return Win32NetBIOS.ReceiveSocket(this.getSocket(), buf, off, maxLen);
    }

    public final NetBIOSSocket accept() throws WinsockNetBIOSException, NetBIOSSocketException {
        if (!this.isListener()) {
            throw new NetBIOSSocketException("Not a listener type socket");
        }
        if (!this.hasSocket()) {
            throw new NetBIOSSocketException("NetBIOS socket not valid");
        }
        byte[] callerName = new byte[16];
        int sessSockPtr = Win32NetBIOS.ListenSocket(this.getSocket(), callerName);
        if (sessSockPtr == 0) {
            throw new NetBIOSSocketException("NetBIOS socket listen failed");
        }
        return new NetBIOSSocket(this.getLana(), sessSockPtr, new NetBIOSName(callerName, 0), false);
    }

    public final void closeSocket() {
        if (this.hasSocket()) {
            if (this.m_selector != null) {
                try {
                    this.m_selector.deregisterSocket(this);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.m_selector = null;
            }
            Win32NetBIOS.CloseSocket(this.getSocket());
            this.setSocket(0);
        }
    }

    public final boolean isNonBlocking() {
        return this.m_nonBlockMode;
    }

    protected final void setSocket(int sockPtr) {
        this.m_socket = sockPtr;
    }

    public final NetBIOSSelectionKey register(NetBIOSSelector selector, int ops, Object attachment) throws IllegalBlockingModeException, IOException {
        if (!this.isNonBlocking()) {
            throw new IllegalBlockingModeException();
        }
        if (selector == null) {
            throw new IOException("Null NetBIOS selector");
        }
        NetBIOSSelectionKey selKey = selector.registerSocket(this, ops);
        if (selKey != null) {
            selKey.attach(attachment);
            this.m_selector = selector;
        }
        return selKey;
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        str.append("[LANA:");
        str.append(this.getLana());
        str.append(",Name:");
        str.append(this.getName());
        str.append(",Socket:");
        if (this.hasSocket()) {
            str.append("0x");
            str.append(Integer.toHexString(this.getSocket()));
        } else {
            str.append("<None>");
        }
        if (this.isListener()) {
            str.append(",Listener");
        }
        if (this.isNonBlocking()) {
            str.append(",NonBlocking");
        }
        str.append("]");
        return str.toString();
    }

    public int hashCode() {
        return this.getSocket();
    }
}

