/*
 * Decompiled with CFR 0.152.
 */
package net.timewalker.ffmq4.transport.tcp.io;

import java.io.IOException;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.URI;
import javax.jms.JMSException;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import net.timewalker.ffmq4.FFMQException;
import net.timewalker.ffmq4.transport.PacketTransportException;
import net.timewalker.ffmq4.transport.packet.AbstractPacket;
import net.timewalker.ffmq4.transport.tcp.AbstractTcpPacketTransport;
import net.timewalker.ffmq4.transport.tcp.SocketUtils;
import net.timewalker.ffmq4.transport.tcp.io.NetworkInputChannel;
import net.timewalker.ffmq4.transport.tcp.io.NetworkOutputChannel;
import net.timewalker.ffmq4.transport.tcp.io.TcpBufferedInputStream;
import net.timewalker.ffmq4.transport.tcp.io.TcpBufferedOutputStream;
import net.timewalker.ffmq4.transport.tcp.io.TcpPacketReceiver;
import net.timewalker.ffmq4.transport.tcp.io.TcpPacketSender;
import net.timewalker.ffmq4.utils.Settings;
import net.timewalker.ffmq4.utils.ssl.PermissiveTrustManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class TcpPacketTransport
extends AbstractTcpPacketTransport {
    private static final Log log = LogFactory.getLog(TcpPacketTransport.class);
    private Settings settings;
    private int maxPacketSize;
    private Socket socket;
    private TcpPacketReceiver receiver;
    private TcpPacketSender sender;
    private Thread receiverThread;
    private Thread senderThread;

    public TcpPacketTransport(String id, URI transportURI, Settings settings) throws PacketTransportException {
        super(id, true, settings);
        this.init(settings);
        this.socket = this.connect(transportURI);
    }

    public TcpPacketTransport(String id, Socket socket, Settings settings) throws PacketTransportException {
        super(id, false, settings);
        this.socket = SocketUtils.setupSocket(socket, this.socketSendBufferSize, this.socketRecvBufferSize);
        this.init(settings);
    }

    private void init(Settings settings) {
        this.settings = settings;
        this.maxPacketSize = settings.getIntProperty("transport.tcp.packet.maxSize", 0x100400);
    }

    @Override
    public SocketAddress getRemotePeer() {
        Socket sock = this.socket;
        return sock != null ? sock.getRemoteSocketAddress() : null;
    }

    private Socket connect(URI transportURI) throws PacketTransportException {
        String protocol = transportURI.getScheme();
        String host = transportURI.getHost();
        int port = transportURI.getPort();
        int connectTimeout = this.settings.getIntProperty("transport.tcp.connectTimeout", 30);
        try {
            Socket socket = SocketUtils.setupSocket(this.createSocket(protocol), this.socketSendBufferSize, this.socketRecvBufferSize);
            log.debug((Object)("#" + this.id + " opening a TCP connection to " + host + ":" + port));
            socket.connect(new InetSocketAddress(host, port), connectTimeout * 1000);
            return socket;
        }
        catch (ConnectException e) {
            log.error((Object)("#" + this.id + " could not connect to " + host + ":" + port + " (timeout=" + connectTimeout + "s) : " + e.getMessage()));
            throw new PacketTransportException("Could not connect to " + host + ":" + port + " : " + e.toString());
        }
        catch (Exception e) {
            log.error((Object)("#" + this.id + " could not connect to " + host + ":" + port + " (timeout=" + connectTimeout + "s)"), (Throwable)e);
            throw new PacketTransportException("Could not connect to " + host + ":" + port + " : " + e.toString());
        }
    }

    private Socket createSocket(String protocol) throws JMSException {
        if (protocol.equals("tcps")) {
            try {
                return this.createSSLContext().getSocketFactory().createSocket();
            }
            catch (IOException e) {
                throw new FFMQException("Cannot create SSL socket", "TRANSPORT_ERROR", e);
            }
        }
        return new Socket();
    }

    private SSLContext createSSLContext() throws JMSException {
        try {
            String sslProtocol = this.settings.getStringProperty("transport.tcp.ssl.protocol", "SSLv3");
            boolean ignoreCertificates = this.settings.getBooleanProperty("transport.tcp.ssl.ignoreCertificates", false);
            String trustManagerClass = this.settings.getStringProperty("transport.tcp.ssl.trustManager");
            SSLContext sslContext = SSLContext.getInstance(sslProtocol);
            log.debug((Object)("#" + this.id + " created an SSL context : protocol=[" + sslContext.getProtocol() + "] provider=[" + sslContext.getProvider() + "]"));
            KeyManager[] keyManagers = null;
            TrustManager[] trustManagers = null;
            if (ignoreCertificates) {
                trustManagers = new TrustManager[]{new PermissiveTrustManager()};
            } else if (trustManagerClass != null) {
                trustManagers = new TrustManager[]{(TrustManager)Class.forName(trustManagerClass, true, Thread.currentThread().getContextClassLoader()).newInstance()};
            }
            sslContext.init(keyManagers, trustManagers, null);
            return sslContext;
        }
        catch (Exception e) {
            throw new FFMQException("Cannot create SSL context", "TRANSPORT_ERROR", e);
        }
    }

    @Override
    public void start() throws PacketTransportException {
        try {
            NetworkInputChannel inputChannel = new NetworkInputChannel(this.initialPacketBufferSize, new TcpBufferedInputStream(this.socket.getInputStream(), this.streamRecvBufferSize));
            NetworkOutputChannel outputChannel = new NetworkOutputChannel(this.initialPacketBufferSize, new TcpBufferedOutputStream(this.socket.getOutputStream(), this.streamSendBufferSize));
            this.sender = new TcpPacketSender(this, outputChannel, this.listener, this.client ? this.pingInterval : -1, this.sendQueueMaxSize);
            this.receiver = new TcpPacketReceiver(this, inputChannel, this.listener, this.pingInterval, this.client ? -1 : this.maxPacketSize);
            this.senderThread = new Thread((Runnable)this.sender, "TcpPacketSender[" + (this.client ? "client" : "server") + "]");
            this.senderThread.start();
            this.receiverThread = new Thread((Runnable)this.receiver, "TcpPacketReceiver[" + (this.client ? "client" : "server") + "]");
            this.receiverThread.start();
        }
        catch (Exception e) {
            log.error((Object)("#" + this.id + " cannot start TCP packet I/O handlers"), (Throwable)e);
            throw new PacketTransportException("Cannot start TCP packet I/O handlers : " + e.toString());
        }
    }

    @Override
    public void send(AbstractPacket packet) throws PacketTransportException {
        if (this.closed) {
            throw new PacketTransportException("Transport is closed");
        }
        this.sender.send(packet);
    }

    @Override
    public boolean needsThrottling() {
        return this.sender.needsThrottling();
    }

    protected void closeSocket() {
        try {
            if (this.socket != null) {
                this.socket.close();
            }
        }
        catch (Exception e) {
            log.error((Object)("#" + this.id + " cannot close socket"), (Throwable)e);
        }
        finally {
            this.socket = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeTransport(boolean linkFailed) {
        Object object = this.closeLock;
        synchronized (object) {
            if (this.closed) {
                return;
            }
            this.closed = true;
        }
        if (this.sender != null) {
            this.sender.pleaseStop();
        }
        if (this.receiver != null) {
            this.receiver.pleaseStop();
        }
        this.closeSocket();
        if (this.listener != null) {
            this.listener.transportClosed(linkFailed, true);
        }
    }

    @Override
    public void close() {
        this.closeTransport(false);
        try {
            if (this.receiverThread != null && Thread.currentThread() != this.receiverThread) {
                this.receiverThread.join();
            }
        }
        catch (InterruptedException e) {
            log.error((Object)("#" + this.id + " wait for receiver thread termination was interrupted."));
        }
        try {
            if (this.senderThread != null && Thread.currentThread() != this.senderThread) {
                this.senderThread.join();
            }
        }
        catch (InterruptedException e) {
            log.error((Object)("#" + this.id + " wait for sender thread termination was interrupted."));
        }
    }
}

