/*
 * Decompiled with CFR 0.152.
 */
package net.timewalker.ffmq4.storage.data.impl.journal;

import java.io.IOException;
import java.io.RandomAccessFile;
import net.timewalker.ffmq4.storage.data.impl.journal.AbstractMetaDataWriteOperation;
import net.timewalker.ffmq4.storage.data.impl.journal.JournalException;
import net.timewalker.ffmq4.storage.data.impl.journal.JournalFile;

public final class MetaDataWriteOperation
extends AbstractMetaDataWriteOperation {
    private int metaData;

    public MetaDataWriteOperation(long transactionId, long metaDataOffset, int metaData) {
        super(transactionId, (byte)2, metaDataOffset);
        this.metaData = metaData;
    }

    public int getMetaData() {
        return this.metaData;
    }

    @Override
    public int size() {
        return super.size() + 4;
    }

    @Override
    protected void writeTo(JournalFile journalFile) throws JournalException {
        super.writeTo(journalFile);
        journalFile.writeInt(this.metaData);
    }

    protected int writeTo(RandomAccessFile allocationTableRandomAccessFile) throws JournalException {
        try {
            allocationTableRandomAccessFile.seek(this.offset);
            allocationTableRandomAccessFile.writeInt(this.metaData);
        }
        catch (IOException e) {
            throw new JournalException("Cannot write to store allocation table file", e);
        }
        return 4;
    }

    @Override
    public String toString() {
        return super.toString() + " [META_DATA] metaData=" + this.metaData;
    }
}

