/*
 * Decompiled with CFR 0.152.
 */
package net.timewalker.ffmq4.local;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.timewalker.ffmq4.FFMQException;
import net.timewalker.ffmq4.local.TransactionItem;
import net.timewalker.ffmq4.local.destination.LocalQueue;

public final class TransactionSet {
    private LinkedList<TransactionItem> items = new LinkedList();

    public synchronized void add(int handle, String messageID, int deliveryMode, LocalQueue destination) {
        TransactionItem item = new TransactionItem(handle, messageID, deliveryMode, destination);
        this.items.add(item);
    }

    public synchronized void add(TransactionItem item) {
        this.items.add(item);
    }

    public synchronized void removeUpdatesForQueue(String queueName) {
        Iterator entries = this.items.iterator();
        while (entries.hasNext()) {
            TransactionItem item = (TransactionItem)entries.next();
            if (!item.getDestination().getName().equals(queueName)) continue;
            entries.remove();
        }
    }

    public synchronized int size() {
        return this.items.size();
    }

    public synchronized TransactionItem[] clear(List<String> deliveredMessageIDs) throws FFMQException {
        int len = deliveredMessageIDs.size();
        TransactionItem[] itemsSnapshot = new TransactionItem[len];
        for (int n = 0; n < len; ++n) {
            String deliveredMessageID = deliveredMessageIDs.get(len - n - 1);
            boolean found = false;
            Iterator entries = this.items.iterator();
            while (entries.hasNext()) {
                TransactionItem item = (TransactionItem)entries.next();
                if (!item.getMessageId().equals(deliveredMessageID)) continue;
                found = true;
                itemsSnapshot[n] = item;
                entries.remove();
                break;
            }
            if (found) continue;
            throw new FFMQException("Message does not belong to transaction : " + deliveredMessageID, "INTERNAL_ERROR");
        }
        return itemsSnapshot;
    }

    public synchronized TransactionItem[] clear() {
        TransactionItem[] itemsSnapshot = this.items.toArray(new TransactionItem[this.items.size()]);
        this.items.clear();
        return itemsSnapshot;
    }

    public synchronized List<LocalQueue> updatedQueues() {
        ArrayList<LocalQueue> updatedQueues = new ArrayList<LocalQueue>(this.items.size());
        for (int i = 0; i < this.items.size(); ++i) {
            TransactionItem item = this.items.get(i);
            LocalQueue localQueue = item.getDestination();
            if (updatedQueues.contains(localQueue)) continue;
            updatedQueues.add(localQueue);
        }
        return updatedQueues;
    }

    public synchronized List<LocalQueue> updatedQueues(List<String> deliveredMessageIDs) throws FFMQException {
        int len = deliveredMessageIDs.size();
        ArrayList<LocalQueue> updatedQueues = new ArrayList<LocalQueue>(len);
        for (int n = 0; n < len; ++n) {
            String deliveredMessageID = deliveredMessageIDs.get(len - n - 1);
            boolean found = false;
            for (TransactionItem item : this.items) {
                if (!item.getMessageId().equals(deliveredMessageID)) continue;
                found = true;
                LocalQueue localQueue = item.getDestination();
                if (updatedQueues.contains(localQueue)) break;
                updatedQueues.add(localQueue);
                break;
            }
            if (found) continue;
            throw new FFMQException("Message does not belong to transaction : " + deliveredMessageID, "INTERNAL_ERROR");
        }
        return updatedQueues;
    }
}

