/*
 * Decompiled with CFR 0.152.
 */
package net.timewalker.ffmq4.common.session;

import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import net.timewalker.ffmq4.FFMQException;
import net.timewalker.ffmq4.common.session.AbstractQueueBrowserEnumeration;
import net.timewalker.ffmq4.common.session.AbstractSession;
import net.timewalker.ffmq4.utils.JavaTools;
import net.timewalker.ffmq4.utils.id.IntegerID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractQueueBrowser
implements QueueBrowser {
    private static final Log log = LogFactory.getLog(AbstractQueueBrowser.class);
    protected IntegerID id;
    protected Queue queue;
    protected String messageSelector;
    protected Object closeLock = new Object();
    protected boolean closed;
    protected AbstractSession session;
    private Map<String, AbstractQueueBrowserEnumeration> enumMap = new Hashtable<String, AbstractQueueBrowserEnumeration>();

    public AbstractQueueBrowser(AbstractSession session, Queue queue, String messageSelector, IntegerID browserId) {
        this.session = session;
        this.queue = queue;
        this.messageSelector = messageSelector;
        this.id = browserId;
    }

    public final IntegerID getId() {
        return this.id;
    }

    protected final void registerEnumeration(AbstractQueueBrowserEnumeration queueBrowserEnum) {
        this.enumMap.put(queueBrowserEnum.getId(), queueBrowserEnum);
    }

    protected final void unregisterEnumeration(AbstractQueueBrowserEnumeration queueBrowserEnum) {
        this.enumMap.put(queueBrowserEnum.getId(), queueBrowserEnum);
    }

    public final AbstractQueueBrowserEnumeration lookupRegisteredEnumeration(String enumId) {
        return this.enumMap.get(enumId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeRemainingEnumerations() {
        Vector<AbstractQueueBrowserEnumeration> enumsToClose = new Vector<AbstractQueueBrowserEnumeration>();
        Map<String, AbstractQueueBrowserEnumeration> map = this.enumMap;
        synchronized (map) {
            enumsToClose.addAll(this.enumMap.values());
            for (int n = 0; n < enumsToClose.size(); ++n) {
                AbstractQueueBrowserEnumeration queueBrowserEnum = (AbstractQueueBrowserEnumeration)enumsToClose.get(n);
                log.debug((Object)("Auto-closing unclosed queue browser enumeration : " + queueBrowserEnum));
                try {
                    queueBrowserEnum.close();
                    continue;
                }
                catch (Exception e) {
                    log.error((Object)("Could not close queue browser enumeration " + queueBrowserEnum), (Throwable)e);
                }
            }
        }
    }

    public final String getMessageSelector() throws JMSException {
        return this.messageSelector;
    }

    public final Queue getQueue() throws JMSException {
        return this.queue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void close() throws JMSException {
        Object object = this.closeLock;
        synchronized (object) {
            if (this.closed) {
                return;
            }
            this.closed = true;
            this.onQueueBrowserClose();
        }
    }

    protected void onQueueBrowserClose() {
        this.session.unregisterBrowser(this);
        this.closeRemainingEnumerations();
    }

    public final void checkNotClosed() throws JMSException {
        if (this.closed) {
            throw new FFMQException("Queue browser is closed", "QUEUE_BROWSER_CLOSED");
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(JavaTools.getShortClassName(this.getClass()));
        sb.append("[#");
        sb.append(this.id);
        sb.append("] queue=");
        sb.append(this.queue);
        sb.append("] messageSelector=");
        sb.append(this.messageSelector);
        return sb.toString();
    }
}

